%=========================================================================%
%                                                                         %
%                                                                         %
%                    Resolution of 1D Poisson equation                    %
%                                                                         %
%              Wavelet liked by differentiation / integration             %
%                                                                         %
%                                                                         %
%=========================================================================%
%
%
%    
%
%
%
function vs=Poisson_1D_AMRD_Bord(j,L)
%%
%
%
close all;
clf;
%
%
%
%
%==================     Daubechies   filters     =========================%
% 
%
%
r0=3;
%
%
h0 = MakeONFilter('Daubechies',2*r0);

d0=1;l01=-r0+1;l02=r0;
% 
% 
[h1,H10,H11,~,h1d,~,g1,~,~,~,~,~,H10CL,H11CL,~,~,G10CL,G11CL,G10CLd,G11CLd]=Filtre_AMRDOrthoCalcule(r0);
%
%
%
%
l11=l01;l12=l02+1;r1=r0+1;
l11_1=l01+1;l12_1=l02;r1_1=r0-1;
%
%
%
%
%
%==========        Quadratures weigt coefficients            =============%
%
%
[Vb10,Vint1,Vb11,Pb10,Pbint1,Pb11,~,~,~,Pb10d,Pbint1d,Pb11d]=Poids_Valeur_AMRDOrthoCalcule(r0);
%
%
%
%
%
%============      Matrice de Passage de dV^1--->  V^0       =============%
%
%
%
%
%
%
gr0=Gram_bord(h0,h0,l01,l02,l01,l02,d0,r0,r0,0);
gr1=rot90(Gram_bord(h0,h0,l01,l02,l01,l02,d0,r0,r0,1),2);
%
%
Ld0=Matchange_V1_V0(h1d,l11,l12,l11_1,l12_1,d0,r1,L,gr0,gr1);
%
% 
%
%
%=========     Edge functions orthogonalization for V^0_j     ============%
%
%
%
[ng,mg]=size(G10CL);
Gd0=G10CL*Ld0(1:mg,:);
Gd0=inv(sqrtm(4*Gd0*(Gd0')));
G10CL=(Gd0)*G10CL;
%
%
Ldd0=rot90(Ld0,2);
%
G11CL=rot90(G11CL,2);
%
%
Gd1=G11CL*Ldd0(1:mg,:);
%
Gd1=inv(sqrtm(4*Gd1*(Gd1')));
G11CL=(Gd1)*G11CL;
G11CL=rot90(G11CL,2);

[G10CL] = Filtre_ondBior(G10CL,G10CLd);
[G11CL] = Filtre_ondBior(rot90(G11CL,2),rot90(G11CLd,2));
%
G11CL=rot90(G11CL,2);
%G11CLd=rot90(G11CLd,2);
%
%
%
%
%
%
%==========  Edge Wavelet filter Normalisation des filtres  ==============%
%
%
%
%
G10CL=4*G10CL;
G11CL=4*G11CL;
%
%
%
%
%
%
%==============   Different benchmark solutions of : -ue"=fx   ===========%
%
%
%
%
%
%
x=[0:1/2^j:1];
%
%
%
%
%
%
%=========================================================================%
%
%
%
% a=6/16;b=10/16;vf=2;
% %
% %
% x1=[0:1/2^j:a];
% x2=[a+1/2^j:1/2^j:b];
% x3=[b+1/2^j:1/2^j:1];
% %
% %
% %
% C1=-vf/2;C3=a^2*C1;
% A1=vf/2*(a^2-b^2);C2=A1+vf*b;A0=C2-vf*a;
% %
% ue=[A0*x1 (C1*x2.^2+C2*x2+C3) A1*x3-A1];
% fx=[0*x1 vf*ones(size(x2)) 0*x3];
%
%
%
%
%=========================================================================%
% 
%
%
ue=x.^(3)-x.^(4);
fx=-6*x+12*(x.^2);

%
%
%=========================================================================%
%
%
%
%
%
% ue=(x.^(1)).*((1-x).^(1));
% fx=2*ones(1,2^j+1);
% 
% 
%
%=========================================================================%
% 
% 
%
%
% ue=sin(2*pi*x).^2;
% fx=-8*pi*pi*cos(4*pi*x);
% 
% 
% 
%=========================================================================%
%
% ue=x.*(x-1).*exp(x);
% fx=-(3*x+x.^2).*exp(x);
% 
%
%
%=========================================================================%
%
%
%
%
%
%
gg0=inv(Gram_bord(h1d,h1,l11_1,l12_1,l11,l12,d0-1,r1_1,r1,0)');
gg1=Gram_bord(h1d,h1,l11_1,l12_1,l11,l12,d0-1,r1_1,r1,1);
%
%
gg1=inv(rot90(gg1,2)');
gg1=rot90(gg1,2);
%
%
%
%
%
%
%
%
kk=-l12_1+l11_1-2*d0+2*r1_1+1;
%
%
%
%=========  Inversion of the Stiffness matrix at coarse scale  ===========%
%
%
%
%%%%tic;
%
Ld0=(Ld0*Ld0');
Ld0=Ld0\eye(kk+2^L);
%
%
%tic;
%
%
%
%===   Projection of fx onto the dual basis of V^1_j: <fx,\varphi^1_j> ====%
%
%
projfx=Projection_dOrtoCL_Primaire(l11,l12,d0,r1,Pb10d,Pb11d,Pbint1d,fx,j,0);
%
%
%===         Projection of ue onto V^1_j: <ue,tilde\varphi^1_j> ====%
%
%
uej=Projection_dOrtoCL(l11_1,l12_1,d0-1,r1,r1_1,Pb10,Pb11,Pbint1,gg0,gg1,ue,j,0);
%
%
%
%
%========   Coefficient of fx that are in the  dual of Vj^D       ========%
%
%
projfx=projfx(2:end-1);
%
%
%========             Dual spaces Wavelet transform                ========%
%
%
wcfx = FWT_IDaubCL(projfx,L,H10CL,H11CL,G10CL,G11CL,h1,g1,l11,l12,d0,r1,j,1);
%
%
%
%
%
%==============    Coarse scale coefficient of the solution     ==========%
%
%
%
%
wcvs(1:2^L+kk)=((Ld0)*(wcfx(1:2^L+kk)'))'/(2^(2*L));
%
%
%
%=====    Wavelet coefficients of the solution : renormalization   =======%
%
%
%
%tic,
for m=L:j-1
    wcvs(2^m+kk+1:2^(m+1)+kk)=2^(-2*m-4)*wcfx(2^m+kk+1:2^(m+1)+kk);
end
%
%
%toc;
% plot(wcvs(1:2^L+kk))
% pause
%
%
%
%=========   Reconstruction : scaling function coefficients ==============%
%
%
%
wcvs=[0 wcvs(1:2^L+kk) 0 wcvs(2^L+kk+1:2^j+kk)];
%
%
%
%
%
uj=IWT_IOBS_AMRD(wcvs,L,H10,H11,G10CL,G11CL,h1,g1,l11,l12,d0,r1,j);
%
%
%toc
%================    Extrapolation : values at grid point k/2^j  =========%
%
%
vs=Extrapolation_dOrtoCL(l11,l12,d0,r1,uj,Vb10,Vb11,Vint1,j,0);
%
%
%%%toc;
%
figure(1),
clf
plot(x,ue,'-',x,vs,'-.','LineWidth',2),
%title('Different solutions '),
xlabel('$x$','Interpreter','latex','FontWeight','bold')
ylabel('$u(x)$','Interpreter','latex','FontWeight','bold')
%
legend('True solution','Wavelet solution');
%
%
set(gca,'FontSize',16,'FontWeight','bold');
%
%
%
xj=[0:1/(length(uej)-1):1];
%
%
figure(2)
clf
plot(xj,(uej-uj)/norm(uej),'-',x,(ue-vs)/norm(ue),'--','LineWidth',2),
xlabel('$x$','Interpreter','latex','FontWeight','bold')
ylabel('$u(x)$','Interpreter','latex','FontWeight','bold')
%
legend('Scaling coeff-error ','Grid points-error');
%
%
set(gca,'FontSize',16,'FontWeight','bold');
%
%
%
%
%
%norm(ue-vs,2)/norm(ue,2)
%
%
%
%
%
figure(3)
clf
PlotWaveCoeff_Bord_1D(wcvs,L,0,l11,l12,d0,r1,j,0);
title('Wavelet coefficients','FontWeight','bold')

xlabel('$x=k/2^j$','Interpreter','latex','FontWeight','bold')
ylabel('scale $j$','Interpreter','latex','FontWeight','bold')
%
%
%
%=========================================================================%
%
%
function x= IWT_IOBS_AMRD(wc,L,H0,H1,G0CL,G1CL,h1_1,g1_1,l11,l22,d1_1,r1_1,J)
%%
%(us,L,H10,H11,G10CL,G11CL,h1,g1,l1,l2,d1,r1,j);
%
%
[nh0,mh0]=size(H0);
[ng0,mg0]=size(G0CL);
wc = ShapeAsRow(wc);
kk=-l22+l11-2*d1_1+2*r1_1+1;
x =wc(1:2^L+kk);
%
%
%
for j=L:1:J-1
    %
    %
    a=ConvDyadUpGdAMRD(wc(2^j+kk+1:2^(j+1)+kk),g1_1,G0CL,G1CL,l11,l22,d1_1,r1_1,ng0,mg0,j);
    %
	x = ConvDyadUpHdAMRD(x,h1_1,H0,H1,l11,l22,d1_1,r1_1,nh0,mh0,j);
    %
    x(2:end-1)=x(2:end-1)+ a;
end
%
%
x = ShapeLike(x,wc);
%
%
%=========================================================================%
%
%
function blo = ConvDyadUpHdAMRD(bhi,h1_1,H0_1,H1_1,l11,l22,d1_1,r1_1,nh0,mh0,j)
%%
%
%
N1=2^j-l22+l11-2*d1_1+2*r1_1+1;
N2=2^(j+1)-l22+l11-2*d1_1+2*r1_1+1;
%
%
blo=zeros(1,N2);
%
%
%
blo(1:mh0) = bhi(1:nh0) * H0_1;
%
%
blo(N2-mh0+1:N2) =bhi(N1-nh0+1:N1) * H1_1;
%
%
ypad = zeros(1,N2+mh0+2);
%
%
ypad(nh0+2:2:nh0+2+2*(N1-2*nh0-1)) = bhi(nh0+1:N1-nh0);
%
%
y = conv(h1_1,ypad);
%
%
%y=lshift(y);
%
%
blo =blo+ y(1:N2);%
% 
%
%=========================================================================%
%
%
function blo = ConvDyadUpGdAMRD(bhi,g1_1,G0_1,G1_1,l11,l22,d1_1,r1_1,ng0,mg0,j)
%%
%
N1=2^j;
%
N2=2^(j+1)-l22+l11-2*d1_1+2*r1_1+1-2;         % dimension avec CL
blo=zeros(1,N2);
%
%
blo(1:mg0) = bhi(1:ng0) * G0_1;
%
blo(N2-mg0+1:N2) =bhi(N1-ng0+1:N1) * G1_1;
%
%
ypad = zeros(1,N2+mg0+2);
%
%
ypad(ng0+2:2:ng0+2+2*(N1-2*ng0-1)) = bhi(ng0+1:N1-ng0);
%
%
y = conv(g1_1,ypad);
%
%y=rshift(y);
%
blo =blo+ y(1:N2);
%
%
%=========================================================================%
%
%
function [Go0,Go0d] = Filtre_ondBior(G0,G0d)
%%
%
%
%  Matrice de Gram des Ondelettes
%
%
%
[GramG]=gram_bor_ondBior(G0,G0d);
%   Cas biorthogonal
%
% Cas biorthogonal en general
Go0=G0;
%
%
%
nx=length(GramG);
%
G_inv= GramG\(eye(nx));
%
Go0d=(G_inv')*G0d;
%
%
%=========================================================================%
%
%
function [Gram0]=gram_bor_ondBior(G0,G0d)
%% 
%
%
% Bord en 0
%
[n0,m0]=size(G0);
[n1,m1]=size(G0d);
%
m=max(m0,m1);
%
Gr0=zeros(n0,m);
Gr0(1:n0,1:m0)=G0;
Gr0d=zeros(n0,m);
Gr0d(1:n1,1:m1)=G0d;
%
%
%
Gram0=Gr0*(Gr0d');
%
%
%=========================================================================%
%
%
function Ld0=Matchange_V1_V0(h1_1,l1,l2,l11,l22,d1,r1,J,gr0,gr1)
%%
%    Dimension des espaces
N0=2^J-l2+1+l1+2*(r1-1)-2*d1+1;
N1=2^J-l2+l1+2*r1-2*d1+1;
%
% Par le choix de k_0 dans la definition d0_1=d1_1
%
r=r1-1;      % Moment nul pour les Phi^{0}
A=eye(r);
%
for k=1:r1-1,
    p0(1,k)=-Pm(d1-l1-1,h1_1,k,l11,l22,0);
    p1(1,k)=Pm(d1-l1-1,h1_1,k,l11,l22,1);
end
%
%
Ld0=zeros(N1,N0);
Ld0(1,r1)=-1;
Ld0(N1,N0-r1+1)=1;
Ld0(2:r1,1:r)=A;
Ld0(2:r1,r+1)=p0(:);
%
%
p1=fliplr(p1);
%
%
Ld0(N1-r:N1-1,N0-r+1:N0)=-A;
Ld0(N1-r:N1-1,N0-r)=p1(:);
%
%
for i=d1-l1:2^J-l2-d1,
    for j=d1-l1:2^J-l2+1-d1,
        if i==j
            Ld0(i+r1-d1+l1+1,j+r1-d1+l1)=1;
            Ld0(i+r1-d1+l1+1,j+1+r1-d1+l1)=-1;
        end
    end
end
%
%
gr0=(sqrtm(gr0));
gr1=(sqrtm(gr1));
%
% On passe a la base avec Dirichlet
Ld0=Ld0(2:N1-1,1:N0);
%
%
%  On passe a la base orthogonale
%
%
Ld0(1:N1-2,1:r1-1)=Ld0(1:N1-2,1:r1-1)*(gr0);
Ld0(1:N1-2,N0-r1+2:N0)=rot90(rot90(Ld0(1:N1-2,N0-r1+2:N0),2)*(gr1),2);
%
%
%
%=========================================================================%
%
%
%
function y = lshift(x)
%%
%
y = [ x( 2:length(x) ) x(1) ];
%
%
%=========================================================================%
%
%
function extra=Extrapolation_dOrtoCL(l1,l2,d1,r1,proj,V_bor0,V_bor1,V_inter,j,CL)
%%
% 
%
%
extra=zeros(1,2^j+1);
%
proj=proj*sqrt(2^j);
%
N=2^j-2*d1-l2+l1+2*r1+1-2*CL;
%
%
extra(1:length(V_bor0))=proj(1:r1-CL)*V_bor0;
extra(2^j-length(V_bor1)+2:2^j+1)=proj(N-r1+CL+1:N)*V_bor1;
%
coeff=proj(r1-CL+1:N-r1+CL);
%
%
%
extra = extra + [0 conv(coeff,V_inter) 0];
%
%
%=========================================================================%
%
function proj=Projection_dOrtoCL(l11,l22,d1_1,r1,r1_1,pb0,pb1,p_int,g0,g1,f,j,CL)
%%
% 
N =2^j+1;
Nf=N-2*d1_1-l22+l11+2*r1_1;
coeffs = zeros(1,Nf);
%
%
q=r1_1+1;
%
%
%
%Nf
coeffs(1:r1_1) = f(1:(q+1)) *pb0';
coeffs(Nf-r1_1+1:Nf) = f(N-q:N) *pb1';
%
%
if CL==0
coeffs(r1_1+1:(Nf-r1_1)) = conv2( [f(r1_1-1:N-r1_1+1)] ,fliplr(p_int),'valid');%Daubechies
end
coeffs(1:r1-CL)=coeffs(1:r1-CL)*g0;
coeffs(Nf-r1+CL+1:Nf)=coeffs(Nf-r1+CL+1:Nf)*g1;
proj = coeffs / sqrt(N-1);
%
%=========================================================================%
%
%
function proj=Projection_dOrtoCL_Primaire(l11,l22,d1_1,r1_1,pb0,pb1,p_int,f,j,CL)
%%
%
% 
N =2^j+1;
Nf=N-2*d1_1-l22+l11+2*r1_1;
coeffs = zeros(1,Nf);
%
%
q=r1_1+1;
%
%
%
%
coeffs(1:r1_1) = f(1:(q+1)) *pb0';
coeffs(Nf-r1_1+1:Nf) = f(N-q:N) *pb1';
%
%
if CL==0
coeffs(r1_1+1:(Nf-r1_1)) = conv2( [f(r1_1-2:N-r1_1+2)] ,fliplr(p_int),'valid');%Daubechies
end
%
proj = coeffs / sqrt(N-1);
%
%=========================================================================%
%
%
function wc = FWT_IDaubCL(x,L,H0,H1,G0,G1,h1,g1,l1,l2,d1,r1,J,CL)
%%
%
n=length(x);
wc= zeros(1,n) ;
[nh0,mh0]=size(H0);
[nh1,mh1]=size(H1);
[ng0,mg0]=size(G0);
[ng1,mg1]=size(G1);
b=ShapeAsRow(x);
%
%
%
for j=J-1:-1:L
       a=ConvDyadDownG(b,g1,G0,G1,l1,l2,d1,r1,ng0,mg0,ng1,mg1,CL,j);
       wc(2^j+1-l2+l1-2*d1+2*r1+1-2*CL:2^(j+1)-l2+l1-2*d1+2*r1+1-2*CL) = a;
       b = ConvDyadDownH(b,h1,H0,H1,l1,l2,d1,r1,nh0,mh0,nh1,mh1,CL,j);  
end
%
wc(1:(2^L)-l2+l1-2*d1+2*r1+1-2*CL) = b;
wc = ShapeLike(wc,x);
%
%
%=========================================================================%
%
%
function blo = ConvDyadDownH(bhi,h1,H0,H1,l1,l2,d1,r1,nh0,mh0,nh1,mh1,CL,j)
%%
%
%
N1=2^j-l2+l1-2*d1+2*r1+1-2*CL;
N2=2^(j+1)-l2+l1-2*d1+2*r1+1-2*CL;
blo=zeros(1,N1);
blo(1:nh0) = bhi(1:mh0) * H0';
%
%
%q=rem(r1,2);
%
blo(N1-nh1+1:N1) =bhi(N2-mh1+1:N2) * H1';
%
%
%
y=conv(reverse(h1),bhi);
%
%
%y=rshift(y);
%
blo(nh0+1:N1-nh1) = y(mh0+2:2:mh1+2+2*(N1-2*nh1-1));
%
%
%=========================================================================%
%
%
function blo = ConvDyadDownG(bhi,g1,G0,G1,l1,l2,d1,r1,ng0,mg0,ng1,mg1,CL,j)
%%
%
%
N1=2^j;
N2=2^(j+1)-l2+l1-2*d1+2*r1+1-2*CL;
%
%
blo=zeros(1,N1);
blo(1:ng0) = bhi(1:mg0) * G0';
blo(N1-ng1+1:N1) =bhi(N2-mg1+1:N2) * G1';
%
%
%
y=conv(reverse(g1),bhi);
%
y=rshift(y);
%
blo(ng0+1:N1-ng1) = y(mg0:2:mg1+2+2*(N1-2*ng1-1)-2);
%
%
%=========================================================================%
%
%
function y = rshift(x)
%%
n = length(x);
y = [ x(n) x( 1: (n-1) )];
%=========================================================================%
%
