function PlotWaveCoeff_Bord_1D(wc,L,scal,l1,l2,d1,r1,J,CL)
%%
% PlotWaveCoeff -- Spike-plot display of wavelet coefficients
%  Usage
%    PlotWaveCoeff(wc,L,scal)
%  Inputs
%    wc    1-d wavelet transform
%    L     level of coarsest scale
%    scal  scale factor [0 ==> autoscale]
%
%  Side Effects
%    A display of wavelet coefficients (coarsest level 
%    NOT included) by level and position.
%
%
    wavecoef = ShapeAsRow(wc); 
    kk=-l2+l1-2*d1+2*r1+1-2*CL;%
    n=2^J+kk;
    %
    %
    %
	if scal==0, 
		scal = 1. / max(abs(wavecoef((2^(L)+kk+1):n))); 
	end
%
	LockAxes([0 1 (-J) (-L+1)])
%
	for j=(J-1):-1:L
	  tj = (.5:(2^(j)-.5))./2^(j);
	  PlotSpikes(-j,tj,(wavecoef(2^j+kk+1:2^(j+1)+kk).*scal));
	end
%
%
set(gca,'FontSize',16,'FontWeight','bold');
%
%
%
UnlockAxes;
%
%
%
%
%
%
function PlotSpikes(base,t,x)
%%
% PlotSpikes -- Plot 1-d signal as baseline with series of spikes
%  Usage
%    PlotSpikes(base,t,x)
%  Inputs
%    base   number, baseline level
%    t      ordinate values
%    x      1-d signal, specifies spike deflections from baseline
%
%  Side Effects
%    A plot of spikes on a baseline
%
%  See Also
%    PlotWaveCoeff, PlotPacketTable
%
	tt = [t ; t ; t ];
	b = zeros(size(x)) + base;
	xx = [b ; x+base ; b ];
	u = [ 0     ; tt(:) ; 1 ];
	v = [  base ; xx(:) ; base ];
    %
    %
	plot(u,v,'LineWidth',1.5);
    set(gca,'FontSize',16,'FontWeight','bold');
    
%
%
%
%
%
%  Part of Wavelab Version 850
%  Built Tue Jan  3 13:20:40 EST 2006
%  This is Copyrighted Material
%  For Copying permissions see COPYING.m
%  Comments? e-mail wavelab@stat.stanford.edu 
