/////////////////////////////////////////////////////////////////////////////
// Name:        MasqueDouble.cpp
// Purpose:     Masque Double class
// Author:      Alain Bouju
// Modified by:
// Created:     04/04/99
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////

#include "MasqueDouble.h"

#define MAX_LECTURE 65534

#define MAX_TAMPON 80

/***********************************/
/* Constructeur Masque Double vide */
/***********************************/

MasqueDouble::MasqueDouble ()
{
	x0 = 0;
	y0 = 0;
	largeur = 0;
	hauteur = 0;
	diviseur = 0.0;
	nomMasqueLogique = wxString();
	tableau = NULL;
	MasqueOk = false;
}

/*************************************/
/* Recherche de la Hauteur du Masque */
/*************************************/

int MasqueDouble::ChercherHauteur ()
{
	return hauteur;
}

/*************************************/
/* Recherche de la Largeur du Masque */
/*************************************/

int MasqueDouble::ChercherLargeur ()
{
	return largeur;
}

/******************************/
/* Recherche du Nom du Masque */
/******************************/

wxString MasqueDouble::ChercherNom ()
{
	return nomMasqueLogique;
}

/**********************************/
/* Recherche du contenu du Masque */
/**********************************/

Double * MasqueDouble::ChercherMasque ()
{
	return tableau;
}


/******************************/
/* Destructeur MasqueDouble   */
/******************************/

MasqueDouble::~MasqueDouble ( void )
{
	delete [] tableau;
}

/***************************/
/* Lecture Masque Double   */
/***************************/

int MasqueDouble::LectureFichier( wxString p_wNomPhysique, wxString p_wNomLogique)
{

FILE
	*stream; /* Fichier a Lire */
char
	tampon[MAX_TAMPON],
	*ptr1,
	*ptr2;
unsigned long int
	taille;
int
	larg,
	haut;

const char *
	l_zNomPhysique;

float l_fTemp;

/* Mise a jour NomLogique */
 nomMasqueLogique = p_wNomLogique;

/* Nom du Fichier Masque Double */

 l_zNomPhysique = p_wNomPhysique.GetData();

/* Lecture de l'entete */

 if ((stream = fopen(l_zNomPhysique, "rb")) == NULL) 
	{
	 wxString l_wFichier("Le fichier ");
	 wxString l_wOuverture(" ne peut pas etre ouvert");
	 wxMessageBox (l_wFichier + p_wNomPhysique + l_wOuverture, "Erreur a l'ouverture du fichier !",wxOK);
	 MasqueOk = false;
	 return (-1);
	}

/* elimination des commentaire */
 do
	 fgets(tampon, MAX_TAMPON, stream);
 while (tampon[0] == '#');

 ptr1 = tampon;
 ptr2 = strtok(ptr1, " \t\n");

/* Recherche du format du fichier */

 if (strncmp(ptr2, "M2", 2))
	{
	 wxString l_wFichier("Le fichier ");
	 wxString l_wFormat(" n'est pas au bon format !");
	 wxMessageBox (l_wFichier + p_wNomPhysique + l_wFormat, "Erreur !",wxOK);
	 MasqueOk = false;
	 return (-1);
	}

 ptr2 = strtok(NULL, " \t\n");
    
 if (ptr2 == NULL) 
	{
	  do
	  	fgets(tampon, MAX_TAMPON, stream);
	  while (tampon[0] == '#');
	  ptr1 = tampon;
	  ptr2 = strtok(ptr1, " \t\n");
	}
 /* Lecture x0 */
 sscanf(ptr2, "%d", &x0);

 ptr2 = strtok(NULL, " \t\n");
    
 if (ptr2 == NULL) 
	{
	 do
	 	 fgets(tampon, MAX_TAMPON, stream);
	 while (tampon[0] == '#');
	 ptr1 = tampon;
	 ptr2 = strtok(ptr1, " \t\n");
	}

 /* lecture y0 */
 sscanf(ptr2, "%d", &y0);

 ptr2 = strtok(NULL , " \t\n");
 
 if (ptr2 == NULL)
	{
	 do
	  	 fgets(tampon, MAX_TAMPON, stream);
	 while (tampon[0] == '#');
	
	 ptr1 = tampon;
	 ptr2 = strtok(ptr1, " \t\n");
	}

 /* lecture Largeur */
 sscanf(ptr2, "%d", &largeur);

ptr2 = strtok(NULL , " \t\n");
 
 if (ptr2 == NULL)
	{
	 do
	  	 fgets(tampon, MAX_TAMPON, stream);
	 while (tampon[0] == '#');
	
	 ptr1 = tampon;
	 ptr2 = strtok(ptr1, " \t\n");
	}

 /* lecture Hauteur */
 sscanf(ptr2, "%d", &hauteur);

 taille = largeur;
 taille *= hauteur;

 /* Creation Tableau valeur */
	
 tableau = new Double [taille];

ptr2 = strtok(NULL , " \t\n");
 
 if (ptr2 == NULL)
	{
	 do
	  	 fgets(tampon, MAX_TAMPON, stream);
	 while (tampon[0] == '#');
	
	 ptr1 = tampon;
	 ptr2 = strtok(ptr1, " \t\n");
	}

 /* lecture Hauteur */
 sscanf(ptr2, "%g", &l_fTemp);
diviseur = l_fTemp;

/* variable pour la lecture de l'image */
 int nb_lecture = hauteur;
 int taille_lecture = largeur;
	
/* Lecture de l'image */

int l_iTest;
int index=0;

for (int ligne = 0; ligne < nb_lecture * taille_lecture; ligne ++)
	{
	 /* Lecture des valeurs */
	 ptr2 = strtok(NULL , " \t\n");
 
	 if (ptr2 == NULL)
	   {
	     do
	       fgets(tampon, MAX_TAMPON, stream);
	     while (tampon[0] == '#');
	
	     ptr1 = tampon;
	     ptr2 = strtok(ptr1, " \t\n");
	   }
	 l_iTest=sscanf(ptr2, "%g", &l_fTemp);
	 tableau[index] = l_fTemp;
	 index++;
	 if ( l_iTest==0)
		{
			wxMessageBox ("Erreur  la lecture du fichier !", "Erreur",wxOK);
			MasqueOk = false;
			return (-1);
		}
		
	}

/* Fermeture du Fichier */
if (fclose(stream))
	{
	  wxMessageBox ("Erreur a la fermeture du fichier !", "Erreur", wxOK);
	  MasqueOk = false;
      	  return (-1);
	}
else
	{
	 MasqueOk = true;
	 return (1);
	}
}
