/////////////////////////////////////////////////////////////////////////////
// Name:        InterfaceImageDouble.cpp
// Purpose:     InterfaceImageDouble class
// Author:      Alain Bouju
// Modified by:
// Created:     07/02/00
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////

#include "InterfaceImageDouble.h"

// Liste Image Double
WX_DECLARE_LIST(ImageDouble, ListeImageDouble);
#include <wx/listimpl.cpp>
WX_DEFINE_LIST(ListeImageDouble)

ListeImageDouble g_wListeImageDouble(wxKEY_STRING);

extern int g_NbImageDouble;
extern wxBitmap  *g_Bitmap;
extern MyFrame   *g_Frame;

/********************************************/
/* Constructeur interface image Double vide */
/********************************************/

InterfaceImageDouble::InterfaceImageDouble ()
{
 
}




/****************************************/
/* Destructeur interface image Double   */
/****************************************/

InterfaceImageDouble::~InterfaceImageDouble ( void )
{
}

/*********************************************/
/* Initialisation de la liste image Double   */
/*********************************************/

void InterfaceImageDouble::InitInterfaceImageDouble ( void )
{
g_wMenuImageDouble = new wxMenu;
}

/**********************************************/
/* Recherche d'image de la liste image Double */
/**********************************************/


ImageDouble * InterfaceImageDouble::ChercherImageDouble(wxString l_wNomImage)
{
ImageDouble * l_pImageDouble;

if (g_wListeImageDouble.Find(l_wNomImage)==NULL)
	{
	(void)wxMessageBox("Image inexistante",
           "Erreur", wxOK);
	 return NULL;
	}

l_pImageDouble = g_wListeImageDouble.Find(l_wNomImage)->GetData();
return l_pImageDouble;
}

/********************************************/
/* Ajouter image dans la liste image Double */
/********************************************/


int InterfaceImageDouble::AjouterImageDouble(wxString l_wNomImage, ImageDouble *
l_pImageDouble)
{

if (!( g_NbImageDouble < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop d'images ouvertes pour le Menu!", "Erreur", wxOK);
	 return(-1);
	}
	
if (g_wListeImageDouble.Find(l_wNomImage) != NULL)
	{
	(void)wxMessageBox("Image "+l_wNomImage+" existante",
           "Erreur", wxOK);
	 return(-1);
	}


g_wListeImageDouble.Append(l_wNomImage, l_pImageDouble);
g_wMenuImageDouble -> Append(4 * BASELISTE + g_NbImageDouble, l_wNomImage);
g_NbImageDouble++;
return(1);
}


/******************************/
/* Visualisation image Double */
/******************************/

wxBitmap * InterfaceImageDouble::VisualiserDouble (ImageDouble *l_pImageDouble)
{
wxMemoryDC
	l_wMemDC;
long int l_iIndex;
long int l_iX;
long int l_iY;

/* Definition de la zone de l'image */
long int l_iHauteur = l_pImageDouble -> ChercherHauteur();
long int l_iLargeur = l_pImageDouble -> ChercherLargeur();
Double * l_pImage = l_pImageDouble -> ChercherImage();
wxBitmap * p_wImage = new wxBitmap(l_iLargeur, l_iHauteur, -1);
l_wMemDC.SelectObject( *p_wImage );
l_wMemDC.Clear();

/* Definition de la couleur */

wxColour l_wCouleur[256];

/* Initialisation pen */

wxPen l_wPen[256];

/* mise en place des couleur */

Gray256 l_iGray;

/* mise en place des couleur */
unsigned char l_uCouleurGray;
int l_iCouleur;
double l_dCouleur;

for(l_iCouleur=0; l_iCouleur <256; l_iCouleur++)
	{
	 l_iGray = l_iCouleur;
	 //l_wCouleur[l_iCouleur].Set(gray, gray, gray);
	 //l_wPen[l_iCouleur].SetColour(&l_wCouleur[l_iCouleur]);
	 l_wPen[l_iCouleur].SetColour(l_iGray, l_iGray, l_iGray);
	 l_wPen[l_iCouleur].SetWidth(wxDOT);
	 l_wPen[l_iCouleur].SetStyle(wxSOLID);
	}

/* Dessin de l'image */
l_iIndex = 0;

for(long int l_iIndiceY=0; l_iIndiceY < l_iHauteur; l_iIndiceY++)
{
 for(long int l_iIndiceX=0; l_iIndiceX < l_iLargeur; l_iIndiceX++)
	{
	 l_dCouleur = l_pImage[l_iIndex+l_iIndiceX];
	 if (l_dCouleur<0)
	   {
	     l_iCouleur = 0;
	   }
	 else 
	   {
	     if (l_dCouleur>255)
	       {
		 l_iCouleur = 255;
	       }
	     else
	       {
		 l_iCouleur = (int)(l_dCouleur);
	       }
	   }	 	
	 l_wMemDC.SetPen(l_wPen[l_iCouleur]);
	 l_wMemDC.DrawPoint(l_iIndiceX, l_iIndiceY);		 	
	}
 l_iIndex += l_iLargeur;
}

return (p_wImage);
}

//------------------------------------
// Affiche l'image Double selectionnee
//------------------------------------

void InterfaceImageDouble::OnImageDouble(wxCommandEvent& event)
{
int
	l_id;
	
ImageDouble
	*l_pImageDouble;
		
l_id=event.GetInt();

l_pImageDouble = g_wListeImageDouble.Find(g_wMenuImageDouble->GetLabel(l_id))-> GetData();

if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
// Debut Attente
wxBeginBusyCursor();

g_Bitmap = l_pImageDouble->VisualiserDouble();

// Fin attente
wxEndBusyCursor();

// Mise a jour de l'affichage
(g_Frame->canvas)->Refresh();
return;
}

//-------------------------
// Fonction Inverser Double
//-------------------------

void InterfaceImageDouble::OnInverserDouble()
{
ImageDouble
	*l_pImageSourceDouble;
int
	l_iStatus;

	
// Lecture Nom Logique de L'image Source
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

l_pImageSourceDouble = ChercherImageDouble(l_wNomImage);

if (l_pImageSourceDouble == NULL)
	{
	 return;
	}

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Debut Attente
wxBeginBusyCursor();

// Recherche si l'image Existe de deja
if (g_wListeImageDouble.Find(l_wNomImageDestination)!=NULL)
	{	
	(void)wxMessageBox("Image Existante",
            "Erreur", wxOK);
	 return;
	}
	
// Creation de l'Image
ImageDouble *l_ImageDoubleDestination = new ImageDouble(l_pImageSourceDouble);
// Inversion de l'Image
l_ImageDoubleDestination->Inverse();
// Insertion dans la Liste
l_iStatus = AjouterImageDouble(l_wNomImageDestination.GetData(), l_ImageDoubleDestination);
// Affichage
if (l_iStatus != -1)
	{
	 if (g_Bitmap) //liberation de la memoire
		{
		 delete g_Bitmap;
		}

	 g_Bitmap = l_ImageDoubleDestination->VisualiserDouble();

	 // Mise a jour de l'affichage
	 (g_Frame->canvas)->Refresh();
	}
// Fin attente
wxEndBusyCursor();
return;
}

//-------------------------------------
// Fonction Diviser taille image Double
//-------------------------------------

void InterfaceImageDouble::OnDiviserDouble()
{
ImageDouble
	*l_pImageSourceDouble;
int
	l_iStatus;

// Lecture Nom Logique de L'image Source
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

l_pImageSourceDouble = ChercherImageDouble(l_wNomImage);

if (l_pImageSourceDouble == NULL)
	{
	 return;
	}

// Lecture Nom Logique de L'image 
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Debut Attente
wxBeginBusyCursor();

// Diminution de l'Image
ImageDouble *l_ImageDoubleDestination = l_pImageSourceDouble->Diviser(l_wNomImageDestination);
// Insertion dans la Liste
l_iStatus = AjouterImageDouble(l_wNomImageDestination.GetData(), l_ImageDoubleDestination);
// Affichage
if (l_iStatus != -1)
	{
	 if (g_Bitmap) //liberation de la memoire
		{
		 delete g_Bitmap;
		}

	 g_Bitmap = l_ImageDoubleDestination->VisualiserDouble();

	 // Mise a jour de l'affichage
	 (g_Frame->canvas)->Refresh();
	}
// Fin attente
wxEndBusyCursor();
return;
}

//-------------------------------------
// Affiche la valeur Min Max de l'image
//-------------------------------------

void InterfaceImageDouble::OnImageDoubleAfficherMinMax()
{
ImageDouble
	*l_pImageSourceDouble;

	
// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image : ", "Nom de l'image", "");

// Recherche de l'image 

l_pImageSourceDouble = ChercherImageDouble(l_wNomImage);

if (l_pImageSourceDouble == NULL)
	{
	 return;
	}

// A changer quand wxString plus performant
char l_zChaineTemporaire1[40],
     l_zChaineTemporaire2[40];
snprintf(l_zChaineTemporaire1,40,"%lg",l_pImageSourceDouble->ValeurMax());
snprintf(l_zChaineTemporaire2,40,"%lg",l_pImageSourceDouble->ValeurMin());

wxString l_wResultatMinMax = wxString("Max: ")+ wxString(l_zChaineTemporaire1)+
wxString("\nMin: ") + wxString(l_zChaineTemporaire2);
(void)wxMessageBox(l_wResultatMinMax, "Valeur", wxOK);
return;
}

