/////////////////////////////////////////////////////////////////////////////
// Name:        Interface.h
// Purpose:     wxBitmap class
// Author:      Alain Bouju
// Modified by:
// Created:     15/10/98
// RCS-ID:      
// Copyright:   
// Licence:   	
/////////////////////////////////////////////////////////////////////////////
#ifndef INTERFACE_H__
#define INTERFACE_H__

#ifdef __GNUG__
#pragma interface
#endif
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#include "InterfaceImageBin.h"
#include "InterfaceImageGray256.h"
#include "InterfaceImageDouble.h"

#include "ImageBin.h"
#include "ImageDouble.h"
#include "MasqueDouble.h"

// Define a new application 
class MyApp: public wxApp
{
  public:
    MyApp(void) ;
    bool OnInit(void);
};

// Define a new frame
class MyCanvas;

class MyFrame: public wxFrame
{
  public:
    MyCanvas *canvas;
    MyFrame(wxFrame *parent, const wxString& title, const wxPoint& pos, const wxSize& size);

    bool OnClose(void);
    void OnActivate(bool) {}
    void OuvrirFile256(wxCommandEvent& event);
    void OnSaveFile256(wxCommandEvent& event);
    void Quitter(wxCommandEvent& event);
 
    
    void OnImage256(wxCommandEvent& event);
    void OnInverser256(wxCommandEvent& event);
    void OnDiviser256(wxCommandEvent& event);
    void OnSeuiller256(wxCommandEvent& event);
    void OnConvoluer256(wxCommandEvent& event);
    
    // Methode Image Bin
    void OnImageBin(wxCommandEvent& event);
    void OnInverserBin(wxCommandEvent& event);
    
    // Methode Image Double
    void OnImageDouble(wxCommandEvent& event);
    void OnConvertirImageGray(wxCommandEvent& event);
    void OnConvertirImageGrayMinMax(wxCommandEvent& event);
    void OnImageDoubleAfficherMinMax(wxCommandEvent& event);
    void OnConvoluerImageDouble(wxCommandEvent& event);
    void OnSeuillerDouble(wxCommandEvent& event);
    
    // Methode Masque
    void OnOuvrirMasqueDouble(wxCommandEvent& event);
    
    //Menu About
    void OnAbout(wxCommandEvent& event);    
    void OnTest(wxCommandEvent& event);    

DECLARE_EVENT_TABLE()
};

// Define a new canvas which can receive some events
class MyCanvas: public wxScrolledWindow
{
  public:
    MyCanvas(wxWindow *parent, const wxPoint& pos, const wxSize& size);
    ~MyCanvas(void) ;

    void OnPaint(wxPaintEvent& event);
DECLARE_EVENT_TABLE()
};

#define NB_MENU_MAX 10

// Menu Fichier
#define TAI_OUVRIR_FILE_256  			100
#define TAI_SAVE_FILE_256  			101
#define TAI_OUVRIR_MASQUE_DOUBLE		102
#define TAI_QUIT       				103

// Menu Operation 256
#define TAI_INVERSER_256			200
#define TAI_DIVISER_256				201
#define TAI_SEUILLER_256			202
#define TAI_CONVOLUER_256			203

// Menu Operation Bin
#define TAI_INVERSER_BIN			300

// Menu Operation Double 
#define TAI_CONVERTIR_IMAGE_GRAY		400
#define TAI_CONVERTIR_IMAGE_GRAY_MIN_MAX	401
#define TAI_AFFICHER_MIN_MAX			402
#define TAI_CONVOLUER_DOUBLE			403
#define TAI_SEUILLER_DOUBLE			404

// Menu About
#define TAI_ABOUT      				501
#define TAI_TEST				502

// BASELISTE 2000 image 256, image bin, image Double,
#define BASELISTE       			1000

#endif
