/////////////////////////////////////////////////////////////////////////////
// Name:        ImageDouble.h
// Purpose:     ImageDouble class
// Author:      Alain Bouju
// Modified by:
// Created:     29/04/99
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////

/* Definition de la classe ImageDouble */
#ifndef IMAGEDOUBLE_H__
#define IMAGEDOUBLE_H__

#ifdef __GNUG__
#pragma interface
#endif

#include "wx/wx.h"

typedef double Double;

#include "ImagePGM.h"

#include "ImageBin.h"

#include "ImageGray256.h"

//#include "wxima.h"

class ImageGray256;

class MasqueDouble;

class ImageDouble{
	wxString nomLogique;
	int hauteur;
	int largeur;
	Double *image;
	
public :
//	Constructeur
	ImageDouble (void);
	ImageDouble (wxString p_wNomLogique, ImageGray256 *source);
	ImageDouble (wxString p_wNomLogique, int p_iLargeur, int p_iHauteur);
	ImageDouble (ImageDouble *source);
	~ImageDouble (void);

//	Optention d'information sur objet
	int ChercherHauteur ();
	int ChercherLargeur ();
	wxString ChercherNom ();
	Double *ChercherImage ();

//	Methodes
	double ValeurMax();
	double ValeurMin();
	
	wxBitmap * VisualiserDouble ();
	int Inverse ();
ImageDouble *ImageDouble::Convoluer(wxString p_wNomDestination, MasqueDouble
* p_MasqueConvolution);	
	ImageDouble *Diviser (wxString p_wNomDestination);
};


#endif
