/////////////////////////////////////////////////////////////////////////////
// Name:        ImageDouble.cpp
// Purpose:     ImageDouble class
// Author:      Alain Bouju
// Modified by:
// Created:     30/04/99
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////

#include "ImageDouble.h"

/*****************************************/
/* Constructeur image double niveau vide */
/*****************************************/

ImageDouble::ImageDouble ()
{
	largeur = 0;
	hauteur = 0;
	nomLogique = wxString();
	image = NULL;
}

/**************************************/
/* Recherche de la Hauteur de l'Image */
/**************************************/

int ImageDouble::ChercherHauteur ()
{
	return hauteur;
}

/**************************************/
/* Recherche de la Largeur de l'Image */
/**************************************/

int ImageDouble::ChercherLargeur ()
{
	return largeur;
}

/**********************************/
/* Recherche de la Nom de l'Image */
/**********************************/

wxString ImageDouble::ChercherNom ()
{
	return nomLogique;
}

/***********************************/
/* Recherche du contenu de l'image */
/***********************************/

Double * ImageDouble::ChercherImage ()
{
	return image;
}

/**********************************************/
/* Constructeur image Double a partir Gray256 */
/**********************************************/

ImageDouble::ImageDouble (wxString p_wNomLogique, ImageGray256 *source)
{
	hauteur = source->ChercherHauteur();
	largeur = source->ChercherLargeur();
	
	nomLogique = p_wNomLogique;
	long int l_iTaille = hauteur * largeur;
	image = new Double [l_iTaille];
	Gray256 * l_ImageTemp = source -> ChercherImage();
	for(long int l_iIndice = 0; l_iIndice<l_iTaille; l_iIndice++)
		{
		 image[l_iIndice] = l_ImageTemp[l_iIndice];
		}
}

/***************************************************/
/* Constructeur image Double a partir d'une Taille */
/***************************************************/

ImageDouble::ImageDouble (wxString p_wNomLogique, int p_iLargeur, int p_iHauteur)
{
	
	largeur = p_iLargeur;
	hauteur = p_iHauteur;	
	nomLogique = p_wNomLogique;
	long int l_iTaille = p_iHauteur * p_iLargeur;
	image = new Double [l_iTaille];

}


/******************************/
/* Constructeur image Double  */
/******************************/

ImageDouble::ImageDouble (ImageDouble *source)
{
	hauteur = source->ChercherHauteur();
	largeur = source->ChercherLargeur();

	nomLogique = wxString(source->ChercherNom());
	// Calcul de la taille de l'image
	long int l_iTaille = hauteur * largeur;
	// Creation du tableau contenant l'image
	image = new Double [l_iTaille];

	Double *temp = source->ChercherImage();
	// recopie de l'image
	for (int i=0; i<(hauteur*largeur); i++)
		image [i] = temp [i];
}

/******************************/
/* Destructeur image Double   */
/******************************/

ImageDouble::~ImageDouble ( void )
{
	delete [] image;
}

/********************************/
/* Visualisation image Double   */
/********************************/

wxBitmap * ImageDouble::VisualiserDouble ()
{
wxMemoryDC
	l_wMemDC;
long int l_iIndex;
long int l_iX;
long int l_iY;

/* Definition de la zone de l'image */

wxBitmap * p_wImage = new wxBitmap(largeur, hauteur, -1);
l_wMemDC.SelectObject( *p_wImage );
l_wMemDC.Clear();

/* Definition de la couleur */

wxColour l_wCouleur[256];

/* Initialisation pen */

wxPen l_wPen[256];

/* mise en place des couleur */

Gray256 l_iGray;

/* mise en place des couleur */

unsigned char l_uCouleurGray;
int l_iCouleur;
for(l_iCouleur=0; l_iCouleur <256; l_iCouleur++)
	{
	 l_iGray = l_iCouleur;
	 //l_wCouleur[l_iCouleur].Set(gray, gray, gray);
	 //l_wPen[l_iCouleur].SetColour(&l_wCouleur[l_iCouleur]);
	 l_wPen[l_iCouleur].SetColour(l_iGray, l_iGray, l_iGray);
	 l_wPen[l_iCouleur].SetWidth(wxDOT);
	 l_wPen[l_iCouleur].SetStyle(wxSOLID);
	}

/* Dessin de l'image */
l_iIndex = 0;
long int l_iHauteur = hauteur;
long int l_iLargeur = largeur;

for(long int l_iIndiceY=0; l_iIndiceY < l_iHauteur; l_iIndiceY++)
{
 for(long int l_iIndiceX=0; l_iIndiceX < l_iLargeur; l_iIndiceX++)
	{
	  /* printf("float %g \n",image[l_iIndex+l_iIndiceX]);*/
	 if (image[l_iIndex+l_iIndiceX]<0)
	   {
	     l_iCouleur = 0;
	   }
	 else 
	   {
	     if (image[l_iIndex+l_iIndiceX]>255)
	       {
		 l_iCouleur = 255;
	       }
	     else
	       {
		 l_iCouleur = (int)( image[l_iIndex+l_iIndiceX]);
	       }
	   }
	 /*printf("Couleur %d\n",l_iCouleur);*/
	 l_wMemDC.SetPen(l_wPen[l_iCouleur]);
	 l_wMemDC.DrawPoint(l_iIndiceX, l_iIndiceY);		 	
	}
 l_iIndex += l_iLargeur;
}
return (p_wImage);
}

/*************************/
/* Inverse image Double  */
/*************************/

int ImageDouble::Inverse ()
{
for (int i=0; i<(largeur*hauteur);  i++)
	{
	 image [i] = - image [i];
	}
}


/*****************************************************/
/* Division de la taille de l'image par 2            */
/*****************************************************/

ImageDouble *ImageDouble::Diviser (wxString p_wNomDestination)
{
ImageDouble *PetiteImage = new ImageDouble;

long int l_iLarg;
long int l_iHaut;
int l_iLImpaire;
int l_iHImpaire;

if (largeur % 2)
	{
	 l_iLarg = largeur - 1;
	 PetiteImage->largeur = l_iLarg / 2 + 1;
	 l_iLImpaire = 1;
	}
else
	{
	 l_iLarg = largeur;
	 PetiteImage->largeur = l_iLarg / 2;
	}

if (hauteur % 2)
	{
	 l_iHaut = hauteur - 1;
	 PetiteImage->hauteur = l_iHaut / 2 + 1;
	 l_iHImpaire = 1;
	}
else
	{
	 l_iHaut = hauteur;
	 PetiteImage->hauteur = l_iHaut / 2;
	}

PetiteImage->nomLogique = p_wNomDestination;
	
long int l_iTaille = largeur * hauteur;
long int l_iTaillePetite = PetiteImage->largeur * PetiteImage->hauteur;

PetiteImage->image = new Double [l_iTaillePetite];

	
double l_iSomme = 0;
int l_iLargEff = PetiteImage->largeur;
	
for (long int i=0; i<l_iHaut; i+=2)
	{
	 for (long int j=0; j<l_iLarg; j+=2)
		{
		 l_iSomme = 0;
		 l_iSomme += image [i*l_iLarg + j];
		 l_iSomme += image [i*l_iLarg + j + 1];
		 l_iSomme += image [(i+1)*l_iLarg + j];
		 l_iSomme += image [(i+1)*l_iLarg + j + 1];

		 PetiteImage->image [(i/2)*l_iLargEff + (j/2)] = l_iSomme / 4.0;
		}
	}

return PetiteImage;
}


/******************************************/
/* Recherche de la valeur Max d'une Image */
/******************************************/

double ImageDouble::ValeurMax ()
{
double
	l_dMax;
	
	hauteur = ChercherHauteur();
	largeur = ChercherLargeur();
	
	long int l_iTaille = hauteur * largeur;
	Double * l_ImageTemp = ChercherImage();
	// initialisation valeur max
	l_dMax = l_ImageTemp[0];
	for(long int l_iIndice = 0; l_iIndice<l_iTaille; l_iIndice++)
		{
		 if (l_ImageTemp[l_iIndice] > l_dMax)
		 	{
			 l_dMax = l_ImageTemp[l_iIndice];
			}
		}
	return(l_dMax);
}

/******************************************/
/* Recherche de la valeur Min d'une Image */
/******************************************/

double ImageDouble::ValeurMin ()
{
double
	l_dMin;
	
	hauteur = ChercherHauteur();
	largeur = ChercherLargeur();
	
	long int l_iTaille = hauteur * largeur;
	Double * l_ImageTemp = ChercherImage();
	// initialisation valeur max
	l_dMin = l_ImageTemp[0];
	for(long int l_iIndice = 0; l_iIndice<l_iTaille; l_iIndice++)
		{
		 if (l_ImageTemp[l_iIndice] < l_dMin)
		 	{
			 l_dMin = l_ImageTemp[l_iIndice];
			}
		}
	return(l_dMin);
}

/************************************************************************/
/*				FONCTION Convoluer			*/
/************************************************************************/
ImageDouble *ImageDouble::Convoluer(wxString p_wNomDestination, MasqueDouble	* p_MasqueConvolution)
{

//Allocation memoire de l'objet destination
	
ImageDouble *Destination = new ImageDouble(p_wNomDestination,largeur,hauteur);

// Produit de convoution
	
int   	      	l_iIndice;
int                 i, j, x, y;
double              somme;
double              el;
unsigned char       pixel;
Double
	* l_Tableau;
Double
	* l_TableauDestination;

l_Tableau = ChercherImage();

// Initialisation de l'image destination
l_TableauDestination = Destination -> ChercherImage();

for (l_iIndice = 0; l_iIndice < largeur * hauteur; l_iIndice++)
	l_TableauDestination[l_iIndice] = 0.0;
	
// Calcul de la convolution

for (i = 0 + p_MasqueConvolution -> x0;
	i < largeur - p_MasqueConvolution->largeur + p_MasqueConvolution->x0 + 1;
	i++)
	for (j = 0 + p_MasqueConvolution->y0;
	     j < hauteur - p_MasqueConvolution->hauteur + p_MasqueConvolution->y0 + 1;
	     j++)
	    {
	     somme = 0.0;
	     for (x = 0; x < p_MasqueConvolution->largeur; x++)
		for (y = 0; y < p_MasqueConvolution->hauteur; y++)
		{
		    somme += l_Tableau[(j+y)*largeur+i+x] *
p_MasqueConvolution->tableau[y*(p_MasqueConvolution->largeur)+ x];
		}
	     l_TableauDestination [j*largeur + i ] = somme / p_MasqueConvolution -> diviseur;
	    }	
	
	return(Destination);
}
