/////////////////////////////////////////////////////////////////////////////
// Name:        ImageBin.h
// Purpose:     ImageBin class
// Author:      Alain Bouju
// Modified by:
// Created:     21/04/99
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////

/* Definition de la classe Bin */
#ifndef IMAGEBIN_H__
#define IMAGEBIN_H__

#ifdef __GNUG__
#pragma interface
#endif

#include "wx/wx.h"

typedef unsigned char Bin;

#include "ImagePGM.h"
#include "ImageGray256.h"
#include "ImageDouble.h"

class ImageGray256;
class ImageDouble;
class MasqueBin;

class ImageBin{
	wxString nomLogique;
	int hauteur;
	int largeur;
	Bin *image;
	
public :
//	Constructeur
	ImageBin (void);
//	ImageGray256 (ImageBin *source);
//	ImageGray256 (wxImage *ima, char *leurre);
//	ImageBin (ImagePGM *source, wxString p_wNomLogique);
	ImageBin (ImageGray256 *p_source, int p_iSeuil, wxString p_wNomLogique);
	ImageBin (ImageDouble *p_source, double p_dSeuil, wxString p_wNomLogique);
	ImageBin (ImageBin *source);
	~ImageBin (void);

//	Optention d'information sur objet
	int ChercherHauteur ();
	int ChercherLargeur ();
	wxString Chercher_Nom ();
	Bin *ChercherImage ();

//	Methodes

	wxBitmap * VisualiserBin ();
	int Inverse ();
	ImageBin *Diviser (wxString p_wNomDestination);

};


#endif
