/////////////////////////////////////////////////////////////////////////////
// Name:        ImageBin.cpp
// Purpose:     ImageBin class
// Author:      Alain Bouju
// Modified by:
// Created:     21/04/99
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////

#include "ImageBin.h"

/**************************************/
/* Constructeur image Bin niveau vide */
/**************************************/

ImageBin::ImageBin ()
{
	largeur = 0;
	hauteur = 0;
	nomLogique = wxString();
	image = NULL;
}

/***************************/
/* Constructeur image bin  */
/***************************/

ImageBin::ImageBin (ImageBin *source)
{
	hauteur = source->ChercherHauteur();
	largeur = source->ChercherLargeur();

	nomLogique = wxString(source->Chercher_Nom());
	// Calcul de la taille de l'image
	long int l_iTaille = hauteur * largeur;
	// Creation du tableau contenant l'image
	image = new Bin [l_iTaille];

	Bin *temp = source->ChercherImage();
	// recopie de l'image - A refaire erreur
	for (int i=0; i<(hauteur*largeur); i++)
		image [i] = temp [i];
}

/***************************/
/* Constructeur image bin  */
/***************************/

ImageBin::ImageBin (ImageGray256 *p_source, int p_iSeuil, wxString p_wNomLogique)
{
long int l_iIndex;

	hauteur = p_source->ChercherHauteur();
	largeur = p_source->ChercherLargeur();

	nomLogique = p_wNomLogique;
	// Calcul de la taille de l'image
	long int l_iTaille = hauteur * largeur;
	// Creation du tableau contenant l'image
	image = new Bin [l_iTaille];

	Gray256 *temp = p_source->ChercherImage();
	// recopie de l'image

	long int l_iHauteur = hauteur;
	long int l_iLargeur = largeur;
	l_iIndex = 0; 
	for(long int l_iIndiceY=0; l_iIndiceY < l_iHauteur; l_iIndiceY++)
	{
	for(long int l_iIndiceX=0; l_iIndiceX < l_iLargeur; l_iIndiceX++)
		{
		 if (temp [l_iIndex+l_iIndiceX] > p_iSeuil)
		 	{
			 image [l_iIndex+l_iIndiceX] = 1;
		 	}
		 else
		 	{
			 image [l_iIndex+l_iIndiceX] = 0;
		 	}	 	
		}
	l_iIndex += l_iLargeur;
	}
		
}

/***************************/
/* Constructeur image bin  */
/***************************/

ImageBin::ImageBin (ImageDouble *p_source, Double p_dSeuil, wxString p_wNomLogique)
{
long int l_iIndex;

	hauteur = p_source->ChercherHauteur();
	largeur = p_source->ChercherLargeur();

	nomLogique = p_wNomLogique;
	// Calcul de la taille de l'image
	long int l_iTaille = hauteur * largeur;
	// Creation du tableau contenant l'image
	image = new Bin [l_iTaille];

	Double *temp = p_source->ChercherImage();
	// recopie de l'image

	long int l_iHauteur = hauteur;
	long int l_iLargeur = largeur;
	l_iIndex = 0; 
	for(long int l_iIndiceY=0; l_iIndiceY < l_iHauteur; l_iIndiceY++)
	{
	for(long int l_iIndiceX=0; l_iIndiceX < l_iLargeur; l_iIndiceX++)
		{
		 if (temp [l_iIndex+l_iIndiceX] > p_dSeuil)
		 	{
			 image [l_iIndex+l_iIndiceX] = 1;
		 	}
		 else
		 	{
			 image [l_iIndex+l_iIndiceX] = 0;
		 	}	 	
		}
	l_iIndex += l_iLargeur;
	}
		
}

/**************************************/
/* Recherche de la Hauteur de l'Image */
/**************************************/

int ImageBin::ChercherHauteur ()
{
	return hauteur;
}

/**************************************/
/* Recherche de la Largeur de l'Image */
/**************************************/

int ImageBin::ChercherLargeur ()
{
	return largeur;
}

/**********************************/
/* Recherche de la Nom de l'Image */
/**********************************/

wxString ImageBin::Chercher_Nom ()
{
	return nomLogique;
}

/***********************************/
/* Recherche du contenu de l'image */
/***********************************/

Bin * ImageBin::ChercherImage ()
{
	return image;
}



/***************************/
/* Destructeur image Bin   */
/***************************/

ImageBin::~ImageBin ( void )
{
	delete [] image;
}

/*****************************/
/* Visualisation image bin   */
/*****************************/
wxBitmap * ImageBin::VisualiserBin ()
{
wxMemoryDC
	l_wMemDC;
long int l_iIndex;
long int l_iX;
long int l_iY;


/* Definition de la zone de l'image */

wxBitmap * p_wImage = new wxBitmap(largeur, hauteur, -1);
l_wMemDC.SelectObject( *p_wImage );
l_wMemDC.Clear();

/* Definition de la couleur */

wxColour l_wCouleur[2];

/* Initialisation pen */

wxPen l_wPen[2];

/* mise en place des couleur */

// 0 blanc 1 bleu
l_wPen[0].SetColour(0, 0, 0);
l_wPen[0].SetWidth(wxDOT);
l_wPen[0].SetStyle(wxSOLID);
l_wPen[1].SetColour(0, 0, 250);
l_wPen[1].SetWidth(wxDOT);
l_wPen[1].SetStyle(wxSOLID);

/* Dessin de l'image */
l_iIndex = 0;
int l_iCouleur;
long int l_iHauteur = hauteur;
long int l_iLargeur = largeur;

for(long int l_iIndiceY=0; l_iIndiceY < l_iHauteur; l_iIndiceY++)
 {
 for(long int l_iIndiceX=0; l_iIndiceX < l_iLargeur; l_iIndiceX++)
	{
	 l_iCouleur = image[l_iIndex+l_iIndiceX];
	 l_wMemDC.SetPen(l_wPen[l_iCouleur]);
	 l_wMemDC.DrawPoint(l_iIndiceX, l_iIndiceY);		 	
	}
 l_iIndex += l_iLargeur;
 }
return (p_wImage);
}

/**********************/
/* Inverse image bin  */
/**********************/

int ImageBin::Inverse ()
{
for (int i=0; i<(largeur*hauteur);  i++)
	{
	 image [i] = 1 - image [i];
	}
}


/*****************************************************/
/* Division de la taille de l'image par 2            */
/*****************************************************/
/* A Faire */
ImageBin *ImageBin::Diviser (wxString p_wNomDestination)
{
ImageBin *PetiteImage = new ImageBin;

long int l_iLarg;
long int l_iHaut;
int l_iLImpaire;
int l_iHImpaire;

if (largeur % 2)
	{
	 l_iLarg = largeur - 1;
	 PetiteImage->largeur = l_iLarg / 2 + 1;
	 l_iLImpaire = 1;
	}
else
	{
	 l_iLarg = largeur;
	 PetiteImage->largeur = l_iLarg / 2;
	}

if (hauteur % 2)
	{
	 l_iHaut = hauteur - 1;
	 PetiteImage->hauteur = l_iHaut / 2 + 1;
	 l_iHImpaire = 1;
	}
else
	{
	 l_iHaut = hauteur;
	 PetiteImage->hauteur = l_iHaut / 2;
	}

PetiteImage->nomLogique = p_wNomDestination;
	
long int l_iTaille = largeur * hauteur;
long int l_iTaillePetite = PetiteImage->largeur * PetiteImage->hauteur;

PetiteImage->image = new Bin [l_iTaillePetite];

	
int l_iSomme = 0;
int l_iLargEff = PetiteImage->largeur;
	
for (long int i=0; i<l_iHaut; i+=2)
	{
	 for (long int j=0; j<l_iLarg; j+=2)
		{
		 l_iSomme = 0;
		 l_iSomme += image [i*l_iLarg + j];
		 l_iSomme += image [i*l_iLarg + j + 1];
		 l_iSomme += image [(i+1)*l_iLarg + j];
		 l_iSomme += image [(i+1)*l_iLarg + j + 1];

		 PetiteImage->image [(i/2)*l_iLargEff + (j/2)] = l_iSomme / 4;
		}
	}

return PetiteImage;
}




