/////////////////////////////////////////////////////////////////////////////
// Name:        InterfaceImageGray256.cpp
// Purpose:     InterfaceImageGray256 class
// Author:      Alain Bouju
// Modified by:
// Created:     23/10/98
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////

#include "InterfaceImageGray256.h"
// Liste Image Gray
WX_DECLARE_LIST(ImageGray256, ListeImage256);
#include <wx/listimpl.cpp>
WX_DEFINE_LIST(ListeImage256)

ListeImage256 g_wListeImageGray256(wxKEY_STRING);

extern int g_NbImage256;
extern wxBitmap  *g_Bitmap;
extern MyFrame   *g_Frame;

/*****************************************************/
/* Constructeur interface image gray 256 niveau vide */
/*****************************************************/

InterfaceImageGray256::InterfaceImageGray256 ()
{
 
}




/******************************************/
/* Destructeur interface image gray 256   */
/******************************************/

InterfaceImageGray256::~InterfaceImageGray256 ( void )
{
}

/***********************************************/
/* Initialisation de la liste image gray 256   */
/***********************************************/

void InterfaceImageGray256::InitInterfaceImageGray256 ( void )
{
g_wMenuImage256 = new wxMenu;
}

/***********************************************/
/* Recherche d'image de la liste image gray 256*/
/***********************************************/


ImageGray256 * InterfaceImageGray256::ChercherImageGray256(wxString l_wNomImage)
{
ImageGray256 * l_pImageGray256;

if (g_wListeImageGray256.Find(l_wNomImage)==NULL)
	{
	(void)wxMessageBox("Image inexistante",
           "Erreur", wxOK);
	 return NULL;
	}

l_pImageGray256 = g_wListeImageGray256.Find(l_wNomImage)->GetData();
return l_pImageGray256;
}

/***********************************************/
/* Ajouter image dans   la liste image gray 256*/
/***********************************************/


int InterfaceImageGray256::AjouterImageGray256(wxString l_wNomImage, ImageGray256 * l_pImageGray256)
{

if (!( g_NbImage256 < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop d'images ouvertes pour le Menu!", "Erreur", wxOK);
	 return(-1);
	}
	
if (g_wListeImageGray256.Find(l_wNomImage) != NULL)
	{
	(void)wxMessageBox("Image "+l_wNomImage+" existante",
           "Erreur", wxOK);
	 return(-1);
	}

//l_pImageGray256 = g_wListeImageGray256.Find(l_wNomImage);
g_wListeImageGray256.Append(l_wNomImage, l_pImageGray256);
g_wMenuImage256 -> Append(2 * BASELISTE + g_NbImage256, l_wNomImage);
g_NbImage256++;
return(1);
}

/***************************/
/* Ouvrir Fichier Gray 256 */
/***************************/

void InterfaceImageGray256::OuvrirFile256()
{
// Menu plein
if (!( g_NbImage256 < NB_MENU_MAX))
	{
	 wxMessageBox ("Il y a trop d'images ouvertes pour le Menu!", "Erreur", wxOK);
	 return;
	}
	
// Chargement d'un fichier
// Show file selector.
const wxString l_wNomFichier = wxFileSelector("Open Image", (const char *) NULL,
    (const char *) NULL,"pgm",
		  "PGM files (*.pgm)|*.pgm");
// Si fichier vide     
if (l_wNomFichier.IsEmpty())
	return;


// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image : ", "Nom de l'image", "");

// Recherche si l'image Existe de deja
if (g_wListeImageGray256.Find(l_wNomImage)!=NULL)
	{
	(void)wxMessageBox("Image Existante", "Erreur", wxOK);
	 return;
	}

// Debut Attente
wxBeginBusyCursor();

// Lecture de l'image PGM	
ImagePGM  l_imageLu = ImagePGM(l_wNomFichier);

// Si bonne lecture affichage
if (l_imageLu.imageOK)
   	{
	 // Remise a Zero Bitmap pour affichage
	 if ( g_Bitmap )
	 	delete g_Bitmap;
    	 ImageGray256 *l_ImageGrayLu = new ImageGray256(l_wNomImage, &l_imageLu);
    	 g_Bitmap = l_ImageGrayLu -> Visualiser256();
   	 if (g_Bitmap!=NULL)
    		{
		 g_Frame->SetStatusText("Image 256");
    		}
	 g_wListeImageGray256.Append(l_wNomImage.GetData(), l_ImageGrayLu);
	 g_wMenuImage256 -> Append(2 * BASELISTE + g_NbImage256, l_wNomImage.GetData());
	 g_NbImage256++;
	}
	
// Fin attente
wxEndBusyCursor();

// Mise a jour de l'affichage
(g_Frame->canvas)->Refresh();
return;
}

/********************************/
/* Visualisation image gray 256 */
/********************************/

wxBitmap * InterfaceImageGray256::Visualiser256 (ImageGray256 *l_pImageGray256)
{
wxMemoryDC
	l_wMemDC;
long int l_iIndex;
long int l_iX;
long int l_iY;

/* Definition de la zone de l'image */
long int l_iHauteur = l_pImageGray256 -> ChercherHauteur();
long int l_iLargeur = l_pImageGray256 -> ChercherLargeur();
Gray256 * l_pImage = l_pImageGray256 -> ChercherImage();
wxBitmap * p_wImage = new wxBitmap(l_iLargeur, l_iHauteur, -1);
l_wMemDC.SelectObject( *p_wImage );
l_wMemDC.Clear();

/* Definition de la couleur */

wxColour l_wCouleur[256];

/* Initialisation pen */

wxPen l_wPen[256];

/* mise en place des couleur */

Gray256 l_iGray;

/* mise en place des couleur */
unsigned char l_uCouleurGray;
int l_iCouleur;
for(l_iCouleur=0; l_iCouleur <256; l_iCouleur++)
	{
	 l_iGray = l_iCouleur;
	 //l_wCouleur[l_iCouleur].Set(gray, gray, gray);
	 //l_wPen[l_iCouleur].SetColour(&l_wCouleur[l_iCouleur]);
	 l_wPen[l_iCouleur].SetColour(l_iGray, l_iGray, l_iGray);
	 l_wPen[l_iCouleur].SetWidth(wxDOT);
	 l_wPen[l_iCouleur].SetStyle(wxSOLID);
	}

/* Dessin de l'image */
l_iIndex = 0;

for(long int l_iIndiceY=0; l_iIndiceY < l_iHauteur; l_iIndiceY++)
{
 for(long int l_iIndiceX=0; l_iIndiceX < l_iLargeur; l_iIndiceX++)
	{
	 l_iCouleur = l_pImage[l_iIndex+l_iIndiceX];		 	
	 l_wMemDC.SetPen(l_wPen[l_iCouleur]);
	 l_wMemDC.DrawPoint(l_iIndiceX, l_iIndiceY);		 	
	}
 l_iIndex += l_iLargeur;
}

return (p_wImage);
}

//--------------------------------------
// Affiche l'image gray 256 selectionnee
//--------------------------------------

void InterfaceImageGray256::OnImage256(wxCommandEvent& event)
{
int
	l_id;
	
ImageGray256
	*l_pImageGray256;
		
l_id=event.GetInt();

l_pImageGray256 = g_wListeImageGray256.Find(g_wMenuImage256->GetLabel(l_id))-> GetData();

if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
// Debut Attente
wxBeginBusyCursor();

g_Bitmap = l_pImageGray256->Visualiser256();

// Fin attente
wxEndBusyCursor();

// Mise a jour de l'affichage
(g_Frame->canvas)->Refresh();
return;
}

//----------------------------
// Fonction Inverser image 256
//----------------------------

void InterfaceImageGray256::OnInverser256()
{
ImageGray256
	*l_pImageSourceGray256;
int
	l_iStatus;

	
// Lecture Nom Logique de L'image Source
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

l_pImageSourceGray256 = ChercherImageGray256(l_wNomImage);

if (l_pImageSourceGray256 == NULL)
	{
	 return;
	}

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Debut Attente
wxBeginBusyCursor();

// Recherche si l'image Existe de deja
if (g_wListeImageGray256.Find(l_wNomImageDestination)!=NULL)
	{	
	(void)wxMessageBox("Image Existante",
            "Erreur", wxOK);
	 return;
	}
	
// Creation de l'Image
ImageGray256 *l_ImageGrayDestination = new ImageGray256(l_pImageSourceGray256);
// Inversion de l'Image
l_ImageGrayDestination->Inverse();
// Insertion dans la Liste
l_iStatus = AjouterImageGray256(l_wNomImageDestination.GetData(), l_ImageGrayDestination);
// Affichage
if (l_iStatus != -1)
	{
	 if (g_Bitmap) //liberation de la memoire
		{
		 delete g_Bitmap;
		}

	 g_Bitmap = l_ImageGrayDestination->Visualiser256();

	 // Mise a jour de l'affichage
	 (g_Frame->canvas)->Refresh();
	}
// Fin attente
wxEndBusyCursor();
return;
}

//----------------------------------
// Fonction Diviser taille image 256
//----------------------------------

void InterfaceImageGray256::OnDiviser256()
{
ImageGray256
	*l_pImageSourceGray256;
int
	l_iStatus;

// Lecture Nom Logique de L'image Source
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

l_pImageSourceGray256 = ChercherImageGray256(l_wNomImage);

if (l_pImageSourceGray256 == NULL)
	{
	 return;
	}

// Lecture Nom Logique de L'image 
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Debut Attente
wxBeginBusyCursor();

// Diminution de l'Image
ImageGray256 *l_ImageGrayDestination = l_pImageSourceGray256->Diviser(l_wNomImageDestination);
// Insertion dans la Liste
l_iStatus = AjouterImageGray256(l_wNomImageDestination.GetData(), l_ImageGrayDestination);
// Affichage
if (l_iStatus != -1)
	{
	 if (g_Bitmap) //liberation de la memoire
		{
		 delete g_Bitmap;
		}

	 g_Bitmap = l_ImageGrayDestination->Visualiser256();

	 // Mise a jour de l'affichage
	 (g_Frame->canvas)->Refresh();
	}
// Fin attente
wxEndBusyCursor();

return;
}
