/////////////////////////////////////////////////////////////////////////////
// Name:        Interface.h
// Purpose:     wxBitmap class
// Author:      Alain Bouju
// Modified by:
// Created:     15/10/98
// RCS-ID:      
// Copyright:   
// Licence:   	
/////////////////////////////////////////////////////////////////////////////
/* Copyright (C) TAI  by A. Bouju (abouju@univ-lr.fr)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can contact me at : alain.bouju@univ-lr.fr 

TAI version 0.1.1, Copyright (C)  A. Bouju
TAI comes with ABSOLUTELY NO WARRANTY; 

This General Public License does not permit incorporating your program into proprietary programs. If
your program is a subroutine library, you may consider it more useful to permit linking proprietary
applications with the library. If this is what you want to do, use the GNU Library General Public
License instead of this License. 

Return to GNU's home page. 

FSF & GNU inquiries & questions to gnu@gnu.org. Other ways to contact the FSF. 

Comments on these web pages to webmasters@www.gnu.org, send other questions to gnu@gnu.org. 

Copyright notice above.
Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA 
*/

#ifndef INTERFACE_H__
#define INTERFACE_H__

#ifdef __GNUG__
#pragma interface
#endif
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#include "InterfaceImageGray256.h"
#include "ImageBin.h"
#include "ImageDouble.h"
#include "MasqueDouble.h"

// Define a new application 
class MyApp: public wxApp
{
  public:
    MyApp(void) ;
    bool OnInit(void);
};

// Define a new frame
class MyCanvas;

class MyFrame: public wxFrame
{
  public:
    MyCanvas *canvas;
    MyFrame(wxFrame *parent, const wxString& title, const wxPoint& pos, const wxSize& size);

    bool OnClose(void);
    void OnActivate(bool) {}
    void OuvrirFile256(wxCommandEvent& event);
    void OnSaveFile256(wxCommandEvent& event);
    void Quitter(wxCommandEvent& event);
 
    
    void OnImage256(wxCommandEvent& event);
    void OnInverser256(wxCommandEvent& event);
    void OnDiviser256(wxCommandEvent& event);
    void OnSeuiller256(wxCommandEvent& event);
    void OnConvoluer256(wxCommandEvent& event);
    
    // Methode Image Bin
    void OnImageBin(wxCommandEvent& event);
    void OnInverserBin(wxCommandEvent& event);
    
    // Methode Image Double
    void OnImageDouble(wxCommandEvent& event);
    void OnConvertirImageGray(wxCommandEvent& event);
    void OnConvertirImageGrayMinMax(wxCommandEvent& event);
    void OnImageDoubleAfficherMinMax(wxCommandEvent& event);
    void OnConvoluerImageDouble(wxCommandEvent& event);
    void OnSeuillerDouble(wxCommandEvent& event);
    
    // Methode Masque
    void OnOuvrirMasqueDouble(wxCommandEvent& event);
    
    //Menu About
    void OnAbout(wxCommandEvent& event);    
    void OnTest(wxCommandEvent& event);    

DECLARE_EVENT_TABLE()
};

// Define a new canvas which can receive some events
class MyCanvas: public wxScrolledWindow
{
  public:
    MyCanvas(wxWindow *parent, const wxPoint& pos, const wxSize& size);
    ~MyCanvas(void) ;

    void OnPaint(wxPaintEvent& event);
DECLARE_EVENT_TABLE()
};

#define NB_MENU_MAX 10

// Menu Fichier
#define TAI_OUVRIR_FILE_256  			100
#define TAI_SAVE_FILE_256  			101
#define TAI_OUVRIR_MASQUE_DOUBLE		102
#define TAI_QUIT       				103

// Menu Operation 256
#define TAI_INVERSER_256			200
#define TAI_DIVISER_256				201
#define TAI_SEUILLER_256			202
#define TAI_CONVOLUER_256			203

// Menu Operation Bin
#define TAI_INVERSER_BIN			300

// Menu Operation Double 
#define TAI_CONVERTIR_IMAGE_GRAY		400
#define TAI_CONVERTIR_IMAGE_GRAY_MIN_MAX	401
#define TAI_AFFICHER_MIN_MAX			402
#define TAI_CONVOLUER_DOUBLE			403
#define TAI_SEUILLER_DOUBLE			404

// Menu About
#define TAI_ABOUT      				501
#define TAI_TEST				502

// BASELISTE 2000 image 256, image bin, image Double,
#define BASELISTE       			1000

#endif
