/////////////////////////////////////////////////////////////////////////////
// Name:        Interface.cpp
// Purpose:     Demos d'Interface traitement d'images
// Author:      Alain Bouju
// Modified by:
// Created:     15/10/98
// RCS-ID:      $ $
// Copyright:   
// Licence:   	
/////////////////////////////////////////////////////////////////////////////

#include "define.h"

#ifdef __GNUG__
#pragma implementation "Interface.h"
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifdef __WXMSW__
#include <wx/pnghand.h>
#endif

#include "Interface.h"

#ifdef USE_XPM
    #include "tai0.1.1.xpm"
#endif

// Frenetre principale
MyFrame   *g_Frame = 0;//(MyFrame *) NULL
// Image principale
wxBitmap  *g_Bitmap = (wxBitmap *) NULL;

// Nb images
// Attention gestion des evenements
int g_NbImage256 = 0;
int g_NbImageBin = 0;
int g_NbImageDouble = 0;
int g_NbMasqueDouble = 0;

// Liste Image Gray
InterfaceImageGray256 g_InterfaceImageGray256;

wxMenu *g_wMenuImage256; 

// Liste Image Bin
WX_DECLARE_LIST(ImageBin, ListeImageBin);
#include <wx/listimpl.cpp>
WX_DEFINE_LIST(ListeImageBin)

ListeImageBin g_wListeImageBin(wxKEY_STRING);

wxMenu *g_wMenuImageBin;

// Liste Image Double
WX_DECLARE_LIST(ImageDouble, ListeImageDouble);
#include <wx/listimpl.cpp>
WX_DEFINE_LIST(ListeImageDouble)

ListeImageDouble g_wListeImageDouble(wxKEY_STRING);

wxMenu *g_wMenuImageDouble;


// Liste Masque Double
WX_DECLARE_LIST(MasqueDouble, ListeMasqueDouble);
#include <wx/listimpl.cpp>
WX_DEFINE_LIST(ListeMasqueDouble)

ListeMasqueDouble g_wListeMasqueDouble(wxKEY_STRING);

// Indique qu'il peut y avoir plusieurs fenetres

//---------------------------------------
// Creation d'un nouvel objet application
//---------------------------------------

IMPLEMENT_APP(MyApp)

//--------------------------------------
// Definition d'une nouvelle application
//--------------------------------------

MyApp::MyApp()
{
}

//--------------------------------------
// Equivalent du main
//--------------------------------------

bool MyApp::OnInit(void)
{
  int l_iTest;

  // Attention pas de Handler avec GTK
  //wxBitmap::AddHandler(new wxPGMFileHandler);

  // Creation de la fenetre principale
  // Create the main frame window
  g_Frame = new MyFrame((wxFrame *) NULL, "TAI 0.1.1-Traitements et analyses d'images", wxPoint(0, 0), wxSize(600, 540));

  // Creation d'une icone
  g_Frame->SetIcon( wxICON(tai0_1_1) );
  // Creation d'une ligne de status
  // Give it a status line
  g_Frame->CreateStatusBar(1);

  // Barre de Menu
  // Make a menubar
  // Specifique ImageGray 256
  g_InterfaceImageGray256.InitInterfaceImageGray256();
  
  wxMenu *l_wMenuFichier = new wxMenu;
  g_wMenuImage256= new wxMenu;
  g_wMenuImageBin = new wxMenu;
  g_wMenuImageDouble = new wxMenu;
  
  wxMenu *l_wMenuOperation256 = new wxMenu;
  wxMenu *l_wMenuOperationBin = new wxMenu;
  wxMenu *l_wMenuOperationDouble = new wxMenu;
  wxMenu *l_wMenuAide = new wxMenu;

  
  // Menu Fichier
  l_wMenuFichier -> Append(TAI_OUVRIR_FILE_256, "&Ouvrir-PGM", "Ouverture et chargement d'un fichier PGM");
  l_wMenuFichier -> Append(TAI_SAVE_FILE_256, "&Enregistrer-PGM", "Sauvegarde de l'image au format PGM");
  l_wMenuFichier -> Append(TAI_OUVRIR_MASQUE_DOUBLE, "&Masque", "Chargement d'un masque de convolution");
  l_wMenuFichier -> Append(TAI_QUIT, "F&ermer", "Fin de l'application");
  
  // Menu Operation 256
  l_wMenuOperation256 ->Append(TAI_INVERSER_256, "&Inverser", "Inversion de l'image");
  l_wMenuOperation256 ->Append(TAI_DIVISER_256, "&Diviser", "Division de la taille de l'image");
  l_wMenuOperation256 ->Append(TAI_SEUILLER_256, "&Seuiller", "Seuillage de l'image pour obtenir une image binaire");
  l_wMenuOperation256 ->Append(TAI_CONVOLUER_256, "&Convoluer", "Convolution de l'image pour obtenir une image double");

  // Menu Operation Bin
  l_wMenuOperationBin ->Append(TAI_INVERSER_BIN, "&Inverser", "Inversion de l'image binaire");

  // Menu operation Double
  l_wMenuOperationDouble ->Append(TAI_CONVERTIR_IMAGE_GRAY, "&Convertir 256", "Conversion de l'image en 256 gris");
  l_wMenuOperationDouble ->Append(TAI_CONVERTIR_IMAGE_GRAY_MIN_MAX, "&Convertir 256 Min-Max",
  "Conversion de l'image en 256 gris entre niveau Min et Max");
  l_wMenuOperationDouble ->Append(TAI_AFFICHER_MIN_MAX, "&Afficher Min-Max",
  "Affiche la valeur Max et Min de l'image");
  l_wMenuOperationDouble ->Append(TAI_SEUILLER_DOUBLE, "&Seuiller", "Seuillage de l'image pour obtenir une image binaire");
  l_wMenuOperationDouble ->Append(TAI_CONVOLUER_DOUBLE, "&Convoluer",
  "Convolution de l'image");
  
  // Menu Aide
  l_wMenuAide -> Append(TAI_ABOUT, "&Aide", "Information");
  l_wMenuAide -> Append(TAI_TEST, "&Test", "Programme de Test");

  // Bar de Menu de l'application
  wxMenuBar *l_wMenuBar = new wxMenuBar;

  l_wMenuBar -> Append(l_wMenuFichier, "&Fichier");
  l_wMenuBar -> Append(g_InterfaceImageGray256.g_wMenuImage256, "&Image-256");
  l_wMenuBar -> Append(g_wMenuImageBin, "&Image-Bin");
  l_wMenuBar -> Append(g_wMenuImageDouble, "&Image-Double");
  l_wMenuBar -> Append(l_wMenuOperation256, "&Op-256");
  l_wMenuBar -> Append(l_wMenuOperationBin, "&Op-Bin");
  l_wMenuBar -> Append(l_wMenuOperationDouble, "&Op-Double");
    
  l_wMenuBar -> Append(l_wMenuAide, "&Aide");

  // Association du menu bar avec la Frame
  // Associate the menu bar with the frame
  g_Frame->SetMenuBar(l_wMenuBar);

  // Creation d'un canvas pour les images
  MyCanvas *canvas = new MyCanvas(g_Frame, wxPoint(0, 0), wxSize(512, 512));

  // Give it scrollbars: the virtual canvas is 20 * 50 = 1000 pixels in each direction
  // Avec Scrollbar probleme de rafraichissement
  canvas->SetScrollbars(20, 20, 50, 50, 0, 0);
  
  g_Frame -> canvas = canvas;

  g_Frame -> Show(TRUE);

  g_Frame -> SetStatusText("");
  
  //////////////////
  // Initialisation
  //////////////////
  // Chargement Laplacien
  //////////////////
  if (!( g_NbMasqueDouble < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop de Masque", "Erreur", wxOK);
	 return FALSE;
	}
	
  // Chargement d'un fichier
  // Lecture Nom Logique du Masque
  wxString l_wRacine = wxString(PREFIX);
  wxString l_wNomMasqueLaplacien = wxString("Laplacien");
  wxString l_wCheminMasqueLaplacien = l_wRacine + wxString("/share/masque/laplacien.mf");
  
  // Recherche si le masque Existe deja
  if (g_wListeMasqueDouble.Find(l_wNomMasqueLaplacien)!=NULL)
	{
	(void)wxMessageBox("Masque Existant",
            "Erreur", wxOK);
	 return FALSE;
	}
  // Creation du Filtre
  MasqueDouble * l_MasqueDoubleLaplacien = new MasqueDouble();
  l_iTest = l_MasqueDoubleLaplacien -> LectureFichier(l_wCheminMasqueLaplacien,
  l_wNomMasqueLaplacien);
  
  if (l_iTest != 1)
    {
      (void)wxMessageBox("Erreur a l'ouverture",
            "Erreur", wxOK);
      return FALSE;
    }
  
  g_wListeMasqueDouble.Append(l_wNomMasqueLaplacien.GetData(),
  l_MasqueDoubleLaplacien);
  g_NbMasqueDouble++;
  //////////////////
  // Chargement Moyen
  //////////////////
  if (!( g_NbMasqueDouble < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop de Masque", "Erreur", wxOK);
	 return FALSE;
	}
	
  // Chargement d'un fichier
  // Lecture Nom Logique du Masque
  wxString l_wNomMasqueMoyen = wxString("Moyen3x3");
  wxString l_wCheminMasqueMoyen = l_wRacine + wxString("/share/masque/moyen3x3.mf");
  
  // Recherche si le masque Existe deja
  if (g_wListeMasqueDouble.Find(l_wNomMasqueMoyen)!=NULL)
	{
	(void)wxMessageBox("Masque Existant",
            "Erreur", wxOK);
	 return FALSE;
	}
  // Creation du Filtre
  MasqueDouble * l_MasqueDoubleMoyen = new MasqueDouble();
  l_iTest = l_MasqueDoubleMoyen -> LectureFichier(l_wCheminMasqueMoyen,
  l_wNomMasqueMoyen);
  
  if (l_iTest != 1)
    {
      (void)wxMessageBox("Erreur a l'ouverture",
            "Erreur", wxOK);
      return FALSE;
    }
  
  g_wListeMasqueDouble.Append(l_wNomMasqueMoyen.GetData(),
  l_MasqueDoubleMoyen);
  g_NbMasqueDouble++;

  return TRUE;
}

BEGIN_EVENT_TABLE(MyFrame, wxFrame)
// Menu Fichier
    EVT_MENU(TAI_OUVRIR_FILE_256,    	MyFrame::OuvrirFile256)
    EVT_MENU(TAI_SAVE_FILE_256, 	MyFrame::OnSaveFile256)
    EVT_MENU(TAI_OUVRIR_MASQUE_DOUBLE, 	MyFrame::OnOuvrirMasqueDouble)
    EVT_MENU(TAI_QUIT,      		MyFrame::Quitter)

// Menu image-256    
    EVT_MENU(2*BASELISTE,   MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+1, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+2, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+3, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+4, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+5, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+6, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+7, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+8, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+9, MyFrame::OnImage256)
    
// Menu image-Bin    
    EVT_MENU(3*BASELISTE,   MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+1, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+2, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+3, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+4, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+5, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+6, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+7, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+8, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+9, MyFrame::OnImageBin)

// Menu image-Double    
    EVT_MENU(4*BASELISTE,   MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+1, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+2, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+3, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+4, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+5, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+6, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+7, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+8, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+9, MyFrame::OnImageDouble)
    
// Menu operation-256
    EVT_MENU(TAI_INVERSER_256,   MyFrame::OnInverser256)
    EVT_MENU(TAI_DIVISER_256,   MyFrame::OnDiviser256)
    EVT_MENU(TAI_SEUILLER_256,   MyFrame::OnSeuiller256)
    EVT_MENU(TAI_CONVOLUER_256,   MyFrame::OnConvoluer256)
    
// Menu operation-Bin
    EVT_MENU(TAI_INVERSER_BIN,   MyFrame::OnInverserBin)

// Menu Operation Double
    EVT_MENU(TAI_CONVERTIR_IMAGE_GRAY,   MyFrame::OnConvertirImageGray)
    EVT_MENU(TAI_CONVERTIR_IMAGE_GRAY_MIN_MAX,   MyFrame::OnConvertirImageGrayMinMax)
    EVT_MENU(TAI_AFFICHER_MIN_MAX,   MyFrame::OnImageDoubleAfficherMinMax)
    EVT_MENU(TAI_CONVOLUER_DOUBLE,   MyFrame::OnConvoluerImageDouble)
    EVT_MENU(TAI_SEUILLER_DOUBLE,   MyFrame::OnSeuillerDouble)

// Menu aide
    EVT_MENU(TAI_ABOUT,     MyFrame::OnAbout)
    EVT_MENU(TAI_TEST,     MyFrame::OnTest)
END_EVENT_TABLE()

//-----------------------
// Definition d'une frame
//-----------------------
// Define my frame constructor
MyFrame::MyFrame(wxFrame *frame, const wxString& title, const wxPoint& pos, const wxSize& size):
  wxFrame(g_Frame, -1, title, pos, size)
{
  canvas = (MyCanvas *) NULL;
}

//---------------------------
// Fermeture de l'application
//---------------------------

void MyFrame::Quitter(wxCommandEvent& WXUNUSED(event))
{
    Close(TRUE);
}

//--------------------
// Page d'information
//--------------------

void MyFrame::OnAbout(wxCommandEvent& WXUNUSED(event))
{
    (void)wxMessageBox("TAI V-0.1\n Alain Bouju - 1998 \n collaboration Andrei Doncescu",
            "version V-0.1 ", wxOK);
}

//----------------------------
// Sauvegarde d'un fichier pgm
//----------------------------

void MyFrame::OnSaveFile256(wxCommandEvent& WXUNUSED(event))
{
ImageGray256
	*l_pImageGray256=NULL;
//Selection Image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image a sauver: ", "Nom de l'image", "");

l_pImageGray256 = g_InterfaceImageGray256.ChercherImageGray256(l_wNomImage);

wxString l_wNomFichier = wxFileSelector( "Save Image", (const char *)NULL, (const char *)NULL, 
                            "pgm", "pgm files (*.pgm)|*.pgm" );

if (l_wNomFichier.IsEmpty())
  	{
	 return;
	}
	
ImagePGM *l_ImagePGM = new ImagePGM(l_pImageGray256);

l_ImagePGM->SauveFichier(l_wNomFichier);

return;
}

// ---------------------------------------
// Ouverture et affichage d'une image PGM
// ---------------------------------------

void MyFrame::OuvrirFile256(wxCommandEvent& WXUNUSED(event))
{
 g_InterfaceImageGray256.OuvrirFile256();
 return;
}

BEGIN_EVENT_TABLE(MyCanvas, wxScrolledWindow)
    EVT_PAINT(MyCanvas::OnPaint)
END_EVENT_TABLE()

// Define a constructor for my canvas
MyCanvas::MyCanvas(wxWindow *parent, const wxPoint& pos, const wxSize& size):
 wxScrolledWindow(parent, -1, pos, size)
{
}

MyCanvas::~MyCanvas(void)
{
}

// Define the repainting behaviour
void MyCanvas::OnPaint(wxPaintEvent& WXUNUSED(event))
{
  wxPaintDC dc(this);
  dc.SetPen(* wxRED_PEN);
  
// Creation d'une image memoire de l'image
  if ( g_Bitmap && g_Bitmap->Ok() )
  {
    wxMemoryDC memDC;
    
    if ( g_Bitmap->GetColourMap() )
    {
        memDC.SetPalette(*g_Bitmap->GetPalette());
        dc.SetPalette(*g_Bitmap->GetPalette());
    }
    
    memDC.SelectObject(*g_Bitmap);

    PrepareDC(dc);
    dc.Blit(0,0,g_Bitmap->GetWidth(), g_Bitmap->GetHeight(), & memDC, 0, 0, wxCOPY, FALSE);

    OnDraw(dc);
    memDC.SelectObject(wxNullBitmap);
  }
}

// ------------------------------------------
// Define the behaviour for the frame closing
// - must delete all frames except for the main one.
// -------------------------------------------------
bool MyFrame::OnClose(void)
{
  Show(FALSE);

  return TRUE;
}

//--------------------------------------
// Affiche l'image gray 256 selectionnee
//--------------------------------------

void MyFrame::OnImage256(wxCommandEvent& event)
{
g_InterfaceImageGray256.OnImage256(event);
return;
}

//----------------------------
// Fonction Inverser image 256
//----------------------------

void MyFrame::OnInverser256(wxCommandEvent& WXUNUSED(event))
{
g_InterfaceImageGray256.OnInverser256();
return;
}

//----------------------------------
// Fonction Diviser taille image 256
//----------------------------------

void MyFrame::OnDiviser256(wxCommandEvent& WXUNUSED(event))
{
g_InterfaceImageGray256.OnDiviser256();
return;
}

//----------------------------------
// Fonction Seuillage image 256
//----------------------------------

void MyFrame::OnSeuiller256(wxCommandEvent& WXUNUSED(event))
{
ImageGray256
	*l_pImageSourceGray256;

// Si pas trop de fichiers ouvert
if (!( g_NbImageBin < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop d'images ouvertes pour le Menu!", "Erreur", wxOK);
	 return;
	}	
// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

l_pImageSourceGray256 = g_InterfaceImageGray256.ChercherImageGray256(l_wNomImage);

if (l_pImageSourceGray256==NULL)
	{
	 return;
	}

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Recherche si l'image Existe de deja
if (g_wListeImageBin.Find(l_wNomImageDestination)!=NULL)
	{
	(void)wxMessageBox("Image Existante", "Erreur", wxOK);
	 return;
	}
	
// Lecture Valeur du Seuil
wxString l_wValeurSeuil = wxGetTextFromUser("Entrez La valeur de seuil: ", "Seuil", "");
int l_iValeurSeuil = atoi(l_wValeurSeuil.GetData());
// Mise entre les bornes du seuil
if (l_iValeurSeuil < 0)
	{
	 l_iValeurSeuil = 0;
	}
if (l_iValeurSeuil > 255)
	{
	 l_iValeurSeuil = 255;
	}	
// Seuillage de l'Image - A faire verifier new

ImageBin *l_ImageBinDestination = new ImageBin(l_pImageSourceGray256, l_iValeurSeuil, l_wNomImageDestination);

// Insertion dans la Liste
g_wListeImageBin.Append(l_wNomImageDestination.GetData(), l_ImageBinDestination);
g_wMenuImageBin -> Append(3 * BASELISTE + g_NbImageBin, l_wNomImageDestination.GetData());
g_NbImageBin++;

// Affichage

if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
g_Bitmap = l_ImageBinDestination->VisualiserBin();
// Mise a jour de l'affichage
canvas->Refresh();
return;
}

//---------------------------------
// Affiche l'image bin selectionnee
//---------------------------------

void MyFrame::OnImageBin(wxCommandEvent& event)
{
int
	l_id;
ImageBin
	*l_pImageBin;

l_id=event.GetInt();

l_pImageBin = g_wListeImageBin.Find(g_wMenuImageBin->GetLabel(l_id))-> GetData();

if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
g_Bitmap = l_pImageBin->VisualiserBin();
// Mise a jour de l'affichage
canvas->Refresh();
return;
}

//-----------------------
// Inverse une image bin 
//-----------------------

void MyFrame::OnInverserBin(wxCommandEvent& WXUNUSED(event))
{
ImageBin
	*l_pImageSourceBin;

// Si pas trop de fichiers ouvert
if (!( g_NbImageBin < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop d'images ouvertes pour le Menu!", "Erreur", wxOK);
	 return;
	}	
// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

// Recherche si l'image n'existe pas
if (g_wListeImageBin.Find(l_wNomImage)==NULL)
	{
	(void)wxMessageBox("Image inexistante",
            "Erreur", wxOK);
	 return;
	}

l_pImageSourceBin = g_wListeImageBin.Find(l_wNomImage)->GetData();

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Recherche si l'image Existe de deja
if (g_wListeImageBin.Find(l_wNomImageDestination)!=NULL)
	{
	
	(void)wxMessageBox("Image Existante",
            "Erreur", wxOK);
	 return;
	}
	
// Creation de l'Image
ImageBin *l_ImageBinDestination = new ImageBin(l_pImageSourceBin);
// Inversion de l'Image
l_ImageBinDestination->Inverse();
// Insertion dans la Liste
g_wListeImageBin.Append(l_wNomImageDestination.GetData(), l_ImageBinDestination);
g_wMenuImageBin -> Append(3 * BASELISTE + g_NbImageBin, l_wNomImageDestination.GetData());
g_NbImageBin++;
// Affichage
if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
g_Bitmap = l_ImageBinDestination->VisualiserBin();
// Mise a jour de l'affichage
canvas->Refresh();
return;
}

//------------------------------------
// Convolution Image Gray 256
//------------------------------------

void MyFrame::OnConvoluer256(wxCommandEvent& event)
{

ImageGray256
	*l_pImageSourceGray256;

int l_iNbMasque;
l_iNbMasque = g_wListeMasqueDouble.Number();
//l_iNbMasque = g_wListeMasqueDouble.GetCount();
if (l_iNbMasque == 0)
  {
    wxMessageBox ("Il n'y a pas de masque", "Erreur", wxOK);
    return;
  }
  
// Affichage des masques disponibles

l_iNbMasque = g_wListeMasqueDouble.Number();
//l_iNbMasque = g_wListeMasqueDouble.GetCount();

wxString l_wxNomMasque[l_iNbMasque];
char * l_zChoix[l_iNbMasque];

//wxNode *node = g_wListeMasqueDouble.First();
wxNode *node = g_wListeMasqueDouble.First();
int l_iIndice=0;
while (node)
  {
    
    l_wxNomMasque[l_iIndice] = ((MasqueDouble *)node->Data())->ChercherNom();
    l_zChoix[l_iIndice] = (char *)l_wxNomMasque[l_iIndice].GetData();
    l_iIndice++;
    node = node->Next();
  }

wxString l_wxResultat = wxGetSingleChoice(wxString("Masque"), wxString("Nom"), l_iNbMasque, l_wxNomMasque,
  NULL,  -1, -1, true, 200, 200);

// si aucun choix fin

if (l_wxResultat.IsEmpty())
	{
	(void)wxMessageBox("Pas de masque selectionne",
            "Erreur", wxOK);
	 return;
	}

// Recherche du masque selectionne
MasqueDouble * l_MasqueDouble;
 l_MasqueDouble = g_wListeMasqueDouble.Find( l_wxResultat.GetData())->GetData();

// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");


l_pImageSourceGray256 = g_InterfaceImageGray256.ChercherImageGray256(l_wNomImage);

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Debut Attente
wxBeginBusyCursor();

// Recherche si l'image Existe de deja
if (g_wListeImageDouble.Find(l_wNomImageDestination)!=NULL)
	{
	(void)wxMessageBox("Image Existante", "Erreur", wxOK);
	 return;
	}

// Produit de convolution
ImageDouble *l_ImageDoubleDestination = l_pImageSourceGray256->Convoluer(l_wNomImageDestination, l_MasqueDouble);

// Insertion dans la Liste Double
g_wListeImageDouble.Append(l_wNomImageDestination.GetData(), l_ImageDoubleDestination);
g_wMenuImageDouble -> Append(4 * BASELISTE + g_NbImageDouble, l_wNomImageDestination.GetData());
g_NbImageDouble++;

// Affichage
if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
g_Bitmap = l_ImageDoubleDestination->VisualiserDouble();

// Fin attente
wxEndBusyCursor();

// Mise a jour de l'affichage
canvas->Refresh();
return;
}

//------------------------------------
// Affiche l'image double selectionnee
//------------------------------------

void MyFrame::OnImageDouble(wxCommandEvent& event)
{
int
	l_id;

ImageDouble
	*l_pImageDouble;

l_id=event.GetInt();

l_pImageDouble = g_wListeImageDouble.Find(g_wMenuImageDouble->GetLabel(l_id))-> GetData();

if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
g_Bitmap = l_pImageDouble->VisualiserDouble();
// Mise a jour de l'affichage
canvas->Refresh();
return;
}

//-----------------------------------------------------
// Convertie en Image Niveau de Gris sans normalisation
//-----------------------------------------------------

void MyFrame::OnConvertirImageGray(wxCommandEvent& event)
{
int
	l_iStatus;
ImageDouble
	*l_pImageSourceDouble;

// Si pas trop de fichiers ouvert
if (!( g_NbImageDouble < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop d'images ouvertes pour le Menu!", "Erreur", wxOK);
	 return;
	}	
// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

// Recherche si l'image n'existe pas
if (g_wListeImageDouble.Find(l_wNomImage)==NULL)
	{
	(void)wxMessageBox("Image inexistante",
            "Erreur", wxOK);
	 return;
	}

l_pImageSourceDouble = g_wListeImageDouble.Find(l_wNomImage)->GetData();

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Debut Attente
wxBeginBusyCursor();

// Creation de l'Image
ImageGray256 *l_ImageGray256Destination = new ImageGray256(l_wNomImageDestination, l_pImageSourceDouble, 0, 255);

// Insertion dans la Liste
l_iStatus = g_InterfaceImageGray256.AjouterImageGray256(l_wNomImageDestination.GetData(), l_ImageGray256Destination);
// Affichage
if (l_iStatus != -1)
	{
	 if (g_Bitmap) //liberation de la memoire
		{
		 delete g_Bitmap;
		}
	 g_Bitmap = l_ImageGray256Destination->Visualiser256();
	 // Mise a jour de l'affichage
	 canvas->Refresh();
	}
// Fin attente
wxEndBusyCursor();
return;
}

//-----------------------------------------------------
// Convertie en Image Niveau de Gris avec normalisation
//-----------------------------------------------------

void MyFrame::OnConvertirImageGrayMinMax(wxCommandEvent& event)
{
int
	l_iStatus;
ImageDouble
	*l_pImageSourceDouble;

// Si pas trop de fichiers ouvert
if (!( g_NbImageDouble < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop d'images ouvertes pour le Menu!", "Erreur", wxOK);
	 return;
	}	
// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

// Recherche si l'image n'existe pas
if (g_wListeImageDouble.Find(l_wNomImage)==NULL)
	{
	(void)wxMessageBox("Image inexistante",
            "Erreur", wxOK);
	 return;
	}

l_pImageSourceDouble = g_wListeImageDouble.Find(l_wNomImage)->GetData();

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");
	
// Creation de l'Image
ImageGray256 *l_ImageGray256Destination = new ImageGray256(l_wNomImageDestination,
l_pImageSourceDouble, l_pImageSourceDouble-> ValeurMin() , l_pImageSourceDouble-> ValeurMax());

// Insertion dans la Liste Gray 256
//g_wListeImageGray256.Append(l_wNomImageDestination.GetData(), l_ImageGray256Destination);
//g_wMenuImage256 -> Append(2 * BASELISTE + g_NbImage256, l_wNomImageDestination.GetData());
//g_NbImage256++;

// Affichage
//if (g_Bitmap) //liberation de la memoire
//	{
//	 delete g_Bitmap;
//	}
//g_Bitmap = l_ImageGray256Destination->Visualiser256();
// Mise a jour de l'affichage
//canvas->Refresh();
return;
}

//-------------------------------------
// Affiche la valeur Min Max de l'image
//-------------------------------------

void MyFrame::OnImageDoubleAfficherMinMax(wxCommandEvent& event)
{
ImageDouble
	*l_pImageSourceDouble;

	
// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image : ", "Nom de l'image", "");

// Recherche si l'image n'existe pas
if (g_wListeImageDouble.Find(l_wNomImage)==NULL)
	{
	(void)wxMessageBox("Image inexistante",
            "Erreur", wxOK);
	 return;
	}

l_pImageSourceDouble = g_wListeImageDouble.Find(l_wNomImage)->GetData();

// A changer quand wxString plus performant
char l_zChaineTemporaire1[40],
 l_zChaineTemporaire2[40];
sprintf(l_zChaineTemporaire1,"%lg",l_pImageSourceDouble->ValeurMax());
sprintf(l_zChaineTemporaire2,"%lg",l_pImageSourceDouble->ValeurMin());

wxString l_wResultatMinMax = wxString("Max: ")+ wxString(l_zChaineTemporaire1)+
wxString("\nMin: ") + wxString(l_zChaineTemporaire2);
(void)wxMessageBox(l_wResultatMinMax, "Valeur", wxOK);
return;
}

//------------------------------------
// Convolution Image Double
//------------------------------------

void MyFrame::OnConvoluerImageDouble(wxCommandEvent& event)
{

ImageDouble
	*l_pImageSourceImageDouble;

int l_iNbMasque;
l_iNbMasque = g_wListeMasqueDouble.Number();
//l_iNbMasque = g_wListeMasqueDouble.GetCount();
if (l_iNbMasque == 0)
  {
    wxMessageBox ("Il n'y a pas de masque", "Erreur", wxOK);
    return;
  }
  
// Affichage des masques disponibles

//l_iNbMasque = g_wListeMasqueDouble.GetCount();

wxString l_wxNomMasque[l_iNbMasque];
char * l_zChoix[l_iNbMasque];

wxNode *node = g_wListeMasqueDouble.First();
int l_iIndice=0;
while (node)
  {
    
    l_wxNomMasque[l_iIndice] = ((MasqueDouble *)node->Data())->ChercherNom();
    l_zChoix[l_iIndice] = (char *)l_wxNomMasque[l_iIndice].GetData();
    l_iIndice++;
    node = node->Next();
  }

const wxString l_wMasqueTitre = wxString("Masque");
const wxString l_wMasqueNom = wxString("Nom");

wxString l_wxResultat = wxGetSingleChoice(wxString("Masque"),wxString("Nom"),
l_iNbMasque, l_wxNomMasque, NULL,  -1, -1, true, 200, 200);

// Recherche du masque selectionne
MasqueDouble * l_MasqueDouble;
if (l_wxResultat.IsEmpty())
	{
	 return;
	}
 l_MasqueDouble = g_wListeMasqueDouble.Find( l_wxResultat.GetData())->GetData();

// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

// Recherche si l'image n'existe pas
if (g_wListeImageDouble.Find(l_wNomImage)==NULL)
	{
	(void)wxMessageBox("Image inexistante",
            "Erreur", wxOK);
	 return;
	}

l_pImageSourceImageDouble = g_wListeImageDouble.Find(l_wNomImage)->GetData();

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Recherche si l'image Existe de deja
if (g_wListeImageDouble.Find(l_wNomImageDestination)!=NULL)
	{
	(void)wxMessageBox("Image Existante", "Erreur", wxOK);
	 return;
	}


// Produit de convolution
ImageDouble *l_ImageDoubleDestination =
l_pImageSourceImageDouble->Convoluer(l_wNomImageDestination, l_MasqueDouble);

// Insertion dans la Liste Double
g_wListeImageDouble.Append(l_wNomImageDestination.GetData(), l_ImageDoubleDestination);
g_wMenuImageDouble -> Append(4 * BASELISTE + g_NbImageDouble, l_wNomImageDestination.GetData());
g_NbImageDouble++;

// Affichage
if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
g_Bitmap = l_ImageDoubleDestination->VisualiserDouble();
// Mise a jour de l'affichage
canvas->Refresh();
return;
}

//----------------------------------
// Fonction Seuillage image Double
//----------------------------------

void MyFrame::OnSeuillerDouble(wxCommandEvent& WXUNUSED(event))
{
ImageDouble
	*l_pImageSourceDouble;

// Si pas trop de fichiers ouvert
if (!( g_NbImageDouble < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop d'images ouvertes pour le Menu!", "Erreur", wxOK);
	 return;
	}	
// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

// Recherche si l'image n'existe pas
if (g_wListeImageDouble.Find(l_wNomImage)==NULL)
	{
	(void)wxMessageBox("Image inexistante",
            "Erreur", wxOK);
	 return;
	}

l_pImageSourceDouble = g_wListeImageDouble.Find(l_wNomImage)->GetData();

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Recherche si l'image Existe de deja
if (g_wListeImageBin.Find(l_wNomImageDestination)!=NULL)
	{
	
	(void)wxMessageBox("Image Existante",
            "Erreur", wxOK);
	 return;
	}
	
// Lecture Valeur du Seuil
wxString l_wValeurSeuil = wxGetTextFromUser("Entrez La valeur de seuil: ", "Seuil", "");
double l_dValeurSeuil = atof(l_wValeurSeuil.GetData());

// Seuillage de l'Image - A faire verifier new

ImageBin *l_ImageBinDestination = new ImageBin(l_pImageSourceDouble, l_dValeurSeuil, l_wNomImageDestination);

// Insertion dans la Liste
g_wListeImageBin.Append(l_wNomImageDestination.GetData(), l_ImageBinDestination);
g_wMenuImageBin -> Append(3 * BASELISTE + g_NbImageBin, l_wNomImageDestination.GetData());
g_NbImageBin++;

// Affichage

if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
g_Bitmap = l_ImageBinDestination->VisualiserBin();
// Mise a jour de l'affichage
canvas->Refresh();
return;
}


//------------------------------------
// Lecture masque de convolution
//------------------------------------

void MyFrame::OnOuvrirMasqueDouble(wxCommandEvent& event)
{
int l_iTest;
 Double * l_Masque;
// Menu plein
if (!( g_NbMasqueDouble < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop de Masque", "Erreur", wxOK);
	 return;
	}
	
// Chargement d'un fichier
// Show file selector.
const wxString l_wNomFichier = wxFileSelector("Open Masque", (const char *) NULL,
    (const char *) NULL,".mf",
		  "mf files (*.mf)|*.mf|tous|*");
// Si fichier vide     
if (l_wNomFichier.IsEmpty())
	return;


// Lecture Nom Logique du Masque
wxString l_wNomMasque = wxGetTextFromUser("Entrez le nom du masque", "Nom du masque", "");

// Recherche si le masque Existe deja
if (g_wListeMasqueDouble.Find(l_wNomMasque)!=NULL)
	{	
	(void)wxMessageBox("Masque Existant",
            "Erreur", wxOK);
	 return;
	}

// Creation du Filtre

MasqueDouble * l_MasqueDouble = new MasqueDouble();
l_iTest = l_MasqueDouble -> LectureFichier(l_wNomFichier, l_wNomMasque);

if (l_iTest != 1)
  {
   (void)wxMessageBox("Erreur a l'ouverture", "Erreur", wxOK);
   return;
  }


// Ajout dans la liste des Masques
g_wListeMasqueDouble.Append(l_wNomMasque.GetData(), l_MasqueDouble);
g_NbMasqueDouble++;
return;
}

//----------------------------------
// Fonction Test
//----------------------------------

void MyFrame::OnTest(wxCommandEvent& WXUNUSED(event))
{

return;
}
