//////////////////////////////////////////////////////////////////////////////
// Name:        ImagePGM.cpp
// Purpose:     ImagePGM class
// Author:      Alain Bouju
// Modified by:
// Created:     30/10/98
// RCS-ID:      
// Copyright:   
// Licence:   
/////////////////////////////////////////////////////////////////////////////

#include "ImagePGM.h"

#define MAX_TAMPON 80
#define MAX_LECTURE 65534


//-------------------------
// Constructeur nom fichier
//-------------------------

ImagePGM::ImagePGM (wxString nom_physique)
{

 LectureFichier(nom_physique);

}

//--------------
// Constructeur 
//--------------

ImagePGM::ImagePGM (const ImagePGM &imIn)
{
/* A FAIRE */
 nomPhysique = wxString(imIn.nomPhysique);
 nomLogique = wxString(imIn.nomLogique);
 hauteur = imIn.hauteur;
/* A FAIRE ... */
}

//--------------
// Constructeur 
//--------------

ImagePGM::ImagePGM (ImageGray256 *source)
{

 hauteur = source->ChercherHauteur ();
 largeur = source->ChercherLargeur ();
 profondeur = 255;
 image = (Gray256 *)source->ChercherImage ();
	
}

//ImagePGM::ImagePGM (ImageBin *source)
//{
//	hauteur = source->ChercherHauteur ();
//	largeur = source->ChercherLargeur ();
//	profondeur = 255;
//
//	image = (unsigned char *)source->ChercherImage ();
//	
//}


//ImagePGM::ImagePGM (ImageBin *source, char *nom_sauvegarde)
//{
//	hauteur = source->ChercherHauteur ();
//	largeur = source->ChercherLargeur ();
//	profondeur = 255;
//
//	nom_physique = (char *) malloc (25);
//	strcpy (nom_physique, nom_sauvegarde);
//
//	image = (unsigned char *)source->ChercherImage ();
//	
//}

ImagePGM::~ImagePGM ()
{
/* si image bien chargee destruction de l'image */
 if (imageOK)
	{
	 delete [] image;
	}
}

/**************************************/
/* Recherche de la Hauteur de l'Image */
/**************************************/

int ImagePGM::ChercherHauteur ()
{
 return hauteur;
}

/**************************************/
/* Recherche de la Largeur de l'Image */
/**************************************/

int ImagePGM::ChercherLargeur ()
{
 return largeur;
}

/**************************************/
/* Recherche nombre niveau de Gris    */
/**************************************/

int ImagePGM::ChercherProfondeur ()
{
 return profondeur;
}

/***********************************/
/* Recherche du contenu de l'image */
/***********************************/

Gray256 * ImagePGM::ChercherImage ()
{
 return image;
}

/***************************/
/* lecture d'une Image PGM */
/***************************/

int ImagePGM::LectureFichier(wxString p_wNomPhysique)
{
FILE
	*stream; /* Fichier a Lire */
char
	tampon[MAX_TAMPON],
	*ptr1,
	*ptr2;
unsigned long int
	taille;
int
	larg,
	haut,
	prof;

const char *
	l_zNomPhysique;

/* Nom du Fichier PGM */

 l_zNomPhysique = p_wNomPhysique.GetData();

/* Lecture de l'entete */

 if ((stream = fopen(l_zNomPhysique, "rb")) == NULL) 
	{
	 wxString l_wFichier("Le fichier ");
	 wxString l_wOuverture(" ne peut pas etre ouvert");
	 wxMessageBox (l_wFichier + p_wNomPhysique + l_wOuverture, "Erreur a l'ouverture du fichier !",wxOK);
	 imageOK = false;
	 return (-1);
	}

/* elimination des commentaire */
 do
	 fgets(tampon, MAX_TAMPON, stream);
 while (tampon[0] == '#');

 ptr1 = tampon;
 ptr2 = strtok(ptr1, " \t\n");

/* Recherche du format du fichier */

 if (strncmp(ptr2, "P5", 2))
	{
	 wxString l_wFichier("Le fichier ");
	 wxString l_wFormat(" n'est pas au bon format !");
	 wxMessageBox (l_wFichier + p_wNomPhysique + l_wFormat, "Erreur !",wxOK);
	 imageOK = false;
	 return (-1);
	}

 ptr2 = strtok(NULL, " \t\n");
    
 if (ptr2 == NULL) 
	{
	  do
	  	fgets(tampon, MAX_TAMPON, stream);
	  while (tampon[0] == '#');
	  ptr1 = tampon;
	  ptr2 = strtok(ptr1, " \t\n");
	}

 sscanf(ptr2, "%d", &larg);

 ptr2 = strtok(NULL, " \t\n");
    
 if (ptr2 == NULL) 
	{
	 do
	 	 fgets(tampon, MAX_TAMPON, stream);
	 while (tampon[0] == '#');
	 ptr1 = tampon;
	 ptr2 = strtok(ptr1, " \t\n");
	}

 sscanf(ptr2, "%d", &haut);
 ptr2 = strtok(NULL , " \t\n");
 
 if (ptr2 == NULL)
	{
	 do
	  	 fgets(tampon, MAX_TAMPON, stream);
	 while (tampon[0] == '#');
	
	 ptr1 = tampon;
	 ptr2 = strtok(ptr1, " \t\n");
	}

 sscanf(ptr2, "%d", &prof);

 taille = larg;
 taille *= haut;
	
 image = new Gray256 [taille];
	
 largeur = larg;
 hauteur = haut;
 profondeur = prof;

/* variable pour la lecture de l'image */
 int nb_lecture = haut;
 int taille_lecture = larg;
	
 unsigned char l_pcligne[MAX_LECTURE];
 unsigned int lu;

/* Lecture de l'image */

 if (larg > MAX_LECTURE)
	{
	 wxMessageBox ("Votre image est trop grande !", "Erreur  la lecture !", wxOK);
	}
		
 for (int ligne = 0; ligne < nb_lecture; ligne ++)
	{
	 long int index;
	 index = ligne * taille_lecture;

	 lu = fread (l_pcligne, 1, taille_lecture, stream);
	 if ( ! lu )
		{
			wxMessageBox ("Erreur  la lecture du fichier !", "Erreur",wxOK);
			imageOK = false;
			return (-1);
		}
		
	 for(int colonne = 0;  colonne < taille_lecture; colonne++)
		{
			 image[index+colonne] = l_pcligne[colonne];
		}
		
	}
	




 if (fclose(stream))
	{
	  wxMessageBox ("Erreur a la fermeture du fichier !", "Erreur", wxOK);
	  imageOK = false;
      	  return (-1);
	}
 else
	{
	 imageOK = true;
	 return (1);
	}
}



ImagePGM::SauveFichier (wxString p_wNomPhysique)
{
	FILE	*stream;
const char *
	l_zNomPhysique;

// Ouverture du fichier en ecriture
l_zNomPhysique = p_wNomPhysique;

if ( (stream = fopen (l_zNomPhysique, "wb") ) == NULL )
	{
	  //char erreur[MAX_TAMPON];
	  //sprintf(erreur,"Le fichier %s ne peut pas etre ouvert\n",l_zNomPhysique);
	  wxMessageBox ("Le fichier "+p_wNomPhysique+" ne peut pas etre ouvert\n",
	  "Erreur a l'ouverture du fichier !",wxOK);
	  return (-1);
	}

// Ecriture de l'entete
fprintf (stream, "P5\n%d %d\n", largeur, hauteur);	
fprintf (stream, "#TAI_v0.1\n%d\n", profondeur);
	
int nb_lecture = hauteur;
int taille_lecture = largeur;
unsigned int lu;

if (largeur > MAX_LECTURE)
	{
	 wxMessageBox ("Votre image est trop grande !", "Erreur a
			l'ecriture !", wxOK);
	}

// Ecriture du fichier		
for (int ligne = 0; ligne < nb_lecture; ligne ++)
	{
	 unsigned char *index;

	 index = image + (ligne * taille_lecture);

	 lu = fwrite (index, 1, taille_lecture, stream);
	}

if (!lu)
	{
	 wxMessageBox ("Erreur a l'ecriture du fichier !", "Erreur",wxOK);
	 return (-1);
	}

// Fermeture du fichier
if (fclose(stream))
	{
	 wxMessageBox ("Erreur a la fermeture du fichier !", "Erreur", wxOK);
	 return (-1);
	}
else
	return (1);
}
