/////////////////////////////////////////////////////////////////////////////
// Name:        ImageGray256.h
// Purpose:     ImageGray256 class
// Author:      Alain Bouju
// Modified by:
// Created:     23/10/98
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////
/* Copyright (C) TAI  by A. Bouju (abouju@univ-lr.fr)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can contact me at : alain.bouju@univ-lr.fr 

TAI version 0.1.1, Copyright (C)  A. Bouju
TAI comes with ABSOLUTELY NO WARRANTY; 

This General Public License does not permit incorporating your program into proprietary programs. If
your program is a subroutine library, you may consider it more useful to permit linking proprietary
applications with the library. If this is what you want to do, use the GNU Library General Public
License instead of this License. 

Return to GNU's home page. 

FSF & GNU inquiries & questions to gnu@gnu.org. Other ways to contact the FSF. 

Comments on these web pages to webmasters@www.gnu.org, send other questions to gnu@gnu.org. 

Copyright notice above.
Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA 
*/
/* Definition de la classe ImageGray256 */
#ifndef IMAGEGRAY256_H__
#define IMAGEGRAY256_H__

#ifdef __GNUG__
#pragma interface
#endif

#include "wx/wx.h"

typedef unsigned char Gray256;

#include "ImagePGM.h"
#include "ImageDouble.h"
#include "ImageBin.h"
#include "MasqueDouble.h"

//#include "wxima.h"

class ImagePGM;

class ImageGray256{
	wxString nomLogique;
protected :
	int hauteur;
	int largeur;
	Gray256 *image;

public :
//	Constructeur
	ImageGray256 (void);
//	ImageGray256 (ImageBin *source);
//	ImageGray256 (wxImage *ima, char *leurre);
	ImageGray256 (ImageGray256 *source);
	ImageGray256 (wxString p_wNomLogique, ImagePGM *source);
	ImageGray256 (wxString p_wNomLogique, ImageDouble *p_Source, int p_Min, int p_Max);
	
	~ImageGray256 (void);

//	Optention d'information sur objet
	int ChercherHauteur ();
	int ChercherLargeur ();
	wxString Chercher_Nom ();
	Gray256 *ChercherImage ();

//	Methodes

	wxBitmap * Visualiser256 ();
	Inverse ();

//	ImageGray256 *Masque (ImageBin *, char *);
	ImageGray256 *Diviser (wxString p_wNomDestination);
	ImageDouble * Convoluer(wxString p_wNomDestination, MasqueDouble * p_MasqueConvolution);

	//Pour la convolution
	ImageGray256 *SaisieConvolution(char *NomDestination);
	ImageGray256 *Gradiant(char *NomDestination);
	ImageGray256 *Laplacien (char *NomDestination);
	ImageGray256 *Convolution(char *NomDestination,double *Matrice,int TailleMatrice,int Mode=-1);
	ImageGray256 *Convolution(double *Filtre,int TailleFiltreH, int TailleFiltreV,char *NomDestination);
	ImageGray256 *Moyennage(char *NomDestination);
	ImageGray256 *Gaussien(char *NomDestination);

	//Pour l'egalisation d'histogramme
	
	ImageGray256 *EgaliserHistogramme(char *NomDestination);
	ImageGray256 *DetectionContour (char *, int);


};

#endif
