/////////////////////////////////////////////////////////////////////////////
// Name:        ImageBin.h
// Purpose:     ImageBin class
// Author:      Alain Bouju
// Modified by:
// Created:     21/04/99
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////
/* Copyright (C) TAI  by A. Bouju (abouju@univ-lr.fr)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can contact me at : alain.bouju@univ-lr.fr 

TAI version 0.1.1, Copyright (C)  A. Bouju
TAI comes with ABSOLUTELY NO WARRANTY; 

This General Public License does not permit incorporating your program into proprietary programs. If
your program is a subroutine library, you may consider it more useful to permit linking proprietary
applications with the library. If this is what you want to do, use the GNU Library General Public
License instead of this License. 

Return to GNU's home page. 

FSF & GNU inquiries & questions to gnu@gnu.org. Other ways to contact the FSF. 

Comments on these web pages to webmasters@www.gnu.org, send other questions to gnu@gnu.org. 

Copyright notice above.
Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA 
*/
/* Definition de la classe Bin */
#ifndef IMAGEBIN_H__
#define IMAGEBIN_H__

#ifdef __GNUG__
#pragma interface
#endif

#include "wx/wx.h"

typedef unsigned char Bin;

#include "ImagePGM.h"
#include "ImageGray256.h"
#include "ImageDouble.h"

class ImageGray256;
class ImageDouble;
class MasqueBin;

class ImageBin{
	wxString nomLogique;
	int hauteur;
	int largeur;
	Bin *image;
	
public :
//	Constructeur
	ImageBin (void);
//	ImageGray256 (ImageBin *source);
//	ImageGray256 (wxImage *ima, char *leurre);
//	ImageBin (ImagePGM *source, wxString p_wNomLogique);
	ImageBin (ImageGray256 *p_source, int p_iSeuil, wxString p_wNomLogique);
	ImageBin (ImageDouble *p_source, double p_dSeuil, wxString p_wNomLogique);
	ImageBin (ImageBin *source);
	~ImageBin (void);

//	Optention d'information sur objet
	int ChercherHauteur ();
	int ChercherLargeur ();
	wxString Chercher_Nom ();
	Bin *ChercherImage ();

//	Methodes

	wxBitmap * VisualiserBin ();
	Inverse ();
	ImageBin *Diviser (wxString p_wNomDestination);

};


#endif
