/////////////////////////////////////////////////////////////////////////////
// Name:        InterfaceMasqueDouble.cpp
// Purpose:     InterfaceMasqueDouble class
// Author:      Alain Bouju
// Modified by:
// Created:     04/04/00
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////

#include "InterfaceMasqueDouble.h"

// Liste Image Double
WX_DECLARE_LIST(MasqueDouble, ListeMasqueDouble);
#include <wx/listimpl.cpp>
WX_DEFINE_LIST(ListeMasqueDouble)

ListeMasqueDouble g_wListeMasqueDouble(wxKEY_STRING);

extern int g_NbMasqueDouble;
extern MyFrame   *g_Frame;

/*********************************************/
/* Constructeur interface masque Double vide */
/*********************************************/

InterfaceMasqueDouble::InterfaceMasqueDouble ()
{
 
}




/*****************************************/
/* Destructeur interface masque Double   */
/*****************************************/

InterfaceMasqueDouble::~InterfaceMasqueDouble ( void )
{
}

/**********************************************/
/* Initialisation de la liste masque Double   */
/**********************************************/

void InterfaceMasqueDouble::InitInterfaceMasqueDouble ( void )
{
g_wMenuMasqueDouble = new wxMenu;
}

/*************************************************/
/* Recherche de masque de la liste masque Double */
/*************************************************/


MasqueDouble * InterfaceMasqueDouble::ChercherMasqueDouble(wxString l_wNomMasque)
{
MasqueDouble * l_pMasqueDouble;

if (g_wListeMasqueDouble.Find(l_wNomMasque)==NULL)
	{
	(void)wxMessageBox("Masque inexistante",
           "Erreur", wxOK);
	 return NULL;
	}

l_pMasqueDouble = g_wListeMasqueDouble.Find(l_wNomMasque)->GetData();
return l_pMasqueDouble;
}

/**********************************************/
/* Ajouter masque dans la liste masque Double */
/**********************************************/


int InterfaceMasqueDouble::AjouterMasqueDouble(wxString l_wNomMasque, MasqueDouble *
l_pMasqueDouble)
{


if (g_wListeMasqueDouble.Find(l_wNomMasque) != NULL)
	{
	(void)wxMessageBox("Masque "+l_wNomMasque+" existante",
           "Erreur", wxOK);
	 return(-1);
	}


g_wListeMasqueDouble.Append(l_wNomMasque, l_pMasqueDouble);
g_NbMasqueDouble++;
return(1);
}


/***********************************************************/
/* Recherche graphique de masque de la liste masque Double */
/***********************************************************/


MasqueDouble * InterfaceMasqueDouble::SelectionMasqueDouble( void )
{
int l_iNbMasque;

l_iNbMasque = g_wListeMasqueDouble.Number();
//l_iNbMasque = g_wListeMasqueDouble.GetCount();
if (l_iNbMasque == 0)
  {
    wxMessageBox ("Il n'y a pas de masque", "Erreur", wxOK);
    return NULL;
  }
  
// Affichage des masques disponibles

wxString l_wxNomMasque[l_iNbMasque];
char * l_zChoix[l_iNbMasque];

//wxNode *node = g_wListeMasqueDouble.First();
wxNode *node = g_wListeMasqueDouble.First();
int l_iIndice=0;
while (node)
  {
    
    l_wxNomMasque[l_iIndice] = ((MasqueDouble *)node->Data())->ChercherNom();
    l_zChoix[l_iIndice] = (char *)l_wxNomMasque[l_iIndice].GetData();
    l_iIndice++;
    node = node->Next();
  }

wxString l_wxResultat = wxGetSingleChoice(wxString("Masque"), wxString("Nom"), l_iNbMasque, l_wxNomMasque,
  NULL,  -1, -1, true, 200, 200);

// si aucun choix fin

if (l_wxResultat.IsEmpty())
	{
	(void)wxMessageBox("Pas de masque selectionne",
            "Erreur", wxOK);
	 return NULL;
	}

MasqueDouble * l_MasqueDouble;

l_MasqueDouble = g_wListeMasqueDouble.Find( l_wxResultat.GetData())->GetData();

return l_MasqueDouble;
}
