/////////////////////////////////////////////////////////////////////////////
// Name:        InterfaceMasqueBin.cpp
// Purpose:     InterfaceMasqueBin class
// Author:      Alain Bouju
// Modified by:
// Created:     25/04/00
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////

#include "InterfaceMasqueBin.h"

// Liste Image Double
WX_DECLARE_LIST(MasqueBin, ListeMasqueBin);
#include <wx/listimpl.cpp>
WX_DEFINE_LIST(ListeMasqueBin)

ListeMasqueBin g_wListeMasqueBin(wxKEY_STRING);

extern int g_NbMasqueBin;
extern MyFrame   *g_Frame;

/******************************************/
/* Constructeur interface masque Bin vide */
/******************************************/

InterfaceMasqueBin::InterfaceMasqueBin ()
{
 
}




/**************************************/
/* Destructeur interface masque Bin   */
/**************************************/

InterfaceMasqueBin::~InterfaceMasqueBin ( void )
{
}

/*******************************************/
/* Initialisation de la liste masque Bin   */
/*******************************************/

void InterfaceMasqueBin::InitInterfaceMasqueBin ( void )
{
g_wMenuMasqueBin = new wxMenu;
}

/**********************************************/
/* Recherche de masque de la liste masque Bin */
/**********************************************/


MasqueBin * InterfaceMasqueBin::ChercherMasqueBin(wxString l_wNomMasque)
{
MasqueBin * l_pMasqueBin;

if (g_wListeMasqueBin.Find(l_wNomMasque)==NULL)
	{
	(void)wxMessageBox("Masque inexistante",
           "Erreur", wxOK);
	 return NULL;
	}

l_pMasqueBin = g_wListeMasqueBin.Find(l_wNomMasque)->GetData();
return l_pMasqueBin;
}

/*******************************************/
/* Ajouter masque dans la liste masque Bin */
/*******************************************/


int InterfaceMasqueBin::AjouterMasqueBin(wxString l_wNomMasque, MasqueBin *
l_pMasqueBin)
{


if (g_wListeMasqueBin.Find(l_wNomMasque) != NULL)
	{
	(void)wxMessageBox("Masque "+l_wNomMasque+" existante",
           "Erreur", wxOK);
	 return(-1);
	}


g_wListeMasqueBin.Append(l_wNomMasque, l_pMasqueBin);
g_NbMasqueBin++;
return(1);
}


/********************************************************/
/* Recherche graphique de masque de la liste masque Bin */
/********************************************************/


MasqueBin * InterfaceMasqueBin::SelectionMasqueBin( void )
{
int l_iNbMasque;

l_iNbMasque = g_wListeMasqueBin.Number();
//l_iNbMasque = g_wListeMasqueDouble.GetCount();
if (l_iNbMasque == 0)
  {
    wxMessageBox ("Il n'y a pas de masque", "Erreur", wxOK);
    return NULL;
  }
  
// Affichage des masques disponibles

wxString l_wxNomMasque[l_iNbMasque];
char * l_zChoix[l_iNbMasque];

//wxNode *node = g_wListeMasqueDouble.First();
wxNode *node = g_wListeMasqueBin.First();
int l_iIndice=0;
while (node)
  {
    
    l_wxNomMasque[l_iIndice] = ((MasqueBin *)node->Data())->ChercherNom();
    l_zChoix[l_iIndice] = (char *)l_wxNomMasque[l_iIndice].GetData();
    l_iIndice++;
    node = node->Next();
  }

wxString l_wxResultat = wxGetSingleChoice(wxString("Masque"), wxString("Nom"), l_iNbMasque, l_wxNomMasque,
  NULL,  -1, -1, true, 200, 200);

// si aucun choix fin

if (l_wxResultat.IsEmpty())
	{
	(void)wxMessageBox("Pas de masque selectionne",
            "Erreur", wxOK);
	 return NULL;
	}

MasqueBin * l_MasqueBin;

l_MasqueBin = g_wListeMasqueBin.Find( l_wxResultat.GetData())->GetData();

return l_MasqueBin;
}
