/////////////////////////////////////////////////////////////////////////////
// Name:        InterfaceImageBin.cpp
// Purpose:     InterfaceImageBin class
// Author:      Alain Bouju
// Modified by:
// Created:     02/02/00
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////

#include "InterfaceImageBin.h"

// Liste Image Bin
WX_DECLARE_LIST(ImageBin, ListeImageBin);
#include <wx/listimpl.cpp>
WX_DEFINE_LIST(ListeImageBin)

ListeImageBin g_wListeImageBin(wxKEY_STRING);

extern InterfaceMasqueBin g_InterfaceMasqueBin;


extern int g_NbImageBin;
extern wxBitmap  *g_Bitmap;
extern MyFrame   *g_Frame;

/*****************************************************/
/* Constructeur interface image gray 256 niveau vide */
/*****************************************************/

InterfaceImageBin::InterfaceImageBin ()
{
 
}

/*************************************/
/* Destructeur interface image Bin   */
/*************************************/

InterfaceImageBin::~InterfaceImageBin ( void )
{
}

/****************************************/
/* Initialisation de la liste image Bin */
/****************************************/

void InterfaceImageBin::InitInterfaceImageBin ( void )
{
//g_wMenuImageBin = new wxMenu;
}

/*******************************************/
/* Recherche d'image de la liste image Bin */
/*******************************************/


ImageBin * InterfaceImageBin::ChercherImageBin(wxString l_wNomImage)
{
ImageBin * l_pImageBin;

if (g_wListeImageBin.Find(l_wNomImage)==NULL)
	{
	(void)wxMessageBox("Image inexistante",
           "Erreur", wxOK);
	 return NULL;
	}

l_pImageBin = g_wListeImageBin.Find(l_wNomImage)->GetData();
return l_pImageBin;
}

/*****************************************/
/* Ajouter image dans la liste image Bin */
/*****************************************/


int InterfaceImageBin::AjouterImageBin(wxString l_wNomImage, ImageBin *
l_pImageBin)
{

if (!( g_NbImageBin < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop d'images ouvertes pour le Menu!", "Erreur", wxOK);
	 return(-1);
	}

// recherche si l'image existe deja

if (g_wListeImageBin.Find(l_wNomImage) != NULL)
	{
	(void)wxMessageBox("Image "+l_wNomImage+" existante", "Erreur", wxOK);
	 return(-1);
	}

g_wListeImageBin.Append(l_wNomImage, l_pImageBin);
g_wMenuImageBin -> Append(3 * BASELISTE + g_NbImageBin, l_wNomImage);
g_NbImageBin++;
return(1);
}


/***************************/
/* Visualisation image Bin */
/***************************/

wxBitmap * InterfaceImageBin::VisualiserBin (ImageBin *l_pImageBin)
{
wxMemoryDC
	l_wMemDC;
long int l_iIndex;
long int l_iX;
long int l_iY;
int l_iCouleur;

/* Definition de la zone de l'image */
long int l_iHauteur = l_pImageBin -> ChercherHauteur();
long int l_iLargeur = l_pImageBin -> ChercherLargeur();


Bin * l_pImage = l_pImageBin -> ChercherImage();
wxBitmap * p_wImage = new wxBitmap(l_iLargeur, l_iHauteur, -1);
l_wMemDC.SelectObject( *p_wImage );
l_wMemDC.Clear();

/* Definition de la couleur */

wxColour l_wCouleur[2];

/* Initialisation pen */

wxPen l_wPen[2];

/* mise en place des couleur */

Gray256 l_iGray;

/* mise en place des couleur */
// 0 blanc 1 bleu
l_wPen[0].SetColour(0, 0, 0);
l_wPen[0].SetWidth(wxDOT);
l_wPen[0].SetStyle(wxSOLID);
l_wPen[1].SetColour(0, 0, 250);
l_wPen[1].SetWidth(wxDOT);
l_wPen[1].SetStyle(wxSOLID);

/* Dessin de l'image */
l_iIndex = 0;

for(long int l_iIndiceY=0; l_iIndiceY < l_iHauteur; l_iIndiceY++)
{
 for(long int l_iIndiceX=0; l_iIndiceX < l_iLargeur; l_iIndiceX++)
	{
	 l_iCouleur = l_pImage[l_iIndex+l_iIndiceX];		 	
	 l_wMemDC.SetPen(l_wPen[l_iCouleur]);
	 l_wMemDC.DrawPoint(l_iIndiceX, l_iIndiceY);		 	
	}
 l_iIndex += l_iLargeur;
}
// Statut texte
g_Frame -> SetStatusText("Image Bin-" + l_pImageBin->ChercherNom());
return (p_wImage);
}

//---------------------------------
// Affiche l'image Bin selectionnee
//---------------------------------

void InterfaceImageBin::OnImageBin(wxCommandEvent& event)
{
int
	l_id;
	
ImageBin
	*l_pImageBin;
		
l_id=event.GetId();

l_pImageBin = g_wListeImageBin.Find(g_wMenuImageBin->GetLabel(l_id))-> GetData();

if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
// Debut Attente
wxBeginBusyCursor();

g_Bitmap = l_pImageBin->VisualiserBin();

// Fin attente
wxEndBusyCursor();

// Mise a jour de l'affichage
(g_Frame->canvas)->Refresh();
return;
}

//----------------------
// Fonction Inverser Bin
//----------------------

void InterfaceImageBin::OnInverserBin()
{
ImageBin
	*l_pImageSourceBin;
int
	l_iStatus;

	
// Lecture Nom Logique de L'image Source
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

l_pImageSourceBin = ChercherImageBin(l_wNomImage);

if (l_pImageSourceBin == 0)
	{
	 return;
	}

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Debut Attente
wxBeginBusyCursor();

// Recherche si l'image Existe de deja
if (g_wListeImageBin.Find(l_wNomImageDestination)!= 0)
	{	
	(void)wxMessageBox("Image Existante",
            "Erreur", wxOK);
	 return;
	}
	
// Creation de l'Image
ImageBin *l_ImageBinDestination = new ImageBin(l_pImageSourceBin);
// Inversion de l'Image
l_ImageBinDestination->Inverse();
// Insertion dans la Liste
l_iStatus = AjouterImageBin(l_wNomImageDestination.GetData(), l_ImageBinDestination);
// Affichage
if (l_iStatus != -1)
	{
	 if (g_Bitmap) //liberation de la memoire
		{
		 delete g_Bitmap;
		}

	 g_Bitmap = l_ImageBinDestination->VisualiserBin();

	 // Mise a jour de l'affichage
	 (g_Frame->canvas)->Refresh();
	}
// Fin attente
wxEndBusyCursor();
return;
}

//----------------------
// Fonction Erosion Bin
//----------------------

void InterfaceImageBin::OnErosionBin()
{
ImageBin
	*l_pImageSourceBin;
int
	l_iStatus;
MasqueBin
	*l_MasqueBin;
	
// Lecture Nom Logique de L'image Source
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

l_pImageSourceBin = ChercherImageBin(l_wNomImage);

if (l_pImageSourceBin == 0)
	{
	 return;
	}

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Debut Attente
wxBeginBusyCursor();

// Recherche si l'image Existe de deja
if (g_wListeImageBin.Find(l_wNomImageDestination)!= 0)
	{	
	(void)wxMessageBox("Image Existante",
            "Erreur", wxOK);
	 return;
	}
	
// Creation de l'Image
ImageBin *l_ImageBinDestination = new ImageBin(l_pImageSourceBin);

// Recuperation du masque bin
wxString l_wNomMasqueBin = wxString("NoyauBin");
l_MasqueBin = g_InterfaceMasqueBin.ChercherMasqueBin(l_wNomMasqueBin);

// Erosion de l'Image
l_ImageBinDestination = l_pImageSourceBin->ErosionBin(l_wNomImageDestination, l_MasqueBin);

// Insertion dans la Liste
l_iStatus = AjouterImageBin(l_wNomImageDestination.GetData(), l_ImageBinDestination);
// Affichage
if (l_iStatus != -1)
	{
	 if (g_Bitmap) //liberation de la memoire
		{
		 delete g_Bitmap;
		}

	 g_Bitmap = l_ImageBinDestination->VisualiserBin();

	 // Mise a jour de l'affichage
	 (g_Frame->canvas)->Refresh();
	}
// Fin attente
wxEndBusyCursor();
return;
}

//------------------------
// Fonction Dilatation Bin
//------------------------

void InterfaceImageBin::OnDilatationBin()
{
ImageBin
	*l_pImageSourceBin;
int
	l_iStatus;
MasqueBin
	*l_MasqueBin;
	
// Lecture Nom Logique de L'image Source
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

l_pImageSourceBin = ChercherImageBin(l_wNomImage);

if (l_pImageSourceBin == 0)
	{
	 return;
	}

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Debut Attente
wxBeginBusyCursor();

// Recherche si l'image Existe de deja
if (g_wListeImageBin.Find(l_wNomImageDestination)!= 0)
	{	
	(void)wxMessageBox("Image Existante",
            "Erreur", wxOK);
	 return;
	}
	
// Creation de l'Image
ImageBin *l_ImageBinDestination = new ImageBin(l_pImageSourceBin);

// Recuperation du masque bin
wxString l_wNomMasqueBin = wxString("NoyauBin");
l_MasqueBin = g_InterfaceMasqueBin.ChercherMasqueBin(l_wNomMasqueBin);

// Dilatation de l'Image
l_ImageBinDestination = l_pImageSourceBin->DilatationBin(l_wNomImageDestination, l_MasqueBin);

// Insertion dans la Liste
l_iStatus = AjouterImageBin(l_wNomImageDestination.GetData(), l_ImageBinDestination);
// Affichage
if (l_iStatus != -1)
	{
	 if (g_Bitmap) //liberation de la memoire
		{
		 delete g_Bitmap;
		}

	 g_Bitmap = l_ImageBinDestination->VisualiserBin();

	 // Mise a jour de l'affichage
	 (g_Frame->canvas)->Refresh();
	}
// Fin attente
wxEndBusyCursor();
return;
}

//-----------------------
// Fonction Ouverture Bin
//-----------------------

void InterfaceImageBin::OnOuvertureBin()
{
ImageBin
	*l_pImageSourceBin;
int
	l_iStatus;
MasqueBin
	*l_MasqueBin;
	
// Lecture Nom Logique de L'image Source
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

l_pImageSourceBin = ChercherImageBin(l_wNomImage);

if (l_pImageSourceBin == 0)
	{
	 return;
	}

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Debut Attente
wxBeginBusyCursor();

// Recherche si l'image Existe de deja
if (g_wListeImageBin.Find(l_wNomImageDestination)!= 0)
	{	
	(void)wxMessageBox("Image Existante",
            "Erreur", wxOK);
	 return;
	}
	

// Recuperation du masque bin
wxString l_wNomMasqueBin = wxString("NoyauBin");
l_MasqueBin = g_InterfaceMasqueBin.ChercherMasqueBin(l_wNomMasqueBin);

// Ouverture de l'Image
ImageBin * l_ImageBinDestination = l_pImageSourceBin->OuvertureBin(l_wNomImageDestination, l_MasqueBin);
// Insertion dans la Liste
l_iStatus = AjouterImageBin(l_wNomImageDestination.GetData(), l_ImageBinDestination);
// Affichage
if (l_iStatus != -1)
	{
	 if (g_Bitmap) //liberation de la memoire
		{
		 delete g_Bitmap;
		}

	 g_Bitmap = l_ImageBinDestination->VisualiserBin();

	 // Mise a jour de l'affichage
	 (g_Frame->canvas)->Refresh();
	}
// Fin attente
wxEndBusyCursor();
return;
}

//-----------------------
// Fonction Fermeture Bin
//-----------------------

void InterfaceImageBin::OnFermetureBin()
{
ImageBin
	*l_pImageSourceBin;
int
	l_iStatus;
MasqueBin
	*l_MasqueBin;
	
// Lecture Nom Logique de L'image Source
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

l_pImageSourceBin = ChercherImageBin(l_wNomImage);

if (l_pImageSourceBin == 0)
	{
	 return;
	}

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Debut Attente
wxBeginBusyCursor();

// Recherche si l'image Existe de deja
if (g_wListeImageBin.Find(l_wNomImageDestination)!= 0)
	{	
	(void)wxMessageBox("Image Existante",
            "Erreur", wxOK);
	 return;
	}
	

// Recuperation du masque bin
wxString l_wNomMasqueBin = wxString("NoyauBin");
l_MasqueBin = g_InterfaceMasqueBin.ChercherMasqueBin(l_wNomMasqueBin);

// Ouverture de l'Image
ImageBin * l_ImageBinDestination = l_pImageSourceBin->FermetureBin(l_wNomImageDestination, l_MasqueBin);
// Insertion dans la Liste
l_iStatus = AjouterImageBin(l_wNomImageDestination.GetData(), l_ImageBinDestination);
// Affichage
if (l_iStatus != -1)
	{
	 if (g_Bitmap) //liberation de la memoire
		{
		 delete g_Bitmap;
		}

	 g_Bitmap = l_ImageBinDestination->VisualiserBin();

	 // Mise a jour de l'affichage
	 (g_Frame->canvas)->Refresh();
	}
// Fin attente
wxEndBusyCursor();
return;
}

//----------------------------------
// Fonction Diviser taille image Bin
//----------------------------------

void InterfaceImageBin::OnDiviserBin()
{
ImageBin 
	*l_pImageSourceBin;
int
	l_iStatus;

// Lecture Nom Logique de L'image Source
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

l_pImageSourceBin = ChercherImageBin(l_wNomImage);

if (l_pImageSourceBin == 0)
	{
	 return;
	}

// Lecture Nom Logique de L'image 
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Debut Attente
wxBeginBusyCursor();

// Diminution de l'Image
ImageBin *l_ImageBinDestination = l_pImageSourceBin->Diviser(l_wNomImageDestination);
// Insertion dans la Liste
l_iStatus = AjouterImageBin(l_wNomImageDestination.GetData(), l_ImageBinDestination);
// Affichage
if (l_iStatus != -1)
	{
	 if (g_Bitmap) //liberation de la memoire
		{
		 delete g_Bitmap;
		}

	 g_Bitmap = l_ImageBinDestination->VisualiserBin();

	 // Mise a jour de l'affichage
	 (g_Frame->canvas)->Refresh();
	}
// Fin attente
wxEndBusyCursor();

return;
}

//------------------------
// Fonction Compte Region
//------------------------

void InterfaceImageBin::OnNombreRegion()
{
ImageBin 
	*l_pImageSourceBin;
int
	l_iStatus;


// Lecture Nom Logique de L'image Source
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image : ", "Nom de l'image", "");

l_pImageSourceBin = ChercherImageBin(l_wNomImage);

if (l_pImageSourceBin == 0)
	{
	 return;
	}

// Debut Attente
wxBeginBusyCursor();

ImageBin *CopyImage = new ImageBin(l_pImageSourceBin);

// A changer quand wxString plus performant
char l_zChaineTemporaire[40];
snprintf(l_zChaineTemporaire,40,"%d",CopyImage->NombreRegion());
// Fin attente
wxEndBusyCursor();
wxString l_wResultat = wxString("Nb Region: ")+ wxString(l_zChaineTemporaire);
(void)wxMessageBox(wxString(l_wResultat), "Valeur", wxOK);
delete CopyImage;
return;
}

/***********************************************/
/* Supprimer image dans la liste image Bin     */
/***********************************************/

void InterfaceImageBin::OnSupprimerBin()
{
int
	l_iNbImage;


// Selection de l'image a supprimer
l_iNbImage=g_wListeImageBin.Number();
if (l_iNbImage == 0)
  {
    wxMessageBox ("Il n'y a pas d'image", "Erreur", wxOK);
    return;
  }
// Affichage des images disponibles

wxString l_wxNomImage[l_iNbImage];
char * l_zChoix[l_iNbImage];

//wxNode *node = g_wListeMasqueDouble.First();
wxNode *node = g_wListeImageBin.First();
int l_iIndice=0;
while (node)
  {
    l_wxNomImage[l_iIndice] = ((ImageBin *)node->Data())->ChercherNom();
    // Destruction du menu
    int l_iItemMenuDestruction = g_wMenuImageBin->FindItem(l_wxNomImage[l_iIndice]);
    g_wMenuImageBin->Delete(l_iItemMenuDestruction);
    l_zChoix[l_iIndice] = (char *)l_wxNomImage[l_iIndice].GetData();
    l_iIndice++;
    node = node->Next();
  }

wxString l_wxResultat = wxGetSingleChoice(wxString("Image"), wxString("Nom"), l_iNbImage, l_wxNomImage,
  NULL,  -1, -1, true, 200, 200);

// si aucun choix fin

if (l_wxResultat.IsEmpty())
	{
	(void)wxMessageBox("Pas d'image selectionnee",
            "Erreur", wxOK);
	 // reconstruction du menu
	 node = g_wListeImageBin.First();
	 l_iIndice=0;
	 while (node)
	  {
	    l_wxNomImage[l_iIndice] = ((ImageBin *)node->Data())->ChercherNom();
	    // Reconstruction du menu
	    g_wMenuImageBin -> Append(3 * BASELISTE + l_iIndice, l_wxNomImage[l_iIndice]);
	    l_iIndice++;
	    node = node->Next();
	  }
	 return;
	}

// recherche de l'image et destructions
ImageBin * l_ImageBin;
l_ImageBin = g_wListeImageBin.Find(l_wxResultat.GetData())->GetData();

// Suppression de la liste des images
if (!g_wListeImageBin.DeleteNode(g_wListeImageBin.Find(l_wxResultat.GetData())))
	{
	(void)wxMessageBox("PB de destruction d'image",
            "Erreur", wxOK);
	 return;
	}
// Reconstruction du Menu

node = g_wListeImageBin.First();
l_iIndice=0;
while (node)
  {
    l_wxNomImage[l_iIndice] = ((ImageBin *)node->Data())->ChercherNom();
    // Reconstruction du menu
    g_wMenuImageBin -> Append(3 * BASELISTE + l_iIndice, l_wxNomImage[l_iIndice]);
    l_iIndice++;
    node = node->Next();
  }
g_NbImageBin--;
return;
}

