/////////////////////////////////////////////////////////////////////////////
// Name:        ImageGray256.h
// Purpose:     ImageGray256 class
// Author:      Alain Bouju
// Modified by:
// Created:     23/10/98
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////

/* Definition de la classe ImageGray256 */
#ifndef IMAGEGRAY256_H__
#define IMAGEGRAY256_H__

#ifdef __GNUG__
#pragma interface
#endif

#include "wx/wx.h"

typedef unsigned char Gray256;

#include "ImagePGM.h"
#include "ImageDouble.h"
#include "ImageBin.h"
#include "MasqueDouble.h"

//#include "wxima.h"

class ImagePGM;

class ImageGray256{
	wxString nomLogique;
protected :
	int hauteur;
	int largeur;
	Gray256 *image;

public :
//	Constructeur
	ImageGray256 (void);
//	ImageGray256 (ImageBin *source);
//	ImageGray256 (wxImage *ima, char *leurre);
	ImageGray256 (ImageGray256 *source);
	ImageGray256 (wxString p_wNomLogique, ImagePGM *source);
	ImageGray256 (wxString p_wNomLogique, ImageDouble *p_Source, int p_Min, int p_Max);
	
	~ImageGray256 (void);

//	Optention d'information sur objet
	int ChercherHauteur ();
	int ChercherLargeur ();
	wxString ChercherNom ();
	Gray256 *ChercherImage ();

//	Methodes

	wxBitmap * Visualiser256 ();
	int Inverse ();

//	ImageGray256 *Masque (ImageBin *, char *);
	ImageGray256 *Diviser (wxString p_wNomDestination);
	ImageDouble * Convoluer(wxString p_wNomDestination, MasqueDouble * p_MasqueConvolution);

	//Pour la convolution
	ImageGray256 *SaisieConvolution(char *NomDestination);
	ImageGray256 *Gradiant(char *NomDestination);
	ImageGray256 *Laplacien (char *NomDestination);
	ImageGray256 *Convolution(char *NomDestination,double *Matrice,int TailleMatrice,int Mode=-1);
	ImageGray256 *Convolution(double *Filtre,int TailleFiltreH, int TailleFiltreV,char *NomDestination);
	ImageGray256 *Moyennage(char *NomDestination);
	ImageGray256 *Gaussien(char *NomDestination);

	//Pour l'egalisation d'histogramme
	
	ImageGray256 *EgaliserHistogramme(char *NomDestination);
	ImageGray256 *DetectionContour (char *, int);


};

#endif
