/////////////////////////////////////////////////////////////////////////////
// Name:        ImageBin.cpp
// Purpose:     ImageBin class
// Author:      Alain Bouju
// Modified by:
// Created:     21/04/99
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////

#include "ImageBin.h"

/**************************************/
/* Constructeur image Bin niveau vide */
/**************************************/

ImageBin::ImageBin ()
{
	largeur = 0;
	hauteur = 0;
	nomLogique = wxString();
	image = 0;
}

/***************************/
/* Constructeur image bin  */
/***************************/

ImageBin::ImageBin (ImageBin *source)
{
	hauteur = source->ChercherHauteur();
	largeur = source->ChercherLargeur();

	nomLogique = wxString(source->ChercherNom());
	// Calcul de la taille de l'image
	long int l_iTaille = hauteur * largeur;
	// Creation du tableau contenant l'image
	image = new Bin [l_iTaille];

	Bin *temp = source->ChercherImage();
	// recopie de l'image - A refaire erreur
	for (int i=0; i<(hauteur*largeur); i++)
		image [i] = temp [i];
}

/***************************/
/* Constructeur image bin  */
/***************************/

ImageBin::ImageBin (ImageGray256 *p_source, int p_iSeuil, wxString p_wNomLogique)
{
long int l_iIndex;

	hauteur = p_source->ChercherHauteur();
	largeur = p_source->ChercherLargeur();

	nomLogique = wxString(p_wNomLogique.GetData());
	// Calcul de la taille de l'image
	long int l_iTaille = hauteur * largeur;
	// Creation du tableau contenant l'image
	image = new Bin [l_iTaille];

	Gray256 *temp = p_source->ChercherImage();
	// recopie de l'image

	long int l_iHauteur = hauteur;
	long int l_iLargeur = largeur;
	l_iIndex = 0; 
	for(long int l_iIndiceY=0; l_iIndiceY < l_iHauteur; l_iIndiceY++)
	{
	for(long int l_iIndiceX=0; l_iIndiceX < l_iLargeur; l_iIndiceX++)
		{
		 if (temp [l_iIndex+l_iIndiceX] > p_iSeuil)
		 	{
			 image [l_iIndex+l_iIndiceX] = 1;
		 	}
		 else
		 	{
			 image [l_iIndex+l_iIndiceX] = 0;
		 	}	 	
		}
	l_iIndex += l_iLargeur;
	}
		
}

/***************************/
/* Constructeur image bin  */
/***************************/

ImageBin::ImageBin (ImageDouble *p_source, Double p_dSeuil, wxString p_wNomLogique)
{
long int l_iIndex;

	hauteur = p_source->ChercherHauteur();
	largeur = p_source->ChercherLargeur();

	nomLogique = p_wNomLogique;
	// Calcul de la taille de l'image
	long int l_iTaille = hauteur * largeur;
	// Creation du tableau contenant l'image
	image = new Bin [l_iTaille];

	Double *temp = p_source->ChercherImage();
	// recopie de l'image

	long int l_iHauteur = hauteur;
	long int l_iLargeur = largeur;
	l_iIndex = 0; 
	for(long int l_iIndiceY=0; l_iIndiceY < l_iHauteur; l_iIndiceY++)
	{
	for(long int l_iIndiceX=0; l_iIndiceX < l_iLargeur; l_iIndiceX++)
		{
		 if (temp [l_iIndex+l_iIndiceX] > p_dSeuil)
		 	{
			 image [l_iIndex+l_iIndiceX] = 1;
		 	}
		 else
		 	{
			 image [l_iIndex+l_iIndiceX] = 0;
		 	}	 	
		}
	l_iIndex += l_iLargeur;
	}
		
}

/************************************************/
/* Constructeur image Bin a partir d'une Taille */
/************************************************/

ImageBin::ImageBin (wxString p_wNomLogique, int p_iLargeur, int p_iHauteur)
{
	
	largeur = p_iLargeur;
	hauteur = p_iHauteur;	
	nomLogique = p_wNomLogique;
	long int l_iTaille = p_iHauteur * p_iLargeur;
	image = new Bin [l_iTaille];

}


/**************************************/
/* Recherche de la Hauteur de l'Image */
/**************************************/

int ImageBin::ChercherHauteur ()
{
	return hauteur;
}

/**************************************/
/* Recherche de la Largeur de l'Image */
/**************************************/

int ImageBin::ChercherLargeur ()
{
	return largeur;
}

/**********************************/
/* Recherche de la Nom de l'Image */
/**********************************/

wxString ImageBin::ChercherNom ()
{
	return nomLogique;
}

/***********************************/
/* Recherche du contenu de l'image */
/***********************************/

Bin * ImageBin::ChercherImage ()
{
	return image;
}



/***************************/
/* Destructeur image Bin   */
/***************************/

ImageBin::~ImageBin ( void )
{
	if (image!=0)
		{
		 delete [] image;
		}
}

/*****************************/
/* Visualisation image bin   */
/*****************************/
wxBitmap * ImageBin::VisualiserBin ()
{
wxMemoryDC
	l_wMemDC;
long int l_iIndex;
long int l_iX;
long int l_iY;


/* Definition de la zone de l'image */

wxBitmap * p_wImage = new wxBitmap(largeur, hauteur, -1);
l_wMemDC.SelectObject( *p_wImage );
l_wMemDC.Clear();

/* Definition de la couleur */

wxColour l_wCouleur[2];

/* Initialisation pen */

wxPen l_wPen[2];

/* mise en place des couleur */

// 0 blanc 1 bleu
l_wPen[0].SetColour(0, 0, 0);
l_wPen[0].SetWidth(wxDOT);
l_wPen[0].SetStyle(wxSOLID);
l_wPen[1].SetColour(0, 0, 250);
l_wPen[1].SetWidth(wxDOT);
l_wPen[1].SetStyle(wxSOLID);

/* Dessin de l'image */
l_iIndex = 0;
int l_iCouleur;
long int l_iHauteur = hauteur;
long int l_iLargeur = largeur;

for(long int l_iIndiceY=0; l_iIndiceY < l_iHauteur; l_iIndiceY++)
 {
 for(long int l_iIndiceX=0; l_iIndiceX < l_iLargeur; l_iIndiceX++)
	{
	 l_iCouleur = image[l_iIndex+l_iIndiceX];
	 l_wMemDC.SetPen(l_wPen[l_iCouleur]);
	 l_wMemDC.DrawPoint(l_iIndiceX, l_iIndiceY);		 	
	}
 l_iIndex += l_iLargeur;
 }
return (p_wImage);
}

/**********************/
/* Inverse image bin  */
/**********************/

int ImageBin::Inverse ()
{
for (int i=0; i<(largeur*hauteur);  i++)
	{
	 image [i] = 1 - image [i];
	}
return(1);
}


/*****************************************************/
/* Division de la taille de l'image par 2            */
/*****************************************************/
/* A Faire */
ImageBin *ImageBin::Diviser (wxString p_wNomDestination)
{
ImageBin *PetiteImage = new ImageBin;

long int l_iLarg;
long int l_iHaut;
int l_iLImpaire;
int l_iHImpaire;

if (largeur % 2)
	{
	 l_iLarg = largeur - 1;
	 PetiteImage->largeur = l_iLarg / 2 + 1;
	 l_iLImpaire = 1;
	}
else
	{
	 l_iLarg = largeur;
	 PetiteImage->largeur = l_iLarg / 2;
	}

if (hauteur % 2)
	{
	 l_iHaut = hauteur - 1;
	 PetiteImage->hauteur = l_iHaut / 2 + 1;
	 l_iHImpaire = 1;
	}
else
	{
	 l_iHaut = hauteur;
	 PetiteImage->hauteur = l_iHaut / 2;
	}

PetiteImage->nomLogique = p_wNomDestination;
	
long int l_iTaille = largeur * hauteur;
long int l_iTaillePetite = PetiteImage->largeur * PetiteImage->hauteur;

PetiteImage->image = new Bin [l_iTaillePetite];

	
int l_iSomme = 0;
int l_iLargEff = PetiteImage->largeur;
	
for (long int i=0; i<l_iHaut; i+=2)
	{
	 for (long int j=0; j<l_iLarg; j+=2)
		{
		 l_iSomme = 0;
		 l_iSomme += image [i*l_iLarg + j];
		 l_iSomme += image [i*l_iLarg + j + 1];
		 l_iSomme += image [(i+1)*l_iLarg + j];
		 l_iSomme += image [(i+1)*l_iLarg + j + 1];

		 PetiteImage->image [(i/2)*l_iLargEff + (j/2)] = l_iSomme / 4;
		}
	}

return PetiteImage;
}

/*****************************************************/
/* Erosion d'une image binaire                       */
/*****************************************************/
ImageBin * ImageBin::ErosionBin(wxString p_wNomDestination, MasqueBin *p_pMasqueBin)
{
//Allocation memoire de l'objet destination
ImageBin *l_pDestination = new ImageBin(p_wNomDestination,largeur,hauteur);

int   	      	l_iIndice;
int                 i, j, x, y;
Bin       el;
Bin       pixel;
Bin 
	* l_Tableau;
Bin 
	* l_TableauDestination;

l_Tableau = ChercherImage();

// Initialisation de l'image destination
l_TableauDestination = l_pDestination -> ChercherImage();

for (l_iIndice = 0; l_iIndice < largeur * hauteur; l_iIndice++)
	l_TableauDestination[l_iIndice] = 0;
	
// Calcul de la convolution
// parcour par i et j de l'image
for (i = 0 + p_pMasqueBin -> x0;
	i < largeur - p_pMasqueBin->largeur + p_pMasqueBin->x0 + 1;
	i++)
	for (j = 0 + p_pMasqueBin->y0;
	     j < hauteur - p_pMasqueBin->hauteur + p_pMasqueBin->y0 + 1;
	     j++)
	    {
	     el = 1;
	     // parcour par x y du masque
	     for (x = 0; x < p_pMasqueBin->largeur; x++)
		for (y = 0; y < p_pMasqueBin->hauteur; y++)
		{
		    if (el == 1)
		    {
		     if (p_pMasqueBin->tableau[y*(p_pMasqueBin->largeur)+ x] == 1)
		     {
		     if (l_Tableau[(j+y)*largeur+i+x] == 0)
		     	{
		      	 el=0;
		      	}
		     }
		    }
		}
	     l_TableauDestination [(j + p_pMasqueBin->y0)*largeur + (i + p_pMasqueBin -> x0)] = el;
	    }
return (l_pDestination);
}

/*****************************************************/
/* Dilatation d'une image binaire                    */
/*****************************************************/
ImageBin * ImageBin::DilatationBin(wxString p_wNomDestination, MasqueBin *p_pMasqueBin)
{
//Allocation memoire de l'objet destination
ImageBin *l_pDestination = new ImageBin(p_wNomDestination,largeur,hauteur);

int   	      	l_iIndice;
int                 i, j, x, y;
Bin       el;
Bin       pixel;
Bin 
	* l_Tableau;
Bin 
	* l_TableauDestination;

l_Tableau = ChercherImage();

// Initialisation de l'image destination
l_TableauDestination = l_pDestination -> ChercherImage();

for (l_iIndice = 0; l_iIndice < largeur * hauteur; l_iIndice++)
	l_TableauDestination[l_iIndice] = 0;
	
// Calcul de la convolution
// parcour par i et j de l'image
for (i = 0 + p_pMasqueBin -> x0;
	i < largeur - p_pMasqueBin->largeur + p_pMasqueBin->x0 + 1;
	i++)
	for (j = 0 + p_pMasqueBin->y0;
	     j < hauteur - p_pMasqueBin->hauteur + p_pMasqueBin->y0 + 1;
	     j++)
	    {
	     el = 0;
	     // parcour par x y du masque
	     for (x = 0; x < p_pMasqueBin->largeur; x++)
		for (y = 0; y < p_pMasqueBin->hauteur; y++)
		{
		    if (el == 0)
		    {
		     if (p_pMasqueBin->tableau[y*(p_pMasqueBin->largeur)+ x] == 1)
		     {
		     if (l_Tableau[(j+y)*largeur+i+x] == 1)
		     	{
		      	 el=1;
		      	}
		     }
		    }
		}
	     l_TableauDestination [(j + p_pMasqueBin->y0)*largeur + (i + p_pMasqueBin -> x0)] = el;
	    }
return (l_pDestination);
}

/*****************************************************/
/* Ouverture d'une image binaire                     */
/*****************************************************/
ImageBin * ImageBin::OuvertureBin(wxString p_wNomDestination, MasqueBin *p_pMasqueBin)
{
// 1 Erosion

wxString l_NomTemp = wxString("Tmp");
ImageBin *l_ImageBinErosion = this->ErosionBin(l_NomTemp, p_pMasqueBin);

// 2 DIlatation
ImageBin *l_pDestination = l_ImageBinErosion->DilatationBin(p_wNomDestination, p_pMasqueBin);

delete l_ImageBinErosion;
return (l_pDestination);
}

/*****************************************************/
/* Fermeture d'une image binaire                     */
/*****************************************************/
ImageBin * ImageBin::FermetureBin(wxString p_wNomDestination, MasqueBin *p_pMasqueBin)
{
// 1 Dilatation

wxString l_NomTemp = wxString("Tmp");
ImageBin *l_ImageBinDilatation = this->DilatationBin(l_NomTemp, p_pMasqueBin);

// 2 Erosion
ImageBin *l_pDestination = l_ImageBinDilatation->ErosionBin(p_wNomDestination, p_pMasqueBin);

delete l_ImageBinDilatation;
return (l_pDestination);
}
/***********************************/
/* Coloriage d'un Objet de l'Image */
/***********************************/
int ImageBin::Coloriage (int x, int y)
{
	static int compteur =0;

	
	if (image [y*largeur + x] == 0)
	{
		return 0;
	}
	else
	{
		compteur++;
		image [y*largeur + x] = 0;

		if ((compteur / largeur) % 2)
		{
			if (x+1 < largeur)
				this->Coloriage (x+1, y);

			if (x-1 >= 0)
				this->Coloriage (x-1, y);

			if (y+1 < hauteur)
				this->Coloriage (x, y+1);

			if (y-1 >= 0)
				this->Coloriage (x, y-1);
		}
		else
		{
			if (y+1 < hauteur)
				this->Coloriage (x, y+1);

			if (y-1 >= 0)
				this->Coloriage (x, y-1);
			
			if (x+1 < largeur)
				this->Coloriage (x+1, y);

			if (x-1 >= 0)
				this->Coloriage (x-1, y);
		}

		if ((x-1 >= 0) && (y-1 >= 0))
		{
			this->Coloriage (x-1, y-1);
		}

		if ((x+1 > largeur) && (y-1 >= 0))
		{
			this->Coloriage (x+1, y-1);
		}

		if ((x+1 > largeur) && (y+1 > hauteur))
		{
			this->Coloriage (x+1, y+1);
		}

		if ((x-1 >= 0) && (y+1 > hauteur))
		{
			this->Coloriage (x-1, y+1);
		}
		return compteur;
	}
}

/***********************************/
/* Comptage du Nombre de Region    */
/***********************************/
int ImageBin::NombreRegion(void)
{
int
 l_iNombreRegion=0;

for (long int i=0; i<hauteur; i++)
	{
	 for (long int j=0; j<largeur; j++)
		{
		 if (image [i*largeur + j] != 0)
			{
			 this->Coloriage(j,i);
			 l_iNombreRegion++;
			}
		}
	}
 return(l_iNombreRegion);

}
