/////////////////////////////////////////////////////////////////////////////
// Name:        Interface.cpp
// Purpose:     Demos d'Interface traitement d'images
// Author:      Alain Bouju
// Modified by:
// Created:     15/10/98
// RCS-ID:      $ $
// Copyright:   
// Licence:   	
/////////////////////////////////////////////////////////////////////////////

#include "define.h"

#ifdef __GNUG__
#pragma implementation "Interface.h"
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifdef __WXMSW__
#include <wx/pnghand.h>
#endif

#include "Interface.h"

#ifdef USE_XPM
    #include "tai.xpm"
#endif

// Frenetre principale
MyFrame   *g_Frame = 0;//(MyFrame *) NULL
// Image principale
wxBitmap  *g_Bitmap = (wxBitmap *) NULL;

// Nb images
// Attention gestion des evenements
int g_NbImage256 = 0;
int g_NbImageBin = 0;
int g_NbImageDouble = 0;
int g_NbMasqueDouble = 0;
int g_NbMasqueBin = 0;
// Type de l'Image affichee dans le canvas
int g_iTypeImageAffiche = 0;

// Liste Image Bin
InterfaceImageBin g_InterfaceImageBin;


// Liste Image Gray
InterfaceImageGray256 g_InterfaceImageGray256;
wxMenu *g_wMenuImage256; 


// Liste Image Double
InterfaceImageDouble g_InterfaceImageDouble;
wxMenu *g_wMenuImageDouble;


// Liste Masque Double
InterfaceMasqueDouble g_InterfaceMasqueDouble;

// Liste Masque Bin
InterfaceMasqueBin g_InterfaceMasqueBin;

// Indique qu'il peut y avoir plusieurs fenetres

//---------------------------------------
// Creation d'un nouvel objet application
//---------------------------------------

IMPLEMENT_APP(MyApp)

//--------------------------------------
// Definition d'une nouvelle application
//--------------------------------------

MyApp::MyApp()
{
}

//--------------------------------------
// Equivalent du main
//--------------------------------------

bool MyApp::OnInit(void)
{
  int l_iTest;

  // Attention pas de Handler avec GTK
  //wxBitmap::AddHandler(new wxPGMFileHandler);

  // Creation de la fenetre principale
  // Create the main frame window


  wxString l_wNomFrame = wxString("TAI ") + wxString(LVERSION) + wxString("-Traitements et analyses  d'images");
  g_Frame = new MyFrame((wxFrame *) NULL, l_wNomFrame, wxPoint(0, 0), wxSize(600, 540));

  // Creation d'une icone
  g_Frame->SetIcon( wxICON(tai) );
  // Creation d'une ligne de status
  // Give it a status line
  g_Frame->CreateStatusBar(1);

  // Barre de Menu
  // Make a menubar
  // Specifique ImageGray 256
  g_InterfaceImageGray256.InitInterfaceImageGray256();
  // Specifique ImageBin
  g_InterfaceImageBin.InitInterfaceImageBin();
  // Specifique ImageDouble
  g_InterfaceImageDouble.InitInterfaceImageDouble();
  
  wxMenu *l_wMenuFichier = new wxMenu;
  wxMenu *l_wMenuOperation256 = new wxMenu;
  wxMenu *l_wMenuOperationBin = new wxMenu;
  wxMenu *l_wMenuOperationDouble = new wxMenu;
  wxMenu *l_wMenuAide = new wxMenu;

  wxMenu *g_wMenuImageBin = new wxMenu;
  g_InterfaceImageBin.g_wMenuImageBin = g_wMenuImageBin;
  // Menu Fichier
  l_wMenuFichier -> Append(TAI_OUVRIR_FILE_256, "&Ouvrir-PGM", "Ouverture et chargement d'un fichier PGM");
  l_wMenuFichier -> Append(TAI_SAVE_FILE_256, "&Enregistrer-PGM", "Sauvegarde de l'image au format PGM");
  l_wMenuFichier -> Append(TAI_OUVRIR_MASQUE_DOUBLE, "&Masque", "Chargement d'un masque de convolution");
  l_wMenuFichier -> Append(TAI_QUIT, "F&ermer", "Fin de l'application");
  
  // Menu Operation 256
  l_wMenuOperation256 ->Append(TAI_INVERSER_256, "&Inverser", "Inversion de l'image");
  l_wMenuOperation256 ->Append(TAI_DIVISER_256, "&Diviser", "Division de la taille de l'image");
  l_wMenuOperation256 ->Append(TAI_SEUILLER_256, "&Seuiller", "Seuillage de l'image pour obtenir une image binaire");
  l_wMenuOperation256 ->Append(TAI_CONVOLUER_256, "&Convoluer", "Convolution de l'image pour obtenir une image double");

  // Menu Operation Bin
  l_wMenuOperationBin ->Append(TAI_INVERSER_BIN, "&Inverser", "Inversion de l'image binaire");
l_wMenuOperationBin ->Append(TAI_EROSION_BIN, "&Erosion", "Erosion de l'image binaire");
l_wMenuOperationBin ->Append(TAI_DILATATION_BIN, "&Dilatation", "Dilatation de l'image binaire");

  // Menu operation Double
  l_wMenuOperationDouble ->Append(TAI_CONVERTIR_IMAGE_GRAY, "&Convertir 256", "Conversion de l'image en 256 gris");
  l_wMenuOperationDouble ->Append(TAI_CONVERTIR_IMAGE_GRAY_MIN_MAX, "&Convertir 256 Min-Max",
  "Conversion de l'image en 256 gris entre niveau Min et Max");
  l_wMenuOperationDouble ->Append(TAI_AFFICHER_MIN_MAX, "&Afficher Min-Max",
  "Affiche la valeur Max et Min de l'image");
  l_wMenuOperationDouble ->Append(TAI_SEUILLER_DOUBLE, "&Seuiller", "Seuillage de l'image pour obtenir une image binaire");
  l_wMenuOperationDouble ->Append(TAI_CONVOLUER_DOUBLE, "&Convoluer",
  "Convolution de l'image");
  
  // Menu Aide
  l_wMenuAide -> Append(TAI_ABOUT, "&Aide", "Information");
  l_wMenuAide -> Append(TAI_TEST, "&Test", "Programme de Test");

  // Bar de Menu de l'application
  wxMenuBar *l_wMenuBar = new wxMenuBar;

  l_wMenuBar -> Append(l_wMenuFichier, _("&Fichier"));
  l_wMenuBar -> Append(g_InterfaceImageGray256.g_wMenuImage256, "&Image-256");
  l_wMenuBar -> Append(g_InterfaceImageBin.g_wMenuImageBin, "&Image-Bin");
  l_wMenuBar -> Append(g_InterfaceImageDouble.g_wMenuImageDouble, "&Image-Double");
  l_wMenuBar -> Append(l_wMenuOperation256, "&Op-256");
  l_wMenuBar -> Append(l_wMenuOperationBin, "&Op-Bin");
  l_wMenuBar -> Append(l_wMenuOperationDouble, "&Op-Double");
    
  l_wMenuBar -> Append(l_wMenuAide, "&Aide");

  // Association du menu bar avec la Frame
  // Associate the menu bar with the frame
  g_Frame->SetMenuBar(l_wMenuBar);

  // Creation d'un canvas pour les images
  MyCanvas *canvas = new MyCanvas(g_Frame, wxPoint(0, 0), wxSize(512, 512));

  // Give it scrollbars: the virtual canvas is 20 * 50 = 1000 pixels in each direction
  // Avec Scrollbar probleme de rafraichissement
  canvas->SetScrollbars(20, 20, 50, 50, 0, 0);
  
  g_Frame -> canvas = canvas;

  g_Frame -> Show(TRUE);

  g_Frame -> SetStatusText("");
  
  //////////////////
  // Initialisation
  //////////////////
  // Chargement Laplacien
  //////////////////
  if (!( g_NbMasqueDouble < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop de Masque", "Erreur", wxOK);
	 return FALSE;
	}
	
  // Chargement d'un fichier
  // Lecture Nom Logique du Masque
  wxString l_wRacine = wxString(PREFIX);
  wxString l_wNomMasqueLaplacien = wxString("Laplacien");
  wxString l_wCheminMasqueLaplacien = l_wRacine + wxString("/share/masque/laplacien.mf");
  
  // Creation du Filtre
  MasqueDouble * l_MasqueDoubleLaplacien = new MasqueDouble();
  l_iTest = l_MasqueDoubleLaplacien -> LectureFichier(l_wCheminMasqueLaplacien,
  l_wNomMasqueLaplacien);
  
  if (l_iTest != 1)
    {
      (void)wxMessageBox("Erreur a l'ouverture",
            "Erreur", wxOK);
      return FALSE;
    }
  g_InterfaceMasqueDouble.AjouterMasqueDouble(l_wNomMasqueLaplacien,l_MasqueDoubleLaplacien);
  
  g_NbMasqueDouble++;
  //////////////////
  // Chargement Moyen
  //////////////////
  if (!( g_NbMasqueDouble < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop de Masque", "Erreur", wxOK);
	 return FALSE;
	}
	
  // Chargement d'un fichier
  // Lecture Nom Logique du Masque
  wxString l_wNomMasqueMoyen = wxString("Moyen3x3");
  wxString l_wCheminMasqueMoyen = l_wRacine + wxString("/share/masque/moyen3x3.mf");
  

  // Creation du Filtre
  MasqueDouble * l_MasqueDoubleMoyen = new MasqueDouble();
  l_iTest = l_MasqueDoubleMoyen -> LectureFichier(l_wCheminMasqueMoyen, l_wNomMasqueMoyen);
  
  if (l_iTest != 1)
    {
      (void)wxMessageBox("Erreur a l'ouverture",
            "Erreur", wxOK);
      return FALSE;
    }
  
g_InterfaceMasqueDouble.AjouterMasqueDouble(l_wNomMasqueMoyen, l_MasqueDoubleMoyen);
  g_NbMasqueDouble++;

  // Chargement d'un fichier masque bin
  // Lecture Nom Logique du Masque bin
  wxString l_wNomMasqueBin = wxString("NoyauBin");
  wxString l_wCheminMasqueBin = l_wRacine + wxString("/share/masque/noyau.mb");
  

  // Creation du Masque
  MasqueBin * l_MasqueBin = new MasqueBin();
  l_iTest = l_MasqueBin -> LectureFichier(l_wCheminMasqueBin, l_wNomMasqueBin);
  
  if (l_iTest != 1)
    {
      (void)wxMessageBox("Erreur a l'ouverture",
            "Erreur", wxOK);
      return FALSE;
    }
  
g_InterfaceMasqueBin.AjouterMasqueBin(l_wNomMasqueBin, l_MasqueBin);
  g_NbMasqueBin++;
  return TRUE;
}

BEGIN_EVENT_TABLE(MyFrame, wxFrame)
// Menu Fichier
    EVT_MENU(TAI_OUVRIR_FILE_256,    	MyFrame::OuvrirFile256)
    EVT_MENU(TAI_SAVE_FILE_256, 	MyFrame::OnSaveFile256)
    EVT_MENU(TAI_OUVRIR_MASQUE_DOUBLE, 	MyFrame::OnOuvrirMasqueDouble)
    EVT_MENU(TAI_QUIT,      		MyFrame::Quitter)

// Menu image-256    
    EVT_MENU(2*BASELISTE,   MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+1, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+2, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+3, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+4, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+5, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+6, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+7, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+8, MyFrame::OnImage256)
    EVT_MENU(2*BASELISTE+9, MyFrame::OnImage256)
    
// Menu image-Bin    
    EVT_MENU(3*BASELISTE,   MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+1, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+2, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+3, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+4, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+5, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+6, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+7, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+8, MyFrame::OnImageBin)
    EVT_MENU(3*BASELISTE+9, MyFrame::OnImageBin)

// Menu image-Double    
    EVT_MENU(4*BASELISTE,   MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+1, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+2, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+3, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+4, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+5, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+6, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+7, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+8, MyFrame::OnImageDouble)
    EVT_MENU(4*BASELISTE+9, MyFrame::OnImageDouble)
    
// Menu operation-256
    EVT_MENU(TAI_INVERSER_256,   MyFrame::OnInverser256)
    EVT_MENU(TAI_DIVISER_256,   MyFrame::OnDiviser256)
    EVT_MENU(TAI_SEUILLER_256,   MyFrame::OnSeuiller256)
    EVT_MENU(TAI_CONVOLUER_256,   MyFrame::OnConvoluer256)
    
// Menu operation-Bin
    EVT_MENU(TAI_INVERSER_BIN,   MyFrame::OnInverserBin)
    EVT_MENU(TAI_EROSION_BIN,   MyFrame::OnErosionBin)
    EVT_MENU(TAI_DILATATION_BIN,   MyFrame::OnDilatationBin)   

// Menu Operation Double
    EVT_MENU(TAI_CONVERTIR_IMAGE_GRAY,   MyFrame::OnConvertirImageGray)
    EVT_MENU(TAI_CONVERTIR_IMAGE_GRAY_MIN_MAX,   MyFrame::OnConvertirImageGrayMinMax)
    EVT_MENU(TAI_AFFICHER_MIN_MAX,   MyFrame::OnImageDoubleAfficherMinMax)
    EVT_MENU(TAI_CONVOLUER_DOUBLE,   MyFrame::OnConvoluerImageDouble)
    EVT_MENU(TAI_SEUILLER_DOUBLE,   MyFrame::OnSeuillerDouble)

// Menu aide
    EVT_MENU(TAI_ABOUT,     MyFrame::OnAbout)
    EVT_MENU(TAI_TEST,     MyFrame::OnTest)
END_EVENT_TABLE()


//-----------------------
// Definition d'une frame
//-----------------------
// Define my frame constructor
MyFrame::MyFrame(wxFrame *frame, const wxString& title, const wxPoint& pos, const wxSize& size):
  wxFrame(g_Frame, -1, title, pos, size)
{
  canvas = (MyCanvas *) NULL;
}

//---------------------------
// Fermeture de l'application
//---------------------------

void MyFrame::Quitter(wxCommandEvent& WXUNUSED(event))
{
    Close(TRUE);
}

//--------------------
// Page d'information
//--------------------

void MyFrame::OnAbout(wxCommandEvent& WXUNUSED(event))
{
    wxString l_wNomAbout = wxString("TAI V-") + wxString(LVERSION) + wxString("\n Alain Bouju - 1998 \n collaboration Andrei Doncescu");
    wxString l_wNomConf = wxString("TAI Version") + wxString(LVERSION);
    (void)wxMessageBox(l_wNomAbout, l_wNomConf, wxOK);
}

//----------------------------
// Sauvegarde d'un fichier pgm
//----------------------------

void MyFrame::OnSaveFile256(wxCommandEvent& WXUNUSED(event))
{
ImageGray256
	*l_pImageGray256=NULL;
//Selection Image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image a sauver: ", "Nom de l'image", "");

l_pImageGray256 = g_InterfaceImageGray256.ChercherImageGray256(l_wNomImage);

wxString l_wNomFichier = wxFileSelector( "Save Image", (const char *)NULL, (const char *)NULL, 
                            "pgm", "pgm files (*.pgm)|*.pgm" );

if (l_wNomFichier.IsEmpty())
  	{
	 return;
	}
	
ImagePGM *l_ImagePGM = new ImagePGM(l_pImageGray256);

l_ImagePGM->SauveFichier(l_wNomFichier);

return;
}

// ---------------------------------------
// Ouverture et affichage d'une image PGM
// ---------------------------------------

void MyFrame::OuvrirFile256(wxCommandEvent& WXUNUSED(event))
{
 g_InterfaceImageGray256.OuvrirFile256();
 return;
}

BEGIN_EVENT_TABLE(MyCanvas, wxScrolledWindow)
    EVT_LEFT_DCLICK(MyCanvas::OnMouseLeft)
    EVT_PAINT(MyCanvas::OnPaint)
END_EVENT_TABLE()

// Define a constructor for my canvas
MyCanvas::MyCanvas(wxWindow *parent, const wxPoint& pos, const wxSize& size):
 wxScrolledWindow(parent, -1, pos, size)
{
}

MyCanvas::~MyCanvas(void)
{
}

// Define the repainting behaviour
void MyCanvas::OnPaint(wxPaintEvent& WXUNUSED(event))
{
  wxPaintDC dc(this);
  dc.SetPen(* wxRED_PEN);
  
// Creation d'une image memoire de l'image
  if ( g_Bitmap && g_Bitmap->Ok() )
  {
    wxMemoryDC memDC;
    
    if ( g_Bitmap->GetColourMap() )
    {
        memDC.SetPalette(*g_Bitmap->GetPalette());
        dc.SetPalette(*g_Bitmap->GetPalette());
    }
    
    memDC.SelectObject(*g_Bitmap);

    PrepareDC(dc);
    dc.Blit(0,0,g_Bitmap->GetWidth(), g_Bitmap->GetHeight(), & memDC, 0, 0, wxCOPY, FALSE);

    OnDraw(dc);
    memDC.SelectObject(wxNullBitmap);
  }
}

void MyCanvas::OnMouseLeft(wxMouseEvent& event)
{
wxClientDC dc(this);
PrepareDC(dc);
wxPoint pos = event.GetPosition();
long x = dc.DeviceToLogicalX( pos.x );
long y = dc.DeviceToLogicalY( pos.y );
wxString str;
str.Printf( "position: %d,%d", (int)x, (int)y );
g_Frame -> SetStatusText(str);
}

// ------------------------------------------
// Define the behaviour for the frame closing
// - must delete all frames except for the main one.
// -------------------------------------------------
bool MyFrame::OnClose(void)
{
  Show(FALSE);

  return TRUE;
}

//--------------------------------------
// Affiche l'image gray 256 selectionnee
//--------------------------------------

void MyFrame::OnImage256(wxCommandEvent& event)
{
g_InterfaceImageGray256.OnImage256(event);
return;
}

//----------------------------
// Fonction Inverser image 256
//----------------------------

void MyFrame::OnInverser256(wxCommandEvent& WXUNUSED(event))
{
g_InterfaceImageGray256.OnInverser256();
return;
}

//----------------------------------
// Fonction Diviser taille image 256
//----------------------------------

void MyFrame::OnDiviser256(wxCommandEvent& WXUNUSED(event))
{
g_InterfaceImageGray256.OnDiviser256();
return;
}

//----------------------------------
// Fonction Seuillage image 256
//----------------------------------

void MyFrame::OnSeuiller256(wxCommandEvent& WXUNUSED(event))
{
ImageGray256
	*l_pImageSourceGray256;
	
// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

l_pImageSourceGray256 = g_InterfaceImageGray256.ChercherImageGray256(l_wNomImage);

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Lecture Valeur du Seuil
wxString l_wValeurSeuil = wxGetTextFromUser("Entrez La valeur de seuil: ", "Seuil", "");
int l_iValeurSeuil = atoi(l_wValeurSeuil.GetData());
// Mise entre les bornes du seuil
if (l_iValeurSeuil < 0)
	{
	 l_iValeurSeuil = 0;
	}
if (l_iValeurSeuil > 255)
	{
	 l_iValeurSeuil = 255;
	}
// Debut Attente
wxBeginBusyCursor();
// Seuillage de l'Image - A faire verifier new

ImageBin *l_ImageBinDestination = new ImageBin(l_pImageSourceGray256, l_iValeurSeuil, l_wNomImageDestination);

// Insertion dans la Liste

g_InterfaceImageBin.AjouterImageBin(l_wNomImageDestination, l_ImageBinDestination); 
// Affichage

if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
g_Bitmap = l_ImageBinDestination->VisualiserBin();

// Mise a jour de l'affichage
wxEndBusyCursor();

canvas->Refresh();
return;
}

//---------------------------------
// Affiche l'image bin selectionnee
//---------------------------------

void MyFrame::OnImageBin(wxCommandEvent& event)
{
g_InterfaceImageBin.OnImageBin(event);
return;
}

//-----------------------
// Inverse une image bin 
//-----------------------

void MyFrame::OnInverserBin(wxCommandEvent& WXUNUSED(event))
{
g_InterfaceImageBin.OnInverserBin();

return;
}

//-----------------------
// Erosion une image bin 
//-----------------------

void MyFrame::OnErosionBin(wxCommandEvent& WXUNUSED(event))
{
g_InterfaceImageBin.OnErosionBin();

return;
}

//-----------------------
// Erosion une image bin 
//-----------------------

void MyFrame::OnDilatationBin(wxCommandEvent& WXUNUSED(event))
{
g_InterfaceImageBin.OnDilatationBin();

return;
}

//------------------------------------
// Convolution Image Gray 256
//------------------------------------

void MyFrame::OnConvoluer256(wxCommandEvent& event)
{

ImageGray256
	*l_pImageSourceGray256;


// Recherche du masque selectionne
MasqueDouble * l_MasqueDouble;
l_MasqueDouble = g_InterfaceMasqueDouble.SelectionMasqueDouble();

if (l_MasqueDouble == NULL)
	{
	 return;
	}
// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

if (l_wNomImage.IsEmpty())
	{
	 return;
	}
	
l_pImageSourceGray256 = g_InterfaceImageGray256.ChercherImageGray256(l_wNomImage);

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Debut Attente
wxBeginBusyCursor();

// Produit de convolution
ImageDouble *l_ImageDoubleDestination =
l_pImageSourceGray256->Convoluer(l_wNomImageDestination, l_MasqueDouble);

// Insertion dans la Liste Double

g_InterfaceImageDouble.AjouterImageDouble(l_wNomImageDestination, l_ImageDoubleDestination); 

// Affichage
if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
g_Bitmap = l_ImageDoubleDestination->VisualiserDouble();

// Fin attente
wxEndBusyCursor();

// Mise a jour de l'affichage
canvas->Refresh();
return;
}

//------------------------------------
// Affiche l'image double selectionnee
//------------------------------------

void MyFrame::OnImageDouble(wxCommandEvent& event)
{
g_InterfaceImageDouble.OnImageDouble(event);
return;
}

//-----------------------------------------------------
// Convertie en Image Niveau de Gris sans normalisation
//-----------------------------------------------------

void MyFrame::OnConvertirImageGray(wxCommandEvent& event)
{
ImageDouble
	*l_pImageSourceDouble;

// Si pas trop de fichiers ouvert
if (!( g_NbImageDouble < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop d'images ouvertes pour le Menu!", "Erreur", wxOK);
	 return;
	}	
// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

l_pImageSourceDouble = g_InterfaceImageDouble.ChercherImageDouble(l_wNomImage);

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Creation de l'Image
ImageGray256 *l_ImageGray256Destination = new
ImageGray256(l_wNomImageDestination, l_pImageSourceDouble, 0, 255);

// Insertion dans la Liste Gray 256

g_InterfaceImageGray256.AjouterImageGray256(l_wNomImageDestination,
l_ImageGray256Destination); 

// Affichage
if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
g_Bitmap = l_ImageGray256Destination->Visualiser256();
// Mise a jour de l'affichage
canvas->Refresh();
return;
}

//-----------------------------------------------------
// Convertie en Image Niveau de Gris avec normalisation
//-----------------------------------------------------

void MyFrame::OnConvertirImageGrayMinMax(wxCommandEvent& event)
{
ImageDouble
	*l_pImageSourceDouble;

// Si pas trop de fichiers ouvert
if (!( g_NbImageDouble < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop d'images ouvertes pour le Menu!", "Erreur", wxOK);
	 return;
	}	
// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");


l_pImageSourceDouble = g_InterfaceImageDouble.ChercherImageDouble(l_wNomImage);

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Creation de l'Image
ImageGray256 *l_ImageGray256Destination = new
ImageGray256(l_wNomImageDestination, l_pImageSourceDouble, 0, 255);

// Insertion dans la Liste Gray 256

g_InterfaceImageGray256.AjouterImageGray256(l_wNomImageDestination,
l_ImageGray256Destination); 

// Affichage
if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
g_Bitmap = l_ImageGray256Destination->Visualiser256();
// Mise a jour de l'affichage
canvas->Refresh();

return;
}

//-------------------------------------
// Affiche la valeur Min Max de l'image
//-------------------------------------

void MyFrame::OnImageDoubleAfficherMinMax(wxCommandEvent& event)
{
g_InterfaceImageDouble.OnImageDoubleAfficherMinMax();
return;
}

//------------------------------------
// Convolution Image Double
//------------------------------------

void MyFrame::OnConvoluerImageDouble(wxCommandEvent& event)
{

ImageDouble
	*l_pImageSourceDouble;
	
// Recherche du masque selectionne
MasqueDouble * l_MasqueDouble;
l_MasqueDouble = g_InterfaceMasqueDouble.SelectionMasqueDouble();

if (l_MasqueDouble == NULL)
	{
	 return;
	}

// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

l_pImageSourceDouble = g_InterfaceImageDouble.ChercherImageDouble(l_wNomImage);

// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");

// Debut Attente
wxBeginBusyCursor();

// Produit de convolution
ImageDouble *l_ImageDoubleDestination =
l_pImageSourceDouble->Convoluer(l_wNomImageDestination, l_MasqueDouble);

// Insertion dans la Liste Double

g_InterfaceImageDouble.AjouterImageDouble(l_wNomImageDestination, l_ImageDoubleDestination); 

// Affichage
if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
g_Bitmap = l_ImageDoubleDestination->VisualiserDouble();

// Fin attente
wxEndBusyCursor();

// Mise a jour de l'affichage
canvas->Refresh();
return;

}

//----------------------------------
// Fonction Seuillage image Double
//----------------------------------

void MyFrame::OnSeuillerDouble(wxCommandEvent& WXUNUSED(event))
{
ImageDouble
	*l_pImageSourceDouble;

// Si pas trop de fichiers ouvert
if (!( g_NbImageDouble < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop d'images ouvertes pour le Menu!", "Erreur", wxOK);
	 return;
	}	
// Lecture Nom Logique de L'image
wxString l_wNomImage = wxGetTextFromUser("Entrez le nom de l'image source: ", "Nom de l'image", "");

// Recherche de l'image

l_pImageSourceDouble = g_InterfaceImageDouble.ChercherImageDouble(l_wNomImage);


// Lecture Nom Logique de L'image
wxString l_wNomImageDestination = wxGetTextFromUser("Entrez le nom de l'image destination: ", "Nom de l'image", "");


// Lecture Valeur du Seuil
wxString l_wValeurSeuil = wxGetTextFromUser("Entrez La valeur de seuil: ", "Seuil", "");
double l_dValeurSeuil = atof(l_wValeurSeuil.GetData());

// Debut Attente
wxBeginBusyCursor();

// Seuillage de l'Image - A faire verifier new
ImageBin *l_ImageBinDestination = new ImageBin(l_pImageSourceDouble, l_dValeurSeuil, l_wNomImageDestination);
//ImageBin *l_ImageBinDestination = new ImageBin();

// Insertion dans la Liste
printf("avant \n");
g_InterfaceImageBin.AjouterImageBin(l_wNomImageDestination, l_ImageBinDestination);
printf("apres \n");
// Affichage

if (g_Bitmap) //liberation de la memoire
	{
	 delete g_Bitmap;
	}
g_Bitmap = l_ImageBinDestination->VisualiserBin();

// Mise a jour de l'affichage
wxEndBusyCursor();

canvas->Refresh();
return;
}


//------------------------------------
// Lecture masque de convolution
//------------------------------------

void MyFrame::OnOuvrirMasqueDouble(wxCommandEvent& event)
{
int l_iTest;
 Double * l_Masque;
// Menu plein
if (!( g_NbMasqueDouble < NB_MENU_MAX ))
	{
	 wxMessageBox ("Il y a trop de Masque", "Erreur", wxOK);
	 return;
	}
	
// Chargement d'un fichier
// Show file selector.
const wxString l_wNomFichier = wxFileSelector("Open Masque", (const char *) NULL,
    (const char *) NULL,".mf",
		  "mf files (*.mf)|*.mf|tous|*");
// Si fichier vide     
if (l_wNomFichier.IsEmpty())
	return;


// Lecture Nom Logique du Masque
wxString l_wNomMasque = wxGetTextFromUser("Entrez le nom du masque", "Nom du masque", "");

// Creation du Filtre

MasqueDouble * l_MasqueDouble = new MasqueDouble();
l_iTest = l_MasqueDouble -> LectureFichier(l_wNomFichier, l_wNomMasque);

if (l_iTest != 1)
  {
   (void)wxMessageBox("Erreur a l'ouverture", "Erreur", wxOK);
   return;
  }


// Ajout dans la liste des Masques
g_InterfaceMasqueDouble.AjouterMasqueDouble(l_wNomMasque, l_MasqueDouble);
g_NbMasqueDouble++;
return;
}

//----------------------------------
// Fonction Test
//----------------------------------

void MyFrame::OnTest(wxCommandEvent& WXUNUSED(event))
{
Test();
return;
}
