/////////////////////////////////////////////////////////////////////////////
// Name:        ImageGray256.cpp
// Purpose:     ImageGray256 class
// Author:      Alain Bouju
// Modified by:
// Created:     23/10/98
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////

#include "ImageGray256.h"

/*******************************************/
/* Constructeur image gray 256 niveau vide */
/*******************************************/

ImageGray256::ImageGray256 ()
{
	largeur = 0;
	hauteur = 0;
	nomLogique = wxString();
	image = NULL;
}

/**************************************/
/* Recherche de la Hauteur de l'Image */
/**************************************/

int ImageGray256::ChercherHauteur ()
{
	return hauteur;
}

/**************************************/
/* Recherche de la Largeur de l'Image */
/**************************************/

int ImageGray256::ChercherLargeur ()
{
	return largeur;
}

/**********************************/
/* Recherche de la Nom de l'Image */
/**********************************/

wxString ImageGray256::ChercherNom ()
{
	return nomLogique;
}

/***********************************/
/* Recherche du contenu de l'image */
/***********************************/

Gray256 * ImageGray256::ChercherImage ()
{
	return image;
}

/********************************************/
/* Constructeur image gray 256 a partir PGM */
/********************************************/

ImageGray256::ImageGray256 (wxString p_wNomLogique, ImagePGM *source)
{
	
	hauteur = source->ChercherHauteur();
	largeur = source->ChercherLargeur();
	
	nomLogique = p_wNomLogique;
	long int l_iTaille = hauteur * largeur;
	image = new Gray256 [l_iTaille];
	for(long int l_iIndice = 0; l_iIndice<l_iTaille; l_iIndice++)
		{
		 image[l_iIndice] = source ->image[l_iIndice];
		}
}

/*****************************************************/
/* Constructeur image gray 256 a partir Image Double */
/*****************************************************/

ImageGray256::ImageGray256 (wxString p_wNomLogique, ImageDouble *p_Source, int p_iMin, int
p_iMax)
{
	int l_iCalcul;
	double
		*l_dImageSource;
	double
		l_dMin,
		l_dMax;
		
	l_dMin = p_iMin;
	l_dMax = p_iMax;	
	l_dImageSource = p_Source -> ChercherImage();
	hauteur = p_Source -> ChercherHauteur();
	largeur = p_Source -> ChercherLargeur();
	
	nomLogique = p_wNomLogique;
	
	long int l_iTaille = hauteur * largeur;
	
	image = new Gray256 [l_iTaille];
	
	for(long int l_iIndice = 0; l_iIndice< l_iTaille; l_iIndice++)
		{
		 if ( l_dImageSource[l_iIndice] < l_dMin)
		 	{
		 	 image[l_iIndice] = 0;
			}
		 else if ( l_dImageSource[l_iIndice] > l_dMax)
		 	{
			 image[l_iIndice] = 255;
			}
		 else
		 	{
		         l_iCalcul = (int)((l_dImageSource[l_iIndice] -
		         p_iMin)/(l_dMax - l_dMin) * 255.);
		 	 image[l_iIndice] = l_iCalcul;
		 	}
		}
}

/********************************/
/* Constructeur image gray 256  */
/********************************/

ImageGray256::ImageGray256 (ImageGray256 *source)
{
	hauteur = source->ChercherHauteur();
	largeur = source->ChercherLargeur();

	nomLogique = wxString(source->ChercherNom());
	// Calcul de la taille de l'image
	long int l_iTaille = hauteur * largeur;
	// Creation du tableau contenant l'image
	image = new Gray256 [l_iTaille];

	Gray256 *temp = source->ChercherImage();
	// recopie de l'image
	for (int i=0; i<(hauteur*largeur); i++)
		image [i] = temp [i];
}

/********************************/
/* Destructeur image gray 256   */
/********************************/

ImageGray256::~ImageGray256 ( void )
{
	delete [] image;
}

/********************************/
/* Visualisation image gray 256 */
/********************************/

wxBitmap * ImageGray256::Visualiser256 ()
{
wxMemoryDC
	l_wMemDC;
long int l_iIndex;
long int l_iX;
long int l_iY;

/* Definition de la zone de l'image */

wxBitmap * p_wImage = new wxBitmap(largeur, hauteur, -1);
l_wMemDC.SelectObject( *p_wImage );
l_wMemDC.Clear();

/* Definition de la couleur */

wxColour l_wCouleur[256];

/* Initialisation pen */

wxPen l_wPen[256];

/* mise en place des couleur */

Gray256 l_iGray;

/* mise en place des couleur */
unsigned char l_uCouleurGray;
int l_iCouleur;
for(l_iCouleur=0; l_iCouleur <256; l_iCouleur++)
	{
	 l_iGray = l_iCouleur;
	 //l_wCouleur[l_iCouleur].Set(gray, gray, gray);
	 //l_wPen[l_iCouleur].SetColour(&l_wCouleur[l_iCouleur]);
	 l_wPen[l_iCouleur].SetColour(l_iGray, l_iGray, l_iGray);
	 l_wPen[l_iCouleur].SetWidth(wxDOT);
	 l_wPen[l_iCouleur].SetStyle(wxSOLID);
	}

/* Dessin de l'image */
l_iIndex = 0;
long int l_iHauteur = hauteur;
long int l_iLargeur = largeur;

for(long int l_iIndiceY=0; l_iIndiceY < l_iHauteur; l_iIndiceY++)
{
 for(long int l_iIndiceX=0; l_iIndiceX < l_iLargeur; l_iIndiceX++)
	{
	 l_iCouleur = image[l_iIndex+l_iIndiceX];		 	
	 l_wMemDC.SetPen(l_wPen[l_iCouleur]);
	 l_wMemDC.DrawPoint(l_iIndiceX, l_iIndiceY);		 	
	}
 l_iIndex += l_iLargeur;
}

return (p_wImage);
}

/***************************/
/* Inverse image gray 256  */
/***************************/

int ImageGray256::Inverse ()
{
for (int i=0; i<(largeur*hauteur);  i++)
	{
	 image [i] = 255 - image [i];
	}
}

/*
ImageGray256 *ImageGray256::Masque (ImageBin *Filtre, char *nom_destination)
{
	ImageGray256 *Resultat = new ImageGray256 (this);

	int taille = hauteur * largeur;

	for (int i=0; i<taille; i++)
		if ( Filtre->imagebinaire [i] )
		{
			if (image [i] < 127)
				Resultat->image [i] = image [i];
			else
				Resultat->image [i] = 127;
		}
		else
			Resultat->image [i] = image [i];

	strcpy (Resultat->nom_logique, nom_destination);

	return Resultat;
}
*/
/*****************************************************/
/* Division de la taille de l'image par 2            */
/*****************************************************/

ImageGray256 *ImageGray256::Diviser (wxString p_wNomDestination)
{
ImageGray256 *PetiteImage = new ImageGray256;

long int l_iLarg;
long int l_iHaut;

long int l_iLargeurDestination;
long int l_iHauteurDestination;

long int l_iLargeurIndice;
long int l_iHauteurIndice;

l_iLargeurDestination = largeur / 2;
l_iHauteurDestination = hauteur / 2;

PetiteImage->image = new Gray256 [l_iLargeurDestination * l_iHauteurDestination];
PetiteImage->nomLogique = p_wNomDestination;
PetiteImage->largeur = l_iLargeurDestination;
PetiteImage->hauteur = l_iHauteurDestination;

/* Boucle de calcul moyenne */

for (l_iHauteurIndice = 0; l_iHauteurIndice < l_iHauteurDestination;
l_iHauteurIndice++)
	{
	 for (l_iLargeurIndice = 0; l_iLargeurIndice < l_iLargeurDestination;l_iLargeurIndice++)
		{
		 int l_iSomme = 0;
		 l_iSomme = (image [2*l_iHauteurIndice*largeur + 2 * l_iLargeurIndice]+\
		 image [2*l_iHauteurIndice*largeur + 2 * l_iLargeurIndice + 1]+\
		 image [(2*l_iHauteurIndice+1)*largeur + 2 * l_iLargeurIndice]+\
		 image [(2*l_iHauteurIndice+1)*largeur + 2 * l_iLargeurIndice + 1]);
		 PetiteImage->image [l_iHauteurIndice *l_iLargeurDestination + l_iLargeurIndice] = l_iSomme / 4;
		}
	}
return PetiteImage;
}

/************************************************************************/
/*				FONCTION Convoluer			*/
/************************************************************************/
ImageDouble *ImageGray256::Convoluer(wxString p_wNomDestination, MasqueDouble	* p_MasqueConvolution)
{

//Allocation memoire de l'objet destination
	
ImageDouble *Destination = new ImageDouble(p_wNomDestination,largeur,hauteur);

// Produit de convoution
	
int   	      	l_iIndice;
int                 i, j, x, y;
double              somme;
double              el;
unsigned char       pixel;
Gray256
	* l_Tableau;
Double
	* l_TableauDestination;

l_Tableau = ChercherImage();

// Initialisation de l'image destination
l_TableauDestination = Destination -> ChercherImage();

for (l_iIndice = 0; l_iIndice < largeur * hauteur; l_iIndice++)
	l_TableauDestination[l_iIndice] = 0.0;
	
// Calcul de la convolution

for (i = 0 + p_MasqueConvolution -> x0;
	i < largeur - p_MasqueConvolution->largeur + p_MasqueConvolution->x0 + 1;
	i++)
	for (j = 0 + p_MasqueConvolution->y0;
	     j < hauteur - p_MasqueConvolution->hauteur + p_MasqueConvolution->y0 + 1;
	     j++)
	    {
	     somme = 0.0;
	     for (x = 0; x < p_MasqueConvolution->largeur; x++)
		for (y = 0; y < p_MasqueConvolution->hauteur; y++)
		{
		    somme += l_Tableau[(j+y)*largeur+i+x] *
p_MasqueConvolution->tableau[y*(p_MasqueConvolution->largeur)+ x];
		}
	     l_TableauDestination [j*largeur + i ] = somme / p_MasqueConvolution -> diviseur;
	    }	
	
	return(Destination);
}

/* ----------------------------------------------------*/
ImageGray256 *ImageGray256::DetectionContour (char *nom_destination, int shift)
{
	ImageGray256 *Resultat = new ImageGray256 (this);

	int taille = largeur * hauteur;

	for (int i=0; i<shift; i++)
		Resultat->image [i] = 0;

	int *image_int = new int [taille];
	int *Histo = new int [256];
	int *Histo_comp = new int [256];

	for (int i1=0; i1<taille; i1++)
	{
		Resultat->image [i1+shift] = image [i1];
	}

	for (int i2=0; i2<taille; i2++)
		image_int [i2] = Resultat->image [i2] + image [i2];

	for (int i3=0; i3<taille; i3++)
		Histo [image_int [i3]]++;
/* A Revoir A FAIRE*/
	for (int j=0; j<256; j+=2)
		Histo_comp [j/2] = Histo [j] + Histo [j+1];

	for (int i4=0; i4<taille; i4++)
		Resultat->image [i4] = (unsigned char) (image_int [i4] / 2);
	
	nomLogique = wxString(nom_destination);
	delete image_int;
	delete Histo;
	delete Histo_comp;

	return Resultat;
}


