/////////////////////////////////////////////////////////////////////////////
// Name:        ImageBin.h
// Purpose:     ImageBin class
// Author:      Alain Bouju
// Modified by:
// Created:     21/04/99
// RCS-ID:      
// Copyright:   
// Licence:   
//////////////////////////////////////////////////////////////////////////////

/* Definition de la classe Bin */
#ifndef IMAGEBIN_H__
#define IMAGEBIN_H__

#ifdef __GNUG__
#pragma interface
#endif

#include "wx/wx.h"

typedef unsigned char Bin;

#include "ImagePGM.h"
#include "ImageGray256.h"
#include "ImageDouble.h"
#include "MasqueBin.h"

class ImageGray256;
class ImageDouble;
class MasqueBin;

class ImageBin{
	wxString nomLogique;
	int hauteur;
	int largeur;
	Bin *image;
	
public :
//	Constructeur
	ImageBin (void);
	ImageBin (ImageGray256 *p_source, int p_iSeuil, wxString p_wNomLogique);
	ImageBin (ImageDouble *p_source, double p_dSeuil, wxString p_wNomLogique);
	ImageBin (ImageBin *source);
	ImageBin (wxString p_wNomLogique, int p_iLargeur, int p_iHauteur);
	~ImageBin (void);

//	Optention d'information sur objet
	int ChercherHauteur ();
	int ChercherLargeur ();
	wxString ChercherNom ();
	Bin *ChercherImage ();
	
//	Methodes

	wxBitmap * VisualiserBin ();
	int Inverse ();
	ImageBin *Diviser (wxString p_wNomDestination);
	ImageBin *ErosionBin(wxString p_wNomDestination, MasqueBin * p_pMasqueBin);
	ImageBin *DilatationBin(wxString p_wNomDestination, MasqueBin * p_pMasqueBin);
};


#endif
