/*
 * Decompiled with CFR 0.152.
 */
package examples.watcher;

import com.ibm.aglet.Message;
import com.ibm.aglet.util.AddressChooser;
import examples.watcher.ProxyWatcher;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class WatcherFrame
extends Frame
implements WindowListener,
ActionListener {
    ProxyWatcher aglet;
    TextArea text = new TextArea(10, 10);
    AddressChooser address = new AddressChooser(15);
    Button go = new Button("Go!");
    Button start = new Button("Start");
    Button stop = new Button("Stop");
    Button sleep = new Button("Sleep");
    Button move = new Button("Move");
    Button terminate = new Button("Terminate");

    WatcherFrame(ProxyWatcher proxyWatcher) {
        this.aglet = proxyWatcher;
        this.setLayout(new BorderLayout());
        this.add("North", (Component)this.address);
        this.add("Center", this.text);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.addWindowListener((WindowListener)this);
        this.go.addActionListener((ActionListener)this);
        this.start.addActionListener((ActionListener)this);
        this.stop.addActionListener((ActionListener)this);
        this.sleep.addActionListener((ActionListener)this);
        this.move.addActionListener((ActionListener)this);
        this.terminate.addActionListener((ActionListener)this);
        panel.add(this.go);
        panel.add(this.start);
        panel.add(this.stop);
        panel.add(this.sleep);
        panel.add(this.move);
        panel.add(this.terminate);
        this.add("South", panel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Go!".equals(actionEvent.getActionCommand())) {
            this.aglet.go(this.address.getAddress());
        } else if ("Start".equals(actionEvent.getActionCommand())) {
            this.aglet.sendMessage(new Message("start"));
        } else if ("Stop".equals(actionEvent.getActionCommand())) {
            this.aglet.sendMessage(new Message("stop"));
        } else if ("Sleep".equals(actionEvent.getActionCommand())) {
            this.aglet.sendMessage(new Message("sleep"));
        } else if ("Move".equals(actionEvent.getActionCommand())) {
            this.aglet.move(this.address.getAddress());
        } else if ("Terminate".equals(actionEvent.getActionCommand())) {
            this.aglet.terminate();
        }
    }

    void update(String string) {
        this.text.setText(string);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

