/*
 * Decompiled with CFR 0.152.
 */
package examples.talk;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletContext;
import com.ibm.aglet.AgletException;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.Message;
import examples.talk.TalkWindow;
import java.net.URL;

public class TalkMaster
extends Aglet {
    transient AgletProxy remoteProxy = null;
    String name = "Unknown";
    TalkWindow window = null;

    public void dispatchSlave(String string) {
        try {
            if (this.remoteProxy != null) {
                this.remoteProxy.sendMessage(new Message("bye"));
            }
            AgletContext agletContext = this.getAgletContext();
            AgletProxy agletProxy = agletContext.createAglet(null, "examples.talk.TalkSlave", (Object)this.getProxy());
            URL uRL = new URL(string);
            this.remoteProxy = agletProxy.dispatch(uRL);
        }
        catch (InvalidAgletException invalidAgletException) {
            invalidAgletException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getProperty(String string) {
        return System.getProperty(string, "Unknown");
    }

    public boolean handleMessage(Message message) {
        if (message.sameKind("dialog")) {
            this.window.show();
        } else if (message.sameKind("text")) {
            if (!this.window.isVisible()) {
                this.window.show();
            }
            this.window.appendText((String)message.getArg());
            return true;
        }
        return false;
    }

    public void onCreation(Object object) {
        this.window = new TalkWindow(this);
        this.window.pack();
        this.window.show();
        try {
            this.name = this.getProperty("user.name");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDisposing() {
        if (this.window != null) {
            this.window.dispose();
            this.window = null;
        }
        if (this.remoteProxy != null) {
            try {
                this.remoteProxy.sendMessage(new Message("bye"));
            }
            catch (AgletException agletException) {
                agletException.printStackTrace();
            }
        }
    }

    private void print(String string) {
        System.out.println("Sender: " + string);
    }

    void sendText(String string) {
        try {
            if (this.remoteProxy != null) {
                this.remoteProxy.sendMessage(new Message("text", (Object)(this.name + " : " + string)));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

