/*
 * Decompiled with CFR 0.152.
 */
package examples.patterns;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletException;
import examples.patterns.SampleWindow;
import examples.patterns.WriterSlave;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

class WriterSlaveWindow
extends Frame {
    private static final int SIZE = 40;
    private static final String TITLE = "Writer";
    private static final String THANKS = "THANKS!!";
    private GridBagLayout layout;
    private TextField _messageText = new TextField(40);
    private Aglet _aglet = null;
    protected Button _thanks = new Button("Thank");
    protected Button _quit = new Button("Quit");

    public WriterSlaveWindow(Aglet aglet, String string, String string2) throws AgletException {
        super(TITLE);
        this._aglet = aglet;
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        SampleWindow.setWindowProperties((Frame)this, (Aglet)this._aglet);
        this.makeMainPanel(string, string2);
        SampleWindow.displayFrame((Frame)this);
        this.writeMessage(string);
    }

    public void dispose() {
        super.dispose();
    }

    protected boolean handleButton(Button button) {
        if (button == this._thanks) {
            this.thanks();
        } else if (button == this._quit) {
            this.quit();
        }
        return true;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1001) {
            if (event.target instanceof Button) {
                return this.handleButton((Button)event.target);
            }
        } else {
            if (event.id == 203) {
                this.setVisible(false);
                return true;
            }
            if (event.id == 201) {
                this.quit();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    protected Panel makeButtonPanel() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        panel.add(this._thanks);
        panel.add(this._quit);
        return panel;
    }

    private void makeMainPanel(String string, String string2) throws AgletException {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        Component component = this.makeButtonPanel();
        this.layout.setConstraints(component, gridBagConstraints);
        this.add(component);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        component = new Label("MESSAGE FROM: " + string2);
        this.layout.setConstraints(component, gridBagConstraints);
        this.add(component);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        component = this._messageText;
        this.layout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    void quit() {
        this.dispose();
        ((WriterSlave)this._aglet).wakeup();
    }

    void thanks() {
        ((WriterSlave)this._aglet).setResult(THANKS);
        this.quit();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void writeMessage(String string) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = this._messageText.getSize().width;
        int n2 = fontMetrics.charWidth(' ');
        try {
            int n3 = 0;
            while (n3 < n) {
                char[] cArray = new char[(n - n3) / n2];
                int n4 = 0;
                while (n4 < cArray.length) {
                    cArray[n4] = 32;
                    ++n4;
                }
                String string2 = new String(cArray);
                this._messageText.setText(string2 + string);
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

