/*
 * Decompiled with CFR 0.152.
 */
package examples.patterns;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletContext;
import com.ibm.aglet.AgletException;
import com.ibm.aglet.AgletID;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.Message;
import com.ibm.aglet.event.CloneEvent;
import com.ibm.aglet.event.CloneListener;
import com.ibm.aglet.event.MobilityEvent;
import com.ibm.aglet.event.MobilityListener;
import com.ibm.aglet.event.PersistencyEvent;
import com.ibm.aglet.event.PersistencyListener;
import examples.patterns.SampleWindow;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;

public abstract class SampleAglet
extends Aglet
implements MobilityListener,
PersistencyListener,
CloneListener {
    protected SampleWindow _msw = null;

    abstract void createSlave(Vector var1, Object var2);

    abstract void createWindow();

    protected synchronized void Dialog() {
        if (this._msw != null) {
            this._msw.show();
        }
    }

    public static AgletProxy getAgletProxyInContext(Aglet aglet, AgletID agletID) throws AgletException {
        return aglet.getAgletContext().getAgletProxy(agletID);
    }

    protected void go(URL uRL) {
        this.setupSlave(uRL);
        Vector<URL> vector = new Vector<URL>();
        vector.addElement(uRL);
        this.createSlave(vector, new Object());
    }

    protected void go(Vector vector, Object object) {
        this.setupSlave((URL)vector.firstElement());
        this.createSlave(vector, object);
    }

    public boolean handleMessage(Message message) {
        try {
            if (message.sameKind("updateWindow")) {
                this.updateWindow();
            } else if (message.sameKind("error")) {
                this.inError((Object)((String)message.getArg()));
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return false;
    }

    protected synchronized void inError(Object object) {
        this.setTheMessage((String)object);
    }

    public static URL makeAgletURL(URL uRL, AgletID agletID) throws IOException {
        return new URL(uRL.toString() + "#" + agletID.toString());
    }

    public void onActivation(PersistencyEvent persistencyEvent) {
        this._msw.show();
    }

    public void onArrival(MobilityEvent mobilityEvent) {
        throw new SecurityException("should not arrive here");
    }

    public void onClone(CloneEvent cloneEvent) {
    }

    public void onCloned(CloneEvent cloneEvent) {
    }

    public void onCloning(CloneEvent cloneEvent) {
        throw new SecurityException("not allowed");
    }

    public void onCreation(Object object) {
        this.addMobilityListener((MobilityListener)this);
        this.addCloneListener((CloneListener)this);
        this.addPersistencyListener((PersistencyListener)this);
        try {
            this.subscribeMessage("updateWindow");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.createWindow();
    }

    public void onDeactivating(PersistencyEvent persistencyEvent) {
        this._msw.setVisible(false);
    }

    public synchronized void onDispatching(MobilityEvent mobilityEvent) {
        throw new SecurityException("Don't ever try to move me!");
    }

    public synchronized void onDisposing() {
        if (this._msw != null) {
            this._msw.dispose();
        }
    }

    public void onReverting(MobilityEvent mobilityEvent) {
        throw new SecurityException();
    }

    protected void resetTheWindow() {
        if (this._msw != null) {
            this._msw.clearResult();
        }
    }

    public void run() {
        this.setText("Starting...");
    }

    protected synchronized void setTheMessage(String string) {
        super.setText(string);
        if (this._msw != null) {
            this._msw.setMessage(string);
        }
    }

    protected void setupSlave(URL uRL) {
        String string = uRL.toString();
        if (uRL.getHost().equals("")) {
            string = "localhost";
            System.exit(1);
        }
        this.resetTheWindow();
        this.setTheMessage("going to: " + string);
        this.getAgletContext().setProperty("position", (Object)this._msw.getPosition());
        this.getAgletContext().setProperty("filename", (Object)this._msw.getFilename());
        this.getAgletContext().multicastMessage(new Message("updateWindow"));
    }

    protected synchronized void updateWindow() throws Exception {
        AgletContext agletContext = this.getAgletContext();
        this._msw.setPosition((String)agletContext.getProperty("position", (Object)this._msw.getPosition()));
        this._msw.setFilename((String)agletContext.getProperty("filename", (Object)this._msw.getFilename()));
    }
}

