/*
 * Decompiled with CFR 0.152.
 */
package examples.patterns;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;

public class MessagePanel
extends Panel {
    private GridBagConstraints cns = new GridBagConstraints();
    private GridBagLayout grid = new GridBagLayout();
    private boolean raised;
    private int alignment;
    public static final String lineSeparator = "\n";
    public static final char lineSeparatorChar = "\n".charAt(0);

    public MessagePanel(String string, int n, boolean bl) {
        this.alignment = n;
        this.raised = bl;
        this.setMessage(string);
    }

    public MessagePanel(String string, boolean bl) {
        this(string, 0, bl);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.draw3DRect(1, 1, this.getSize().width - 2, this.getSize().height - 2, this.raised);
    }

    public void setAlignment(int n) {
        int n2 = this.getComponentCount();
        this.alignment = n;
        int n3 = 0;
        while (n3 < n2) {
            Component component = this.getComponent(n3);
            if (component instanceof Label) {
                ((Label)component).setAlignment(n);
            }
            ++n3;
        }
    }

    public void setMessage(String string) {
        this.removeAll();
        String[] stringArray = this.split(string);
        this.cns.gridwidth = 0;
        this.cns.fill = 1;
        this.cns.weightx = 1.0;
        this.cns.weighty = 1.0;
        this.cns.insets = new Insets(3, 3, 3, 3);
        this.setLayout(this.grid);
        int n = 0;
        while (n < stringArray.length) {
            Label label = new Label(stringArray[n], this.alignment);
            this.grid.setConstraints(label, this.cns);
            this.add(label);
            ++n;
        }
    }

    private String[] split(String string) {
        int n;
        String[] stringArray = new String[50];
        int n2 = lineSeparator.length();
        int n3 = 0;
        while ((n = string.indexOf(lineSeparator)) >= 0 && n3 < 49) {
            stringArray[n3] = string.substring(0, n);
            string = string.substring(n + n2);
            ++n3;
        }
        stringArray[n3++] = string;
        String[] stringArray2 = new String[n3];
        System.arraycopy(stringArray, 0, stringArray2, 0, n3);
        return stringArray2;
    }
}

