/*
 * Decompiled with CFR 0.152.
 */
package examples.patterns;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;

public abstract class GeneralDialog
extends Dialog {
    public static final int OKAY = 1;
    public static final int CANCEL = 4;
    public static final int APPLY = 8;
    public static final int HELP = 16;
    public static final int ALWAYS_CENTER = 1;
    public static final int CENTER_ONLY_ONCE = 2;
    public static final int FREE = 3;
    private Component callback_component = null;
    private Event newEvent = null;
    private Object object = null;
    private Button okay = new Button("Okay");
    private Button cancel = new Button("Cancel");
    private Button apply = new Button("Apply");
    private Button help = new Button("Help");
    private Panel button_panel = new Panel();
    private int button_bits = 21;
    private boolean shown = false;
    Object lock = new Object();

    public GeneralDialog(Frame frame, Component component, String string, Object object, boolean bl) {
        super(frame, string, bl);
        this.callback_component = component;
        this.object = object;
        if (frame != null && !frame.isDisplayable()) {
            frame.addNotify();
        }
        if (!this.isDisplayable()) {
            this.addNotify();
        }
    }

    public void addButton(Button button) {
        this.button_panel.add(button);
    }

    protected void addCmp(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    public void beep() {
        System.out.println("\u0007");
        System.out.flush();
    }

    public Button getButton(int n) {
        switch (n) {
            case 1: {
                return this.okay;
            }
            case 4: {
                return this.cancel;
            }
            case 16: {
                return this.help;
            }
            case 8: {
                return this.apply;
            }
        }
        return null;
    }

    public Label getTitleLabel() {
        Font font = new Font(this.getFont().getName(), 1, this.getFont().getSize() + 4);
        Label label = new Label(this.getTitle(), 1);
        label.setFont(font);
        return label;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1001) {
            boolean bl = super.handleEvent(event);
            if (!bl && this.my_action(event)) {
                return true;
            }
            if (this.callback_component != null && this.callback_component != this) {
                event.arg = this.object;
                if (this.callback_component.handleEvent(event)) {
                    return true;
                }
            }
            if (this.newEvent != null && this.callback_component != this) {
                bl = this.callback_component.handleEvent(this.newEvent);
            }
            this.newEvent = null;
            return bl;
        }
        if (event.id != 201) {
            return super.handleEvent(event);
        }
        this.setVisible(false);
        return true;
    }

    protected final void layoutComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.setLayout(gridBagLayout);
        Label label = this.getTitleLabel();
        label.setAlignment(1);
        this.addCmp((Component)label, gridBagLayout, gridBagConstraints);
        this.makePanel(gridBagLayout);
        this.button_panel.setLayout(new FlowLayout());
        this.button_panel.doLayout();
        this.addCmp((Component)this.button_panel, gridBagLayout, gridBagConstraints);
    }

    protected abstract void makePanel(GridBagLayout var1);

    private final boolean my_action(Event event) {
        if (event.target == this.okay) {
            return this.onOkay();
        }
        if (event.target == this.cancel) {
            return this.onCancel();
        }
        if (event.target == this.help) {
            return this.onHelp();
        }
        if (event.target == this.apply) {
            return this.onApply();
        }
        return false;
    }

    protected boolean onApply() {
        return false;
    }

    protected boolean onCancel() {
        return false;
    }

    protected boolean onHelp() {
        return false;
    }

    protected boolean onOkay() {
        return false;
    }

    public void pack() {
        if ((this.button_bits & 1) != 0) {
            this.button_panel.add(this.okay);
        }
        if ((this.button_bits & 4) != 0) {
            this.button_panel.add(this.cancel);
        }
        if ((this.button_bits & 8) != 0) {
            this.button_panel.add(this.apply);
        }
        if ((this.button_bits & 0x10) != 0) {
            this.button_panel.add(this.help);
        }
        this.button_panel.doLayout();
        super.pack();
    }

    public void popup(int n) {
        if (!this.shown) {
            this.pack();
            if (n == 2) {
                n = 1;
            }
        }
        switch (n) {
            case 1: {
                Dimension dimension = this.getToolkit().getScreenSize();
                this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
                break;
            }
        }
        this.show();
    }

    public void popup(Frame frame) {
        if (frame == null) {
            frame = (Frame)this.getParent();
        }
        if (!this.shown) {
            this.pack();
        }
        Rectangle rectangle = frame.getBounds();
        this.setLocation(rectangle.x + (rectangle.width - this.getSize().width) / 2, rectangle.y + (rectangle.height - this.getSize().height) / 2);
        this.show();
    }

    protected void postCallbackEvent(Event event) {
        this.newEvent = event;
    }

    public void setButtons(int n) {
        this.button_bits = n;
        if (this.isVisible()) {
            this.button_panel.removeAll();
            this.pack();
        }
    }

    protected void setCallbackComponent(Component component) {
        this.callback_component = component;
    }

    public void waitForDisplay() throws InterruptedException {
        Thread thread = Thread.currentThread();
        while (!this.isVisible()) {
            Thread.yield();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread.yield();
    }

    public void waitForDisposal() throws InterruptedException {
        Thread thread = Thread.currentThread();
        while (this.isVisible()) {
            Thread.yield();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

