/*
 * Decompiled with CFR 0.152.
 */
package examples.mdispatcher;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.Message;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class MethodDispatcher
implements Serializable {
    private static Class TYPE = null;
    private Object target;
    transient Hashtable method_table = new Hashtable();

    public MethodDispatcher(Object object) {
        this.target = object;
        this.makeTable();
    }

    public boolean handleMessage(Message message) {
        Method method = (Method)this.method_table.get(message.getKind());
        if (method != null) {
            try {
                Object[] objectArray = new Object[]{message};
                method.invoke(this.target, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    if (invocationTargetException.getTargetException() instanceof Exception) {
                        message.sendException((Exception)invocationTargetException.getTargetException());
                    } else {
                        message.sendException((Exception)invocationTargetException);
                    }
                }
                catch (IllegalAccessError illegalAccessError) {
                    // empty catch block
                }
                return false;
            }
            return true;
        }
        return false;
    }

    void makeTable() {
        this.method_table = new Hashtable();
        Class<?> clazz = this.target.getClass();
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length == 1 && classArray[0] == TYPE && Modifier.isPublic(method.getModifiers())) {
                this.method_table.put(method.getName(), method);
            }
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.target = (Aglet)objectInputStream.readObject();
        this.makeTable();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.target);
    }

    static {
        try {
            TYPE = Class.forName("com.ibm.aglet.Message");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

