/*
 * Decompiled with CFR 0.152.
 */
package examples.itinerary;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletID;
import com.ibm.aglet.Message;
import com.ibm.aglet.event.MobilityEvent;
import com.ibm.aglet.event.MobilityListener;
import com.ibm.agletx.patterns.Meeting;

public final class StationaryAglet
extends Aglet
implements MobilityListener {
    private Meeting meeting = null;
    boolean dispatched = false;

    public boolean handleMessage(Message message) {
        if (message.sameKind("dispose")) {
            try {
                this.dispose();
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (this.meeting != null && message.sameKind(this.meeting.getID())) {
            this.meet((AgletID)message.getArg());
            message.sendReply((Object)this.getAgletID());
            this.dispose();
            return true;
        }
        return false;
    }

    private void meet(AgletID agletID) {
        this.print("[" + this.getAgletID() + "] I met with VisitingAglet [id=" + agletID + "]");
    }

    public void onArrival(MobilityEvent mobilityEvent) {
        this.print("on Arrival");
        this.dispatched = true;
        try {
            this.meeting.ready((Aglet)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onCreation(Object object) {
        this.print("created!");
        this.addMobilityListener((MobilityListener)this);
        this.meeting = (Meeting)object;
    }

    public void onDispatching(MobilityEvent mobilityEvent) {
        if (this.dispatched) {
            throw new SecurityException("Don't try to move me!!");
        }
    }

    public void onDisposing() {
        this.print("disposed!!");
    }

    public void onReverting(MobilityEvent mobilityEvent) {
        throw new SecurityException();
    }

    private void print(String string) {
        System.out.println(">>>StationaryAglet:" + string);
    }
}

