/*
 * Decompiled with CFR 0.152.
 */
package examples.itinerary;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.Message;
import com.ibm.agletx.util.SeqPlanItinerary;
import examples.itinerary.CirculateFrame;
import java.util.Enumeration;
import java.util.Vector;

public class CirculateAglet
extends Aglet {
    StringBuffer buffer;
    SeqPlanItinerary itinerary;
    Vector proxies;

    public void getLocalInfo(Message message) {
        this.buffer.append("Username : " + this.getProperty("user.name"));
        this.buffer.append("\n");
        this.buffer.append("Home directory : " + this.getProperty("user.home"));
        this.buffer.append("\n");
        this.buffer.append("Currect working directory : " + this.getProperty("user.dir"));
        this.buffer.append("\n");
        this.buffer.append("Machine architecture : " + this.getProperty("os.arch"));
        this.buffer.append("\n");
        this.buffer.append("OS name : " + this.getProperty("os.name"));
        this.buffer.append("\n");
        this.buffer.append("OS version : " + this.getProperty("os.version"));
        this.buffer.append("\n");
        this.buffer.append("Java version : " + this.getProperty("java.version"));
        this.buffer.append("\n");
    }

    private String getProperty(String string) {
        return System.getProperty(string, "Unknown");
    }

    public void getProxies(Message message) {
        Enumeration enumeration = this.getAgletContext().getAgletProxies(1);
        while (enumeration.hasMoreElements()) {
            this.proxies.addElement(enumeration.nextElement());
        }
    }

    public boolean handleMessage(Message message) {
        if (message.sameKind("getLocalInfo")) {
            this.getLocalInfo(message);
            return true;
        }
        if (message.sameKind("getProxies")) {
            this.getProxies(message);
            return true;
        }
        if (message.sameKind("dialog")) {
            CirculateFrame circulateFrame = new CirculateFrame(this);
            circulateFrame.pack();
            circulateFrame.setVisible(true);
            this.init();
            return true;
        }
        if (message.sameKind("printResult")) {
            System.out.println(this.buffer);
            Enumeration enumeration = this.proxies.elements();
            while (enumeration.hasMoreElements()) {
                AgletProxy agletProxy = (AgletProxy)enumeration.nextElement();
                try {
                    System.out.println(agletProxy.getAgletInfo());
                }
                catch (InvalidAgletException invalidAgletException) {
                    System.out.println("InvalidAglet");
                }
            }
            return true;
        }
        return false;
    }

    private void init() {
        this.buffer = new StringBuffer();
        this.proxies = new Vector();
    }

    public void oncemore() {
        try {
            this.itinerary.startTrip();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onCreation(Object object) {
        this.itinerary = new SeqPlanItinerary((Aglet)this);
        this.itinerary.addPlan("atp://sirius.trl.ibm.com:2000/", "getLocalInfo");
        this.itinerary.addPlan("atp://vmoshima.trl.ibm.com/", "getProxies");
        this.itinerary.addPlan(this.getAgletContext().getHostingURL().toString(), "printResult");
    }

    public void start() {
        this.init();
        this.oncemore();
    }
}

