/*
 * Decompiled with CFR 0.152.
 */
package examples.http;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.Message;
import com.ibm.aglet.RequestRefusedException;
import com.ibm.awb.misc.Encoding;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;

public class WebServerAglet
extends Aglet {
    private static final Encoding ENCODING = Encoding.getDefault();
    private static final String ENCODING_JAVA = ENCODING.getJavaEncoding();
    private static final String CHARSET_PAGE = ENCODING.getHTMLCharset();
    private static String META_TAG = null;
    String indexPage = null;

    boolean handleHttpRequest(Message message, PrintWriter printWriter) {
        System.out.println(message);
        if (message.sameKind("index.html") || message.sameKind("")) {
            printWriter.println(this.indexPage);
            printWriter.flush();
        } else if (message.sameKind("next.html")) {
            printWriter.println("<HTML>");
            printWriter.println("<HEAD>");
            printWriter.println(META_TAG);
            printWriter.println("<TITLE>");
            printWriter.println("NEXT");
            printWriter.println("</TITLE>");
            printWriter.println("</HEAD>");
            printWriter.println("<BODY>");
            printWriter.println("<H1> Here is a list of proxies in <TT>" + this.getAgletContext().getHostingURL() + "</TT></H1>");
            Enumeration enumeration = this.getAgletContext().getAgletProxies(3);
            printWriter.println("<PRE>");
            while (enumeration.hasMoreElements()) {
                AgletProxy agletProxy = (AgletProxy)enumeration.nextElement();
                try {
                    printWriter.println(agletProxy.getAgletInfo().toString());
                }
                catch (Exception exception) {
                    exception.printStackTrace(printWriter);
                }
            }
            printWriter.println("</PRE>");
            printWriter.println("</BODY>");
            printWriter.println("</HTML>");
            printWriter.flush();
            message.sendReply((Object)"text/html");
        } else if (message.sameKind("go")) {
            System.out.println((String)message.getArg("location"));
            String string = (String)message.getArg("location");
            if (string.startsWith("atp:") && (string = string.substring(4)).indexOf(58) < 0) {
                printWriter.println("<HTML>");
                printWriter.println("<HEAD>");
                printWriter.println(META_TAG);
                printWriter.println("<TITLE>");
                printWriter.println("ILLEGAL INPUT");
                printWriter.println("</TITLE>");
                printWriter.println("</HEAD>");
                printWriter.println("<BODY>");
                printWriter.println("<H1>");
                printWriter.println("Please specify port number. default = 434");
                printWriter.println("</H1>");
                printWriter.println("</BODY>");
                printWriter.println("</HTML>");
                printWriter.flush();
                message.sendReply((Object)"text/html");
                return true;
            }
            try {
                printWriter.println("<HTML>");
                printWriter.println("<HEAD>");
                printWriter.println(META_TAG);
                printWriter.println("<TITLE>");
                printWriter.println("MOVING TO");
                printWriter.println("</TITLE>");
                printWriter.println("</HEAD>");
                printWriter.println("<BODY>");
                printWriter.println("<H1> Moving to...! </H1>");
                String string2 = this.getAgletContext().getName();
                if (string2.equals("")) {
                    string2 = "default";
                }
                printWriter.println("<a href= \"http:" + string + "/aglets/" + string2 + "/" + this.getAgletID() + "/index.html\" TARGET=_top> atp:" + string + " </a>");
                printWriter.println("Click above link to trace me! <BR>");
                printWriter.println("</BODY>");
                printWriter.println("</HTML>");
                printWriter.flush();
                message.sendReply((Object)"text/html");
                this.dispatch(new URL("atp:" + string));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (RequestRefusedException requestRefusedException) {
                requestRefusedException.printStackTrace();
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean handleMessage(Message message) {
        Object object = message.getArg("cgi-response");
        Object var3_3 = null;
        if (object != null && object instanceof OutputStream) {
            OutputStream outputStream = (OutputStream)object;
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(outputStream, ENCODING_JAVA);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                outputStreamWriter = new OutputStreamWriter(outputStream);
            }
            PrintWriter printWriter = new PrintWriter(outputStreamWriter);
            return this.handleHttpRequest(message, printWriter);
        }
        return true;
    }

    void indexPage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML>");
        stringBuffer.append("<HEAD>");
        stringBuffer.append(META_TAG);
        stringBuffer.append("<TITLE>");
        stringBuffer.append("CGI TEST");
        stringBuffer.append("</TITLE>");
        stringBuffer.append("</HEAD>");
        stringBuffer.append("<BODY>");
        stringBuffer.append("<H1> Welcome to WebServerAglet! </H1>");
        stringBuffer.append("<a href=next.html> List Proxies </a> <BR>");
        stringBuffer.append("<FORM METHOD=GET ACTION=go>");
        stringBuffer.append("<INPUT NAME=location VALUE=\"atp://your.host\">");
        stringBuffer.append("<INPUT TYPE=submit VALUE=GO!> <BR>");
        stringBuffer.append("<P><FONT color=#FF0000>note:</FONT> Check box ");
        stringBuffer.append("for \"Accept HTTP Request as a message\"<BR>");
        stringBuffer.append("in \"Network Preference\" of target server <B>must be checked</B>.");
        stringBuffer.append("</BODY>");
        stringBuffer.append("</HTML>");
        this.indexPage = stringBuffer.toString();
    }

    public void onCreation(Object object) {
        this.getAgletContext().setProperty("name.test", (Object)this.getAgletID());
        this.indexPage();
        this.getMessageManager().setPriority("index.html", 11);
        this.getMessageManager().setPriority("next.html", 11);
    }

    static {
        META_TAG = "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html;";
        if (CHARSET_PAGE != null) {
            META_TAG = META_TAG + " charset=" + CHARSET_PAGE;
        }
        META_TAG = META_TAG + "\">";
    }
}

