/*
 * Decompiled with CFR 0.152.
 */
package examples.hello;

import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.Message;
import com.ibm.aglet.util.AddressChooser;
import examples.hello.HelloAglet;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class MyDialog
extends Frame
implements WindowListener,
ActionListener {
    private HelloAglet aglet = null;
    private AddressChooser dest = new AddressChooser();
    private TextField msg = new TextField(18);
    private Button go = new Button("GO!");
    private Button send = new Button("Send CLONE!");
    private Button close = new Button("CLOSE");

    MyDialog(HelloAglet helloAglet) {
        this.aglet = helloAglet;
        this.layoutComponents();
        this.addWindowListener((WindowListener)this);
        this.go.addActionListener((ActionListener)this);
        this.send.addActionListener((ActionListener)this);
        this.close.addActionListener((ActionListener)this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("GO!".equals(actionEvent.getActionCommand())) {
            this.aglet.setMessage(this.msg.getText());
            try {
                AgletProxy agletProxy = this.aglet.getProxy();
                agletProxy.sendOnewayMessage(new Message("startTrip", (Object)this.dest.getAddress()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if ("Send CLONE!".equals(actionEvent.getActionCommand())) {
            this.aglet.message = this.msg.getText();
            try {
                AgletProxy agletProxy = (AgletProxy)this.aglet.clone();
                agletProxy.sendOnewayMessage(new Message("startTrip", (Object)this.dest.getAddress()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if ("CLOSE".equals(actionEvent.getActionCommand())) {
            this.setVisible(false);
        }
    }

    private void layoutComponents() {
        this.msg.setText(this.aglet.message);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints((Component)this.dest, gridBagConstraints);
        this.add((Component)this.dest);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagLayout.setConstraints(this.msg, gridBagConstraints);
        this.add(this.msg);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        Panel panel = new Panel();
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        panel.setLayout(new FlowLayout());
        panel.add(this.go);
        panel.add(this.send);
        panel.add(this.close);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

