/*
 * Decompiled with CFR 0.152.
 */
package examples.finder;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletContext;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.Message;
import com.ibm.aglet.event.MobilityEvent;
import com.ibm.aglet.event.MobilityListener;
import com.ibm.aglet.event.PersistencyEvent;
import com.ibm.aglet.event.PersistencyListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class HostList
extends Aglet
implements PersistencyListener,
MobilityListener {
    Hashtable hostList;

    public void appendList(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(hashtable.get(k) instanceof String) || this.hostList.get(k) != null) continue;
            System.out.println("new: " + k);
            this.hostList.put(k, "new");
        }
    }

    public boolean handleMessage(Message message) {
        if (message.sameKind("dialog")) {
            try {
                int n = 0;
                System.out.println("HostList -- begin");
                Enumeration enumeration = this.hostList.keys();
                while (enumeration.hasMoreElements()) {
                    System.out.println(n++ + ": " + enumeration.nextElement());
                }
                System.out.println("HostList -- end");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
        if (message.sameKind("register")) {
            if (message.getArg() instanceof String) {
                this.hostList.put(message.getArg(), "running");
            }
            return true;
        }
        if (message.sameKind("append")) {
            if (message.getArg() instanceof Hashtable) {
                this.appendList((Hashtable)message.getArg());
            }
            return true;
        }
        if (message.sameKind("getlist")) {
            message.sendReply((Object)this.hostList);
            return true;
        }
        if (message.sameKind("shutdown")) {
            try {
                this.deactivate(0L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        if (message.sameKind("dispose")) {
            this.dispose();
            return true;
        }
        return true;
    }

    public void onActivation(PersistencyEvent persistencyEvent) {
        AgletContext agletContext = this.getAgletContext();
        AgletProxy agletProxy = this.getProxy();
        AgletProxy agletProxy2 = (AgletProxy)agletContext.getProperty("hostlist");
        if (agletProxy2 != null && agletProxy2.isValid()) {
            try {
                agletProxy2.sendMessage(new Message("append", (Object)this.hostList));
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            this.dispose();
        } else {
            agletContext.setProperty("hostlist", (Object)agletProxy);
        }
    }

    public void onArrival(MobilityEvent mobilityEvent) {
        this.dispose();
    }

    public void onCreation(Object object) {
        AgletContext agletContext = this.getAgletContext();
        AgletProxy agletProxy = this.getProxy();
        this.addMobilityListener((MobilityListener)this);
        this.addPersistencyListener((PersistencyListener)this);
        AgletProxy agletProxy2 = (AgletProxy)agletContext.getProperty("hostlist");
        if (agletProxy2 != null && agletProxy2.isValid()) {
            if (object instanceof Hashtable) {
                try {
                    agletProxy2.sendMessage(new Message("append", object));
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            this.dispose();
        } else {
            agletContext.setProperty("hostlist", (Object)agletProxy);
            this.hostList = object instanceof Hashtable ? (Hashtable)((Hashtable)object).clone() : new Hashtable();
            this.hostList.put(agletContext.getHostingURL().toString(), "running");
        }
    }

    public void onDeactivating(PersistencyEvent persistencyEvent) {
        this.getAgletContext().setProperty("hostlist", null);
    }

    public void onDispatching(MobilityEvent mobilityEvent) {
    }

    public void onRetraction(MobilityEvent mobilityEvent) {
    }

    public void onReverting(MobilityEvent mobilityEvent) {
    }
}

