/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.agletx.util;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.ServerNotFoundException;
import com.ibm.aglet.event.MobilityAdapter;
import com.ibm.aglet.event.MobilityEvent;
import com.ibm.aglet.event.MobilityListener;
import com.ibm.agletx.util.Task;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public abstract class SeqItinerary
extends MobilityAdapter
implements Serializable {
    static final long serialVersionUID = 7979344708988677111L;
    protected Aglet aglet;
    private Vector tasks = new Vector();
    private Vector hosts = new Vector();
    private int index = 0;
    protected transient AgletProxy currentTarget = null;
    private boolean repeat = false;
    private String origin = null;

    public SeqItinerary(Aglet aglet) {
        this.aglet = aglet;
        aglet.addMobilityListener((MobilityListener)this);
    }

    public void addAddress(String string) {
        this.addTask(string, (Task)null);
    }

    public Enumeration addresses() {
        return this.hosts.elements();
    }

    public void addTask(String string, Task task) {
        this.hosts.addElement(string);
        this.tasks.addElement(task);
    }

    public synchronized boolean atLastDestination() {
        return this.index >= this.hosts.size();
    }

    public void clear() {
        this.hosts = new Vector();
        this.tasks = new Vector();
        this.index = 0;
    }

    public String getAddressAt(int n) {
        return (String)this.hosts.elementAt(n);
    }

    public String getCurrentAddress() {
        return this.getAddressAt(this.index);
    }

    protected Task getCurrentTask() {
        return this.getTaskAt(this.index);
    }

    public String getOrigin() {
        return this.origin;
    }

    public AgletProxy getOwnerAglet() {
        return this.aglet.getAgletContext().getAgletProxy(this.aglet.getAgletID());
    }

    public Task getTaskAt(int n) {
        return (Task)this.tasks.elementAt(n);
    }

    public void goToNext() {
        try {
            if (this.atLastDestination()) {
                this.onTermination();
                return;
            }
            URL uRL = new URL((String)this.hosts.elementAt(this.index));
            this.aglet.dispatch(uRL);
        }
        catch (ServerNotFoundException serverNotFoundException) {
            this.handleTripException((Throwable)serverNotFoundException);
            this.tryNext();
        }
        catch (Exception exception) {
            this.handleTripException((Throwable)exception);
        }
    }

    public void handleException(Throwable throwable) {
        throwable.printStackTrace();
    }

    public void handleTripException(Throwable throwable) {
        this.tryNext();
    }

    void incIndex() {
        ++this.index;
    }

    public int indexOf(Task task) {
        return this.tasks.indexOf(task);
    }

    public int indexOf(String string) {
        return this.hosts.indexOf(string);
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onArrival(MobilityEvent mobilityEvent) {
        block8: {
            this.currentTarget = mobilityEvent.getAgletProxy();
            try {
                block7: {
                    try {
                        Task task = this.getCurrentTask();
                        if (task == null) break block7;
                        task.execute(this);
                    }
                    catch (Throwable throwable) {
                        this.handleException(throwable);
                        Object var4_5 = null;
                        ++this.index;
                        if (this.atLastDestination() && this.repeat) {
                            this.index = 0;
                        }
                        break block8;
                    }
                }
                Object var4_4 = null;
                ++this.index;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                ++this.index;
                if (this.atLastDestination() && this.repeat) {
                    this.index = 0;
                }
                throw throwable;
            }
            if (this.atLastDestination() && this.repeat) {
                this.index = 0;
            }
        }
        this.goToNext();
    }

    protected void onTermination() {
    }

    public void removeTaskAt(int n) {
        this.tasks.removeElementAt(n);
        this.hosts.removeElementAt(n);
    }

    public void setRepeat(boolean bl) {
        this.repeat = bl;
    }

    public int size() {
        return this.hosts.size();
    }

    public void startTrip() {
        this.origin = this.aglet.getAgletContext().getHostingURL().toString();
        this.index = 0;
        this.goToNext();
    }

    private void tryNext() {
        ++this.index;
        this.goToNext();
    }
}

