/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.agletx.patterns;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletException;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.aglet.Message;
import com.ibm.aglet.MessageException;
import com.ibm.aglet.NotHandledException;
import com.ibm.aglet.RequestRefusedException;
import com.ibm.aglet.ServerNotFoundException;
import com.ibm.aglet.event.MobilityEvent;
import com.ibm.agletx.patterns.SlaveError;
import com.ibm.agletx.util.SeqPlanItinerary;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

final class SlaveAgletItinerary
extends SeqPlanItinerary {
    private Message message = null;
    private boolean inOrigin = false;

    public SlaveAgletItinerary(Aglet aglet, URL uRL) {
        super(aglet);
        this.addPlan(uRL.toString(), "doJob");
    }

    public SlaveAgletItinerary(Aglet aglet, Vector vector) {
        super(aglet);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addPlan(((URL)enumeration.nextElement()).toString(), "doJob");
        }
    }

    private AgletProxy getProxy() {
        return this.aglet.getAgletContext().getAgletProxy(this.aglet.getAgletID());
    }

    public void goOrigin(Message message) {
        try {
            this.message = message;
            this.goOrigin1();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.message = null;
        }
    }

    private void goOrigin1() throws Exception {
        String string = this.getOrigin();
        if (string == null) {
            throw new AgletException("no origin exists");
        }
        this.inOrigin = true;
        while (true) {
            try {
                while (true) {
                    URL uRL = new URL(string);
                    this.aglet.dispatch(uRL);
                }
            }
            catch (ServerNotFoundException serverNotFoundException) {
                continue;
            }
            catch (RequestRefusedException requestRefusedException) {
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.inOrigin = false;
                return;
            }
            break;
        }
    }

    public void handleException(Throwable throwable) {
        URL uRL = this.aglet.getAgletContext().getHostingURL();
        this.goOrigin(new Message("onError", (Object)new SlaveError(uRL, throwable)));
    }

    public void handleTripException(Throwable throwable) {
        if (throwable instanceof ServerNotFoundException) {
            URL uRL = this.aglet.getAgletContext().getHostingURL();
            try {
                this.aglet.getProxy().sendMessage(new Message("onError", (Object)new SlaveError(uRL, throwable)));
            }
            catch (Exception exception) {
                this.handleException((Throwable)exception);
            }
        } else {
            this.handleException(throwable);
        }
    }

    public void onArrival(MobilityEvent mobilityEvent) {
        if (this.inOrigin) {
            try {
                if (this.message != null) {
                    this.getProxy().sendMessage(this.message);
                    this.aglet.dispose();
                }
            }
            catch (MessageException messageException) {
                this.handleException(messageException.getException());
            }
            catch (NotHandledException notHandledException) {
            }
            catch (InvalidAgletException invalidAgletException) {}
        } else {
            super.onArrival(mobilityEvent);
        }
    }

    protected void onTermination() {
        this.goOrigin(new Message("onReturn", null));
    }

    private void print(String string) {
        System.out.println(string);
    }

    public void startTrip() {
        Message message = new Message("initializeJob", null);
        try {
            this.getProxy().sendMessage(message);
        }
        catch (MessageException messageException) {
            this.handleException(messageException.getException());
        }
        catch (NotHandledException notHandledException) {
            this.handleException((Throwable)notHandledException);
        }
        catch (InvalidAgletException invalidAgletException) {
            this.handleException((Throwable)invalidAgletException);
        }
        super.startTrip();
    }
}

