/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.agletx.patterns;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletContext;
import com.ibm.aglet.AgletException;
import com.ibm.aglet.AgletID;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.Message;
import com.ibm.aglet.util.Arguments;
import com.ibm.agletx.patterns.SlaveAgletItinerary;
import com.ibm.agletx.patterns.SlaveError;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;

public abstract class Slave
extends Aglet {
    private AgletID master = null;
    private SlaveAgletItinerary itin = null;
    protected Object RESULT = null;
    protected Object ARGUMENT = null;

    public static AgletProxy create(URL uRL, String string, AgletContext agletContext, Aglet aglet, Vector vector, Object object) throws IOException, AgletException {
        Arguments arguments = new Arguments();
        arguments.setArg("master", (Object)aglet.getAgletID());
        arguments.setArg("itinerary", (Object)vector);
        arguments.setArg("argument", object);
        try {
            return agletContext.createAglet(uRL, string, (Object)arguments);
        }
        catch (InstantiationException instantiationException) {
            throw new AgletException(instantiationException.getClass().getName() + ':' + instantiationException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AgletException(classNotFoundException.getClass().getName() + ':' + classNotFoundException.getMessage());
        }
    }

    protected abstract void doJob() throws Exception;

    public AgletID getMaster() {
        return this.master;
    }

    private AgletProxy getMasterProxy(AgletID agletID, Aglet aglet) throws AgletException {
        return this.getAgletContext().getAgletProxy(agletID);
    }

    public String getOrigin() {
        return this.itin.getOrigin();
    }

    public boolean handleMessage(Message message) {
        try {
            if (message.sameKind("initializeJob")) {
                this.initializeJob();
            } else if (message.sameKind("doJob")) {
                this.doJob();
            } else if (message.sameKind("onError")) {
                this.onError((SlaveError)message.getArg());
            } else if (message.sameKind("onReturn")) {
                this.onReturn();
            } else {
                return false;
            }
            message.sendReply(true);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message.sendException(exception);
        }
        catch (ThreadDeath threadDeath) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            message.sendException(new Exception(throwable.getMessage()));
        }
        return false;
    }

    protected abstract void initializeJob() throws Exception;

    public synchronized void onCreation(Object object) {
        Arguments arguments = (Arguments)object;
        this.master = (AgletID)arguments.getArg("master");
        Vector vector = (Vector)arguments.getArg("itinerary");
        this.ARGUMENT = arguments.getArg("argument");
        this.RESULT = null;
        this.itin = new SlaveAgletItinerary((Aglet)this, vector);
        this.itin.startTrip();
    }

    private void onError(SlaveError slaveError) {
        String string = slaveError.host + "::<" + slaveError.text + ">";
        Message message = new Message("error", (Object)string);
        try {
            this.getMasterProxy(this.master, (Aglet)this).sendAsyncMessage(message);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onReturn() {
        Message message = new Message("result", this.RESULT);
        try {
            this.getMasterProxy(this.master, (Aglet)this).sendAsyncMessage(message);
        }
        catch (AgletException agletException) {
            agletException.printStackTrace();
        }
    }

    private void print(String string) {
        System.out.println(string);
    }
}

