/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.agletx.patterns;

import com.ibm.aglet.Aglet;
import com.ibm.aglet.AgletContext;
import com.ibm.aglet.AgletException;
import com.ibm.aglet.AgletID;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.Message;
import com.ibm.aglet.util.Arguments;
import com.ibm.agletx.patterns.Messenger;
import com.ibm.agletx.util.SimpleItinerary;
import java.io.IOException;
import java.net.URL;
import java.util.Date;

public abstract class Notifier
extends Aglet {
    public static final int NOTIFICATION = 0;
    public static final int EXPIRY = 1;
    public static final int EXCEPTION = 2;
    private static final double MIN_TIME_OF_DEACTIVATION = 0.008333333333333333;
    private String origin = null;
    private AgletID _master = null;
    private String _destination;
    private double _interval = 0.016666666666666666;
    private double _duration = 1.0;
    private long _startingTime = 0L;
    private boolean _stay = false;
    protected Object MESSAGE = null;
    protected Object ARGUMENT = null;

    private boolean checkTimeout() {
        return this._startingTime + (long)(this._duration * 3600000.0) > new Date().getTime();
    }

    public static AgletProxy create(URL uRL, String string, AgletContext agletContext, Aglet aglet, URL uRL2, double d, double d2, boolean bl, Object object) throws IOException, AgletException {
        Arguments arguments = new Arguments();
        arguments.setArg("destination", (Object)uRL2.toString());
        arguments.setArg("interval", d);
        arguments.setArg("duration", d2);
        arguments.setArg("stay", bl);
        arguments.setArg("agrument", object);
        arguments.setArg("receiver", (Object)aglet.getAgletID());
        try {
            return agletContext.createAglet(uRL, string, (Object)arguments);
        }
        catch (InstantiationException instantiationException) {
            throw new AgletException(instantiationException.getClass().getName() + ':' + instantiationException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AgletException(classNotFoundException.getClass().getName() + ':' + classNotFoundException.getMessage());
        }
    }

    protected abstract boolean doCheck() throws Exception;

    private void gotoSleep(double d) throws AgletException {
        if (d > 0.008333333333333333) {
            try {
                this.deactivate((long)((int)(d * 60.0)));
            }
            catch (IOException iOException) {
                throw new AgletException("deactivation has been failed!!");
            }
        } else {
            this.waitInHours(d);
        }
    }

    public boolean handleMessage(Message message) {
        try {
            if (!message.sameKind("start")) {
                return false;
            }
            this.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    protected abstract void initializeCheck() throws Exception;

    private String makeExceptionMessage(String string, Throwable throwable) {
        String string2 = this.getAgletContext().getHostingURL().toString();
        return new String(string2 + ":" + "<" + throwable.getClass().getName() + "::" + throwable.getMessage() + ">;" + (string != null ? "DURING " + string : "Internal"));
    }

    private void observeInit() throws Exception {
        try {
            this.initializeCheck();
        }
        catch (Throwable throwable) {
            throw new Exception(this.makeExceptionMessage("initializeCheck", throwable));
        }
        this.startTimer();
    }

    private void observeRun() throws Exception {
        try {
            while (this.checkTimeout()) {
                boolean bl = false;
                try {
                    bl = this.doCheck();
                }
                catch (Throwable throwable) {
                    throw new Exception(this.makeExceptionMessage("doCheck", throwable));
                }
                if (bl) {
                    this.sendRemoteMessage(0, this.MESSAGE);
                    if (!this._stay) break;
                }
                this.gotoSleep(this._interval);
            }
            this.sendRemoteMessage(1, (Object)new String("Stay/Duration-time has expired"));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            throw new Exception(this.makeExceptionMessage(null, (Throwable)exception));
        }
    }

    public synchronized void onCreation(Object object) {
        Arguments arguments = (Arguments)object;
        this._master = (AgletID)arguments.getArg("receiver");
        this._destination = (String)arguments.getArg("destination");
        this._interval = (Double)arguments.getArg("interval");
        this._duration = (Double)arguments.getArg("duration");
        this._stay = (Boolean)arguments.getArg("stay");
        this.ARGUMENT = arguments.getArg("agrument");
        this.origin = this.getAgletContext().getHostingURL().toString();
        try {
            SimpleItinerary simpleItinerary = new SimpleItinerary((Aglet)this);
            simpleItinerary.go(this._destination, new Message("start", null));
        }
        catch (AgletException agletException) {
            agletException.printStackTrace();
            this.dispose();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.dispose();
        }
    }

    private void sendRemoteMessage(int n, Object object) throws IOException, AgletException {
        Arguments arguments = new Arguments();
        arguments.setArg("message", object);
        arguments.setArg("date", (Object)new Date());
        arguments.setArg("type", n);
        URL uRL = new URL(this.origin);
        Messenger.create((AgletContext)this.getAgletContext(), (URL)uRL, (URL)uRL, (AgletID)this._master, (Message)new Message("notification", (Object)arguments));
    }

    private void start() {
        try {
            this.observeInit();
            this.observeRun();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                this.sendRemoteMessage(2, (Object)exception.getMessage());
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        this.dispose();
    }

    private void startTimer() {
        this._startingTime = new Date().getTime();
    }

    private synchronized void waitInHours(double d) {
        try {
            this.wait((int)(d * 3600.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

