/*

 ============================================================================
                   The Apache Software License, Version 1.1
 ============================================================================

 Copyright (C) 1999-2003 The Apache Software Foundation. All rights reserved.

 Redistribution and use in source and binary forms, with or without modifica-
 tion, are permitted provided that the following conditions are met:

 1. Redistributions of  source code must  retain the above copyright  notice,
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

 3. The end-user documentation included with the redistribution, if any, must
    include  the following  acknowledgment:  "This product includes  software
    developed  by the  Apache Software Foundation  (http://www.apache.org/)."
    Alternately, this  acknowledgment may  appear in the software itself,  if
    and wherever such third-party acknowledgments normally appear.

 4. The names "Apache Cocoon" and  "Apache Software Foundation" must  not  be
    used to  endorse or promote  products derived from  this software without
    prior written permission. For written permission, please contact
    apache@apache.org.

 5. Products  derived from this software may not  be called "Apache", nor may
    "Apache" appear  in their name,  without prior written permission  of the
    Apache Software Foundation.

 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS  FOR A PARTICULAR  PURPOSE ARE  DISCLAIMED.  IN NO  EVENT SHALL  THE
 APACHE SOFTWARE  FOUNDATION  OR ITS CONTRIBUTORS  BE LIABLE FOR  ANY DIRECT,
 INDIRECT, INCIDENTAL, SPECIAL,  EXEMPLARY, OR CONSEQUENTIAL  DAMAGES (INCLU-
 DING, BUT NOT LIMITED TO, PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS
 OF USE, DATA, OR  PROFITS; OR BUSINESS  INTERRUPTION)  HOWEVER CAUSED AND ON
 ANY  THEORY OF LIABILITY,  WHETHER  IN CONTRACT,  STRICT LIABILITY,  OR TORT
 (INCLUDING  NEGLIGENCE OR  OTHERWISE) ARISING IN  ANY WAY OUT OF THE  USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 This software  consists of voluntary contributions made  by many individuals
 on  behalf of the Apache Software  Foundation and was  originally created by
 Stefano Mazzocchi  <stefano@apache.org>. For more  information on the Apache
 Software Foundation, please see <http://www.apache.org/>.

*/
package org.apache.cocoon.xml;

import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ContentHandler;

/**
 * Logging content handler logs all events going through to the logger.
 *
 * @author <a href="mailto:vgritsenko@apache.org">Vadim Gritsenko</a>
 * @version CVS $Id: LoggingContentHandler.java,v 1.1 2003/03/09 00:09:46 pier Exp $
 */
public class LoggingContentHandler extends AbstractLogEnabled implements ContentHandler {

    /**
     * All debug messages from this handler are prefixed with this id.
     */
    String id;

    /** The current <code>ContentHandler</code>. */
    ContentHandler contentHandler;

    /**
     * Creates new <code>LoggingContentHandler</code> with specified
     * <code>id</code> and destination <code>contentHandler</code>.
     */
    public LoggingContentHandler(String id, ContentHandler contentHandler) {
        this.id = id;
        this.contentHandler = contentHandler;
    }

    public void setDocumentLocator(Locator locator) {
        log("setDocumentLocator", "");
        contentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        log("startDocument", "");
        this.contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        log ("endDocument", "");
        this.contentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        log ("startPrefixMapping", "prefix="+prefix+",uri="+uri);
        this.contentHandler.startPrefixMapping(prefix,uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        log ("endPrefixMapping", "prefix="+prefix);
        this.contentHandler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String loc, String raw, Attributes a)
    throws SAXException {
        log ("startElement", "uri="+uri+",local="+loc+",raw="+raw);
        for (int i = 0; i < a.getLength(); i++) {
            log ("            ", Integer.toString(i + 1)
                 + ". uri=" + a.getURI(i)
                 + ",local=" + a.getLocalName(i)
                 + ",qname=" + a.getQName(i)
                 + ",type=" + a.getType(i)
                 + ",value=" + a.getValue(i));
        }
        this.contentHandler.startElement(uri,loc,raw,a);
    }


    public void endElement(String uri, String loc, String qname) throws SAXException {
        log ("endElement", "uri="+uri+",local="+loc+",qname="+qname);
        this.contentHandler.endElement(uri,loc,qname);
    }

    public void characters(char ch[], int start, int len) throws SAXException {
        log ("characters", new String(ch,start,len));
        this.contentHandler.characters(ch,start,len);
    }

    public void ignorableWhitespace(char ch[], int start, int len) throws SAXException {
        log ("ignorableWhitespace", new String(ch,start,len));
        this.contentHandler.ignorableWhitespace(ch,start,len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        log ("processingInstruction", "target="+target+",data="+data);
        this.contentHandler.processingInstruction(target,data);
    }

    public void skippedEntity(String name) throws SAXException {
        log ("skippedEntity", "name="+name);
        this.contentHandler.skippedEntity(name);
    }

    private void log(String location, String description) {
        StringBuffer logEntry = new StringBuffer();
        logEntry.append(id);
        logEntry.append("[");
        logEntry.append(location);
        logEntry.append("] ");
        logEntry.append(description);
        logEntry.append("\n");
        getLogger().debug(logEntry.toString());
        // System.out.print(logEntry.toString());
    }
}
