/*

 ============================================================================
                   The Apache Software License, Version 1.1
 ============================================================================

 Copyright (C) 1999-2003 The Apache Software Foundation. All rights reserved.

 Redistribution and use in source and binary forms, with or without modifica-
 tion, are permitted provided that the following conditions are met:

 1. Redistributions of  source code must  retain the above copyright  notice,
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

 3. The end-user documentation included with the redistribution, if any, must
    include  the following  acknowledgment:  "This product includes  software
    developed  by the  Apache Software Foundation  (http://www.apache.org/)."
    Alternately, this  acknowledgment may  appear in the software itself,  if
    and wherever such third-party acknowledgments normally appear.

 4. The names "Apache Cocoon" and  "Apache Software Foundation" must  not  be
    used to  endorse or promote  products derived from  this software without
    prior written permission. For written permission, please contact
    apache@apache.org.

 5. Products  derived from this software may not  be called "Apache", nor may
    "Apache" appear  in their name,  without prior written permission  of the
    Apache Software Foundation.

 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS  FOR A PARTICULAR  PURPOSE ARE  DISCLAIMED.  IN NO  EVENT SHALL  THE
 APACHE SOFTWARE  FOUNDATION  OR ITS CONTRIBUTORS  BE LIABLE FOR  ANY DIRECT,
 INDIRECT, INCIDENTAL, SPECIAL,  EXEMPLARY, OR CONSEQUENTIAL  DAMAGES (INCLU-
 DING, BUT NOT LIMITED TO, PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS
 OF USE, DATA, OR  PROFITS; OR BUSINESS  INTERRUPTION)  HOWEVER CAUSED AND ON
 ANY  THEORY OF LIABILITY,  WHETHER  IN CONTRACT,  STRICT LIABILITY,  OR TORT
 (INCLUDING  NEGLIGENCE OR  OTHERWISE) ARISING IN  ANY WAY OUT OF THE  USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 This software  consists of voluntary contributions made  by many individuals
 on  behalf of the Apache Software  Foundation and was  originally created by
 Stefano Mazzocchi  <stefano@apache.org>. For more  information on the Apache
 Software Foundation, please see <http://www.apache.org/>.

*/
package org.apache.cocoon.components.xpointer;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

/**
 * Partly implementation of the xpointer() scheme. Only the XPath subset of xpointer is supported.
 */
public class XPointerPart implements PointerPart {
    private String expression;

    public XPointerPart(String expression) {
        this.expression = expression;
    }

    public boolean process(XPointerContext xpointerContext) throws SAXException {
        Document document = xpointerContext.getDocument();
        ComponentManager manager = xpointerContext.getComponentManager();
        XPathProcessor xpathProcessor = null;
        try {
            try {
                xpathProcessor = (XPathProcessor)manager.lookup(XPathProcessor.ROLE);
            } catch (Exception e) {
                throw new SAXException("XPointerPart: error looking up XPathProcessor.", e);
            }
            NodeList nodeList = xpathProcessor.selectNodeList(document, expression, xpointerContext);
            if (nodeList.getLength() > 0) {
                XMLConsumer consumer = xpointerContext.getXmlConsumer();
                LocatorImpl locator = new LocatorImpl();
                locator.setSystemId(xpointerContext.getSource().getURI());
                consumer.setDocumentLocator(locator);
                for (int i = 0; i < nodeList.getLength(); i++) {
                    DOMStreamer streamer = new DOMStreamer();
                    streamer.setConsumer(consumer);
                    streamer.stream(nodeList.item(i));
                }
                return true;
            } else {
                if (xpointerContext.getLogger().isDebugEnabled())
                    xpointerContext.getLogger().debug("XPointer: expression \"" + expression + "\" gave no results.");
                return false;
            }
        } finally {
            if (xpathProcessor != null)
                manager.release((Component)xpathProcessor);
        }
    }
}
