/*

 ============================================================================
                   The Apache Software License, Version 1.1
 ============================================================================

 Copyright (C) 1999-2003 The Apache Software Foundation. All rights reserved.

 Redistribution and use in source and binary forms, with or without modifica-
 tion, are permitted provided that the following conditions are met:

 1. Redistributions of  source code must  retain the above copyright  notice,
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

 3. The end-user documentation included with the redistribution, if any, must
    include  the following  acknowledgment:  "This product includes  software
    developed  by the  Apache Software Foundation  (http://www.apache.org/)."
    Alternately, this  acknowledgment may  appear in the software itself,  if
    and wherever such third-party acknowledgments normally appear.

 4. The names "Apache Cocoon" and  "Apache Software Foundation" must  not  be
    used to  endorse or promote  products derived from  this software without
    prior written permission. For written permission, please contact
    apache@apache.org.

 5. Products  derived from this software may not  be called "Apache", nor may
    "Apache" appear  in their name,  without prior written permission  of the
    Apache Software Foundation.

 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS  FOR A PARTICULAR  PURPOSE ARE  DISCLAIMED.  IN NO  EVENT SHALL  THE
 APACHE SOFTWARE  FOUNDATION  OR ITS CONTRIBUTORS  BE LIABLE FOR  ANY DIRECT,
 INDIRECT, INCIDENTAL, SPECIAL,  EXEMPLARY, OR CONSEQUENTIAL  DAMAGES (INCLU-
 DING, BUT NOT LIMITED TO, PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS
 OF USE, DATA, OR  PROFITS; OR BUSINESS  INTERRUPTION)  HOWEVER CAUSED AND ON
 ANY  THEORY OF LIABILITY,  WHETHER  IN CONTRACT,  STRICT LIABILITY,  OR TORT
 (INCLUDING  NEGLIGENCE OR  OTHERWISE) ARISING IN  ANY WAY OUT OF THE  USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 This software  consists of voluntary contributions made  by many individuals
 on  behalf of the Apache Software  Foundation and was  originally created by
 Stefano Mazzocchi  <stefano@apache.org>. For more  information on the Apache
 Software Foundation, please see <http://www.apache.org/>.

*/
package org.apache.cocoon.caching;

import org.apache.excalibur.source.SourceValidity;

/**
 * A CacheValidity object wrapping the Avalon Excalibur
 * <code>SourceValidity</code> object.
 *
 * @since 2.1
 * @deprecated Use the Avalon Excalibur SourceValidity implementations instead
 * @author <a href="mailto:cziegeler@apache.org">Carsten Ziegeler</a>
 * @version CVS $Id: CacheValidityToSourceValidity.java,v 1.2 2003/10/21 10:28:47 cziegeler Exp $
 */
public final class CacheValidityToSourceValidity
implements SourceValidity {

    protected CacheValidity cacheValidity;

    /**
     * Create a new instance
     */
    public static CacheValidityToSourceValidity createValidity(CacheValidity validity) {
        if ( null != validity) {
            return new CacheValidityToSourceValidity(validity);
        }
        return null;
    }

    /**
     * Constructor
     */
    protected CacheValidityToSourceValidity(CacheValidity validity) {
        this.cacheValidity = validity;
    }


    /**
     * Check if the component is still valid.
     * If <code>0</code> is returned the isValid(SourceValidity) must be
     * called afterwards!
     * If -1 is returned, the component is not valid anymore and if +1
     * is returnd, the component is valid.
     */
    public int isValid() {
        return 0;
    }

    /**
     * Check if the component is still valid.
     * This is only true, if the incoming Validity is of the same
     * type and has the same values.
     * The invocation order is that the isValid method of the
     * old Validity object is called with the new one as a parameter
     */
    public int isValid( SourceValidity newValidity ) {
        if (newValidity instanceof CacheValidityToSourceValidity) {
            if (this.cacheValidity.isValid(((CacheValidityToSourceValidity)newValidity).cacheValidity)) {
                return 1;
            }
            return -1;
        }
        return -1;
    }

    public String toString() {
        return "Cache Validity To Source Validity[" + this.cacheValidity + ']';
    }
}
