/*

 ============================================================================
                   The Apache Software License, Version 1.1
 ============================================================================

 Copyright (C) 1999-2003 The Apache Software Foundation. All rights reserved.

 Redistribution and use in source and binary forms, with or without modifica-
 tion, are permitted provided that the following conditions are met:

 1. Redistributions of  source code must  retain the above copyright  notice,
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

 3. The end-user documentation included with the redistribution, if any, must
    include  the following  acknowledgment:  "This product includes  software
    developed  by the  Apache Software Foundation  (http://www.apache.org/)."
    Alternately, this  acknowledgment may  appear in the software itself,  if
    and wherever such third-party acknowledgments normally appear.

 4. The names "Apache Cocoon" and  "Apache Software Foundation" must  not  be
    used to  endorse or promote  products derived from  this software without
    prior written permission. For written permission, please contact
    apache@apache.org.

 5. Products  derived from this software may not  be called "Apache", nor may
    "Apache" appear  in their name,  without prior written permission  of the
    Apache Software Foundation.

 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS  FOR A PARTICULAR  PURPOSE ARE  DISCLAIMED.  IN NO  EVENT SHALL  THE
 APACHE SOFTWARE  FOUNDATION  OR ITS CONTRIBUTORS  BE LIABLE FOR  ANY DIRECT,
 INDIRECT, INCIDENTAL, SPECIAL,  EXEMPLARY, OR CONSEQUENTIAL  DAMAGES (INCLU-
 DING, BUT NOT LIMITED TO, PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS
 OF USE, DATA, OR  PROFITS; OR BUSINESS  INTERRUPTION)  HOWEVER CAUSED AND ON
 ANY  THEORY OF LIABILITY,  WHETHER  IN CONTRACT,  STRICT LIABILITY,  OR TORT
 (INCLUDING  NEGLIGENCE OR  OTHERWISE) ARISING IN  ANY WAY OUT OF THE  USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 This software  consists of voluntary contributions made  by many individuals
 on  behalf of the Apache Software  Foundation and was  originally created by
 Stefano Mazzocchi  <stefano@apache.org>. For more  information on the Apache
 Software Foundation, please see <http://www.apache.org/>.

*/
package org.apache.cocoon.components.xmlform;

import org.apache.avalon.framework.CascadingRuntimeException;

import org.w3c.dom.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/**
 * A sample domain object used as a Form model.
 * Notice that it has mixed content:
 * JavaBean properties and
 * DOM Nodes, which are handled correctly by the
 * framework when referenced via XPath.
 *
 * @version CVS $Id: TestBean.java,v 1.2 2003/04/26 12:09:44 stephan Exp $
 */
public class TestBean {
    private int count = 1;
    private short numInstalls = 1;
    private String liveUrl = "http://";
    private boolean publish = true;
    private List favorites = new ArrayList();

    private boolean hidden = false;

    private Node system;

    public TestBean() {
        initSystem();
        initFavorites();
    }

    public String getLiveUrl() {
        return liveUrl;
    }

    public void setLiveUrl(String newUrl) {
        liveUrl = newUrl;
    }

    public short getNumber() {
        return numInstalls;
    }

    public void setNumber(short num) {
        numInstalls = num;
    }

    public boolean getPublish() {
        return publish;
    }

    public void setPublish(boolean newPublish) {
        publish = newPublish;
    }

    public Node getSystem() {
        return system;
    }

    public void setSystem(Node newSystem) {
        system = newSystem;
    }

    public boolean getHidden() {
        return hidden;
    }

    public void setHidden(boolean newHidden) {
        hidden = newHidden;
    }

    public int getCount() {
        return count;
    }

    public void incrementCount() {
        count++;
    }

    public List getFavorite() {
        return favorites;
    }

    public void setFavorite(List newFavorites) {
        favorites = newFavorites;
    }

    public void initSystem() {
        DOMImplementation impl;

        try {
            // Find the implementation
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

            factory.setNamespaceAware(false);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();

            impl = builder.getDOMImplementation();
        } catch (Exception ex) {
            throw new CascadingRuntimeException("Failed to initialize DOM factory.",
                                                ex);
        }

        // initialize system as dom node
        Document doc = impl.createDocument(null,
                                           "XMLForm_Wizard_System_Node",
                                           null);
        Node rootElement = doc.getDocumentElement();

        Node os = doc.createElement("os");
        Text text = doc.createTextNode("Linux");

        os.appendChild(text);
        rootElement.appendChild(os);

        Node processor = doc.createElement("processor");

        text = doc.createTextNode("p4");
        processor.appendChild(text);
        rootElement.appendChild(processor);

        Attr ram = doc.createAttribute("ram");

        ram.setValue("512");
        NamedNodeMap nmap = rootElement.getAttributes();

        nmap.setNamedItem(ram);

        Node servletEngine = doc.createElement("servletEngine");

        text = doc.createTextNode("Tomcat");
        servletEngine.appendChild(text);
        rootElement.appendChild(servletEngine);

        Node javaVersion = doc.createElement("javaVersion");

        text = doc.createTextNode("1.3");
        javaVersion.appendChild(text);
        rootElement.appendChild(javaVersion);

        system = rootElement;

    }

    public void initFavorites() {
        favorites.add("http://cocoon.apache.org");
        favorites.add("http://jakarta.apache.org");
        favorites.add("http://www.google.com");
        favorites.add("http://www.slashdot.org");
        favorites.add("http://www.yahoo.com");
    }

}
