<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:lex="http://chaperon.sourceforge.net/schema/lexemes/1.0">

 <xsl:output indent="no"/>

 <xsl:param name="package"/>
 <xsl:param name="class"/>

 <xsl:param name="prefix">cocoon/samples/chaperon/</xsl:param>

 <xsl:template match="/">
  <html>
   <head>
    <title>Java2HTML</title>
    <link rel="stylesheet" type="text/css" href="java.css" title="Style"/>
   </head>
   <body>

    <table>
     <tr>
      <td align="left" valign="top">
       <p>
       <table width="100%" cellpadding="3" cellspacing="0" class="view">
        <tr>
         <td valign="top" class="headerTitle">
          <b>Packages</b>
         </td>
        </tr>
        <tr>
         <td class="headerRight">
          <xsl:apply-templates select="packages/package"/>
         </td>
        </tr>
       </table>
       </p>
       <p>
       <table width="100%" cellpadding="3" cellspacing="0" class="view">
        <tr>
         <td valign="top" class="headerTitle">
          <b>Classes</b>
         </td>
        </tr>
        <tr>
         <td class="headerRight">
          <xsl:apply-templates select="packages/classes/class"/>
         </td>
        </tr>
       </table>
       </p>
      </td>
      <td width="100%" align="left" valign="top">

       <p>
        <table width="100%" cellpadding="3" cellspacing="0" class="view">
         <tr>
          <td valign="top" class="headerTitle">
           <font class="current">Package</font>&#160;&#160;&#160;
           <b>Class</b>&#160;&#160;&#160;
           <b>File</b>
          </td>
         </tr>
        </table>
       </p>

       <p>
        <table width="100%" cellpadding="3" cellspacing="0" class="view">
         <tr>
          <td class="headerTitle" colspan="2"><b><nobr>&#160;Package <xsl:value-of select="translate($package,'/','.')"/>&#160;</nobr></b></td>
         </tr>
         <tr>
          <td class="headerLeft">
           Classes
          </td>
          <td class="headerRight">
           Description
          </td>
         </tr>
         <xsl:apply-templates select="packages/package[@full=translate($package,'/','.')]/class" mode="overview"/>
        </table>
       </p>

      </td>
     </tr>
    </table>

    <p>
     <table width="100%">
      <tr><td class="hbreak" colspan="6">&#160;</td></tr>
      <tr>
       <td class="footer" colspan="6">
        <table>
         <tr>
          <td>
           <i>Generated by</i>
           <a target="_new" href="http://chaperon.sourceforge.net">Chaperon</a>.
          </td>
          <td>&#160;</td>
          <td style="BORDER-LEFT: #9c9c9c 1px solid;">&#160;</td>
          <td>&#160;</td>
         </tr>
        </table>
       </td>
      </tr>
     </table>
    </p>

   </body>
  </html>
 </xsl:template>

 <xsl:template match="package">
  <a href="/{$prefix}{translate(@full,'.','/')}/index.html"><xsl:value-of select="@full"/></a><br/>
 </xsl:template>

 <xsl:template match="class">
  <a href="/{$prefix}{translate(@full,'.','/')}.java.html"><xsl:value-of select="@name"/></a><br/>
 </xsl:template>

 <xsl:template match="class" mode="overview">
  <tr>
   <td class="itemLeft">
    <a href="/{$prefix}{translate(@full,'.','/')}.java.html"><xsl:value-of select="@name"/></a>
   </td>
   <td class="itemRight">
    &#160;<br/>
   </td>
  </tr>
 </xsl:template>

</xsl:stylesheet>
