/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.transaction;

import java.util.HashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.otm.OTMConnection;
import org.apache.ojb.otm.core.BaseConnection;
import org.apache.ojb.otm.core.TransactionException;
import org.apache.ojb.otm.transaction.TransactionFactory;
import org.apache.ojb.otm.transaction.TransactionFactoryException;

public abstract class ManagedTransactionFactory
implements TransactionFactory {
    private HashMap _transactionMap = new HashMap();

    public org.apache.ojb.otm.core.Transaction getTransactionForConnection(OTMConnection oTMConnection) {
        if (!(oTMConnection instanceof BaseConnection)) {
            throw new TransactionFactoryException("Unknown connection type");
        }
        BaseConnection baseConnection = (BaseConnection)oTMConnection;
        Transaction transaction = this.getJTATransaction();
        if (transaction == null) {
            throw new TransactionFactoryException("Unable to get the JTA Transaction");
        }
        org.apache.ojb.otm.core.Transaction transaction2 = (org.apache.ojb.otm.core.Transaction)this._transactionMap.get(transaction);
        if (transaction2 == null) {
            transaction2 = new org.apache.ojb.otm.core.Transaction();
            this._transactionMap.put(transaction, transaction2);
        }
        transaction2.registerConnection(baseConnection);
        return transaction2;
    }

    public OTMConnection acquireConnection(PBKey pBKey) {
        return new ManagedConnection(pBKey);
    }

    public Transaction getJTATransaction() {
        try {
            TransactionManager transactionManager = this.getJTATransactionManager();
            return transactionManager.getTransaction();
        }
        catch (SystemException systemException) {
            throw new TransactionFactoryException("Error acquiring JTA Transaction", systemException);
        }
    }

    public abstract TransactionManager getJTATransactionManager();

    private static class ManagedConnection
    extends BaseConnection {
        public ManagedConnection(PBKey pBKey) {
            super(pBKey);
        }

        public void transactionBegin() throws TransactionException {
        }

        public void transactionPrepare() throws TransactionException {
        }

        public void transactionCommit() throws TransactionException {
        }

        public void transactionRollback() throws TransactionException {
        }
    }
}

