/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.VirtualProxy;
import org.apache.ojb.broker.accesslayer.CollectionProxy;
import org.apache.ojb.broker.accesslayer.CollectionProxyListener;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.accesslayer.IndirectionHandler;
import org.apache.ojb.broker.accesslayer.MaterializationListener;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.ArrayIterator;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.otm.EditingContext;
import org.apache.ojb.otm.OTMKit;
import org.apache.ojb.otm.copy.ObjectCopyStrategy;
import org.apache.ojb.otm.core.LockingPassthruException;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.core.TransactionAbortedException;
import org.apache.ojb.otm.lock.LockManager;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.states.State;
import org.apache.ojb.otm.swizzle.Swizzling;

public class ConcreteEditingContext
implements EditingContext,
MaterializationListener,
ObjectCache {
    private static HashMap _withBidirAsscMap = new HashMap();
    private static HashMap _withoutBidirAsscMap = new HashMap();
    private HashSet _withBidirAssc;
    private HashSet _withoutBidirAssc;
    private HashMap _objects;
    private ArrayList _order;
    private Transaction _tx;
    private PersistenceBroker _pb;
    private HashMap _original;
    private HashMap _checkpointed;
    private HashMap _colProxyListeners;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;

    public ConcreteEditingContext(Transaction transaction, PersistenceBroker persistenceBroker) {
        this._tx = transaction;
        this._pb = persistenceBroker;
        this._objects = new HashMap();
        this._order = new ArrayList();
        this._original = new HashMap();
        this._checkpointed = this._original;
        PBKey pBKey = this._pb.getPBKey();
        this._withoutBidirAssc = (HashSet)_withoutBidirAsscMap.get(pBKey);
        if (this._withoutBidirAssc != null) {
            this._withBidirAssc = (HashSet)_withBidirAsscMap.get(pBKey);
        } else {
            this._withoutBidirAssc = new HashSet();
            _withoutBidirAsscMap.put(pBKey, this._withoutBidirAssc);
            this._withBidirAssc = new HashSet();
            _withBidirAsscMap.put(pBKey, this._withBidirAssc);
        }
    }

    public void insert(Identity identity, Object object, int n) throws LockingException {
        this.insertInternal(identity, object, n, true, false);
    }

    private ContextEntry insertInternal(Identity identity, Object object, int n, boolean bl, boolean bl2) throws LockingException {
        IndirectionHandler indirectionHandler = null;
        OTMKit oTMKit = this._tx.getKit();
        if (n == 0) {
            return null;
        }
        ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
        LockManager lockManager = LockManager.getInstance();
        Swizzling swizzling = oTMKit.getSwizzlingStrategy();
        if (object != null && (indirectionHandler = ConcreteEditingContext.getIndirectionHandler(object)) != null && indirectionHandler.alreadyMaterialized()) {
            object = indirectionHandler.getRealSubject();
            indirectionHandler = null;
        }
        if (contextEntry == null) {
            lockManager.ensureLock(identity, this._tx, n, this._pb);
            Object object2 = swizzling.swizzle(object, null, this._pb, this);
            contextEntry = new ContextEntry(object2);
            if (contextEntry.handler != null) {
                contextEntry.handler.addListener(this);
            } else {
                Object object3;
                if (!bl && !bl2 || oTMKit.isInsertVerified()) {
                    object3 = this._pb.getObjectByIdentity(identity);
                } else {
                    ObjectCache objectCache = this._pb.serviceObjectCache();
                    object3 = objectCache.lookup(identity);
                }
                if (object3 == null) {
                    if (bl || bl2) {
                        contextEntry.state = State.PERSISTENT_NEW;
                        if (oTMKit.isEagerInsert(object) || this.hasBidirectionalAssociation(object.getClass())) {
                            this._pb.store(object, contextEntry.state);
                            contextEntry.state = State.PERSISTENT_CLEAN;
                            object3 = object;
                        }
                    } else {
                        return null;
                    }
                }
                if (object3 != null) {
                    this._original.put(identity, this.getFields(object3, false, true));
                }
            }
            this._objects.put(identity, contextEntry);
            this._order.add(identity);
        } else {
            Object object4 = contextEntry.object;
            lockManager.ensureLock(identity, this._tx, n, this._pb);
            if (indirectionHandler == null) {
                if (!swizzling.isSameInstance(object4, object)) {
                    if (contextEntry.handler != null) {
                        object4 = contextEntry.handler.getRealSubject();
                        contextEntry.handler = null;
                    }
                    contextEntry.object = swizzling.swizzle(object, object4, this._pb, this);
                }
            } else if (contextEntry.object == null) {
                contextEntry.object = object;
                contextEntry.handler = indirectionHandler;
                contextEntry.handler.addListener(this);
            }
        }
        if (indirectionHandler == null && object != null) {
            this.lockReachableObjects(object, n);
        }
        return contextEntry;
    }

    public void remove(Identity identity) {
        this._objects.remove(identity);
        this._order.remove(identity);
    }

    public void deletePersistent(Identity identity, Object object) throws LockingException {
        ContextEntry contextEntry = this.insertInternal(identity, object, 2, true, false);
        if (contextEntry != null) {
            contextEntry.state = contextEntry.state.deletePersistent();
        }
        this._order.remove(identity);
        this._order.add(identity);
    }

    public Object lookup(Identity identity) {
        ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
        return contextEntry == null ? null : contextEntry.object;
    }

    public State lookupState(Identity identity) throws LockingException {
        State state = null;
        ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
        if (contextEntry != null) {
            state = contextEntry.state;
        }
        return state;
    }

    public void setState(Identity identity, State state) {
        ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
        contextEntry.state = state;
    }

    public Collection getAllObjectsInContext() {
        return this._objects.values();
    }

    public void beforeMaterialization(IndirectionHandler indirectionHandler, Identity identity) {
    }

    public void afterMaterialization(IndirectionHandler indirectionHandler, Object object) {
        boolean bl;
        Identity identity = indirectionHandler.getIdentity();
        ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
        if (contextEntry == null) {
            return;
        }
        int n = LockManager.getInstance().getLockHeld(identity, this._tx);
        boolean bl2 = bl = n != 2 || !this._tx.getKit().isImplicitLockingUsed();
        if (bl) {
            ObjectCopyStrategy objectCopyStrategy = this._tx.getKit().getCopyStrategy(identity);
            object = objectCopyStrategy.copy(object);
            indirectionHandler.setRealSubject(object);
        }
        this._original.put(identity, this.getFields(object, false, true));
        contextEntry.object = object;
        contextEntry.handler.removeListener(this);
        contextEntry.handler = null;
        try {
            this.lockReachableObjects(object, n);
        }
        catch (LockingException lockingException) {
            throw new LockingPassthruException(lockingException);
        }
    }

    public void commit() throws TransactionAbortedException {
        this.checkpointInternal(true);
        this.releaseLocksAndClear();
    }

    private void releaseLocksAndClear() {
        this.releaseLocks();
        this.removeMaterializationListener();
        this._objects.clear();
        this._order.clear();
        this._original.clear();
        if (this._checkpointed != this._original) {
            this._checkpointed.clear();
        }
    }

    public void checkpoint() throws TransactionAbortedException {
        this.checkpointInternal(false);
        this._checkpointed = new HashMap();
        Iterator iterator = this._order.iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
            this._checkpointed.put(identity, this.getFields(contextEntry.object, false, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpointInternal(boolean bl) throws TransactionAbortedException {
        if (this._order.size() == 0) {
            return;
        }
        this.removeCollectionProxyListeners();
        ConnectionManagerIF connectionManagerIF = this._pb.serviceConnectionManager();
        boolean bl2 = connectionManagerIF.isBatchMode();
        Swizzling swizzling = this._tx.getKit().getSwizzlingStrategy();
        LockManager lockManager = LockManager.getInstance();
        Identity[] identityArray = this._order.toArray(new Identity[this._order.size()]);
        ObjectCache objectCache = this._pb.serviceObjectCache();
        boolean bl3 = this._tx.getKit().isInsertVerified();
        ArrayList<Identity> arrayList = new ArrayList<Identity>();
        Arrays.sort(identityArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return object.hashCode() - object2.hashCode();
            }

            public boolean equals(Object object) {
                return false;
            }
        });
        try {
            int n;
            int n2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n3;
            ArrayList arrayList2 = new ArrayList();
            do {
                arrayList2.clear();
                n3 = 0;
                for (int i = 0; i < identityArray.length; ++i) {
                    Identity identity = identityArray[i];
                    object4 = (ContextEntry)this._objects.get(identity);
                    object3 = ((ContextEntry)object4).state;
                    if (((ContextEntry)object4).object == null || ((ContextEntry)object4).handler != null || ((State)object3).needsDelete()) continue;
                    object2 = (Object[][])this._checkpointed.get(identity);
                    object = this.getFields(((ContextEntry)object4).object, true, !bl);
                    if (object2 == null) {
                        arrayList2.addAll(this.handleDependentReferences(((ContextEntry)object4).object, null, object[0], object[2]));
                        arrayList2.addAll(this.handleDependentCollections(((ContextEntry)object4).object, null, (Object[])object[1], (Object[])object[3]));
                        continue;
                    }
                    if (this.isModified(object2[0], object[0])) {
                        ((ContextEntry)object4).state = ((State)object3).markDirty();
                        ((ContextEntry)object4).needsCacheSwizzle = true;
                        lockManager.ensureLock(identity, this._tx, 2, this._pb);
                        arrayList2.addAll(this.handleDependentReferences(((ContextEntry)object4).object, object2[0], (Object[])object[0], (Object[])object[2]));
                    }
                    if (!this.isModified(object2[1], object[1])) continue;
                    ((ContextEntry)object4).needsCacheSwizzle = !((State)object3).needsInsert();
                    lockManager.ensureLock(identity, this._tx, 2, this._pb);
                    arrayList2.addAll(this.handleDependentCollections(((ContextEntry)object4).object, object2[1], (Object[])object[1], (Object[])object[3]));
                    arrayList.add(identity);
                }
                n3 = arrayList2.size();
                if (n3 <= 0) continue;
                identityArray = arrayList2.toArray(new Identity[n3]);
            } while (n3 > 0);
            Identity[] identityArray2 = this._order.toArray(new Identity[this._order.size()]);
            for (n2 = 0; n2 < identityArray2.length; ++n2) {
                object4 = identityArray2[n2];
                object3 = (ContextEntry)this._objects.get(object4);
                if (!((ContextEntry)object3).needsCacheSwizzle) continue;
                object2 = objectCache.lookup((Identity)object4);
                ((ContextEntry)object3).object = swizzling.getRealTarget(((ContextEntry)object3).object);
                if (object2 != null && !swizzling.isSameInstance(((ContextEntry)object3).object, object2)) {
                    ((ContextEntry)object3).object = swizzling.swizzle(((ContextEntry)object3).object, object2, this._pb, objectCache);
                    if (((ContextEntry)object3).object != object2) {
                        objectCache.cache((Identity)object4, ((ContextEntry)object3).object);
                    }
                }
                ((ContextEntry)object3).needsCacheSwizzle = false;
            }
            do {
                n2 = 0;
                for (n = 0; n < identityArray2.length; ++n) {
                    object3 = identityArray2[n];
                    object2 = (ContextEntry)this._objects.get(object3);
                    if (!object2.state.needsDelete()) continue;
                    n2 += this.doCascadeDelete(object2.object);
                }
            } while (n2 > 0);
            connectionManagerIF.setBatchMode(true);
            try {
                for (n = 0; n < identityArray2.length; ++n) {
                    object3 = identityArray2[n];
                    object2 = (ContextEntry)this._objects.get(object3);
                    object = object2.state;
                    if (!(((State)object).needsInsert() || ((State)object).needsUpdate() || ((State)object).needsDelete())) {
                        if (!arrayList.contains(object3)) continue;
                        this._pb.store(object2.object, (ObjectModification)object);
                        continue;
                    }
                    if (((State)object).needsInsert()) {
                        if (bl3) {
                            this._pb.store(object2.object);
                        } else if (objectCache.lookup((Identity)object3) == null) {
                            this._pb.store(object2.object, (ObjectModification)object);
                        }
                    } else if (((State)object).needsUpdate()) {
                        this._pb.store(object2.object, (ObjectModification)object);
                    } else if (((State)object).needsDelete()) {
                        this._pb.delete(object2.object);
                    }
                    object2.state = ((State)object).commit();
                }
                connectionManagerIF.executeBatch();
            }
            finally {
                connectionManagerIF.setBatchMode(bl2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new TransactionAbortedException(throwable);
        }
    }

    public void rollback() {
        Iterator iterator = this._order.iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
            contextEntry.state = contextEntry.state.rollback();
            Object[][] objectArray = (Object[][])this._original.get(identity);
            if (objectArray == null) continue;
            this.setFields(contextEntry.object, objectArray);
        }
        this.releaseLocksAndClear();
    }

    private static IndirectionHandler getIndirectionHandler(Object object) {
        if (Proxy.isProxyClass(object.getClass())) {
            return (IndirectionHandler)Proxy.getInvocationHandler(object);
        }
        if (object instanceof VirtualProxy) {
            return VirtualProxy.getIndirectionHandler((VirtualProxy)object);
        }
        return null;
    }

    private void removeMaterializationListener() {
        Iterator iterator = this._order.iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            ContextEntry contextEntry = (ContextEntry)this._objects.get(identity);
            if (contextEntry.handler == null) continue;
            contextEntry.handler.removeListener(this);
        }
    }

    private void removeCollectionProxyListeners() {
        if (this._colProxyListeners != null) {
            Iterator iterator = this._colProxyListeners.keySet().iterator();
            while (iterator.hasNext()) {
                CollectionProxyListener collectionProxyListener = (CollectionProxyListener)iterator.next();
                CollectionProxy collectionProxy = (CollectionProxy)this._colProxyListeners.get(collectionProxyListener);
                collectionProxy.removeListener(collectionProxyListener);
            }
            this._colProxyListeners.clear();
        }
    }

    private void lockReachableObjects(Object object, int n) throws LockingException {
        Object object2;
        Identity identity;
        PersistentField persistentField;
        boolean bl;
        boolean bl2 = !this._tx.getKit().isImplicitLockingUsed();
        ClassDescriptor classDescriptor = this._pb.getClassDescriptor(object.getClass());
        Iterator iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
        ObjectReferenceDescriptor objectReferenceDescriptor = null;
        Object object3 = null;
        while (iterator.hasNext()) {
            objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            bl = objectReferenceDescriptor.getOtmDependent();
            if (bl2 && !bl || (object3 = (persistentField = objectReferenceDescriptor.getPersistentField()).get(object)) == null) continue;
            identity = new Identity(object3, this._pb);
            object2 = this.lookup(identity);
            if (object2 == null) {
                this.insertInternal(identity, object3, n, false, bl);
                continue;
            }
            if (object2 == object3) continue;
            persistentField.set(object, object2);
        }
        Iterator iterator2 = classDescriptor.getCollectionDescriptors().iterator();
        while (iterator2.hasNext()) {
            ArrayIterator arrayIterator;
            Object object4;
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator2.next();
            persistentField = collectionDescriptor.getPersistentField();
            Class clazz = persistentField.getType();
            bl = collectionDescriptor.getOtmDependent();
            if (bl2 && !bl || (object4 = persistentField.get(object)) == null || object4 instanceof CollectionProxy && !((CollectionProxy)object4).isLoaded()) continue;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl3 = false;
            if ((class$java$util$Collection == null ? ConcreteEditingContext.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(clazz)) {
                arrayIterator = ((Collection)object4).iterator();
            } else if (clazz.isArray()) {
                arrayIterator = new ArrayIterator(object4);
            } else {
                throw new OJBRuntimeException(object4.getClass() + " can not be managed by OJB OTM, use Array or Collection instead !");
            }
            while (arrayIterator.hasNext()) {
                object3 = arrayIterator.next();
                identity = new Identity(object3, this._pb);
                object2 = this.lookup(identity);
                if (object2 == null) {
                    this.insertInternal(identity, object3, n, false, bl);
                    object2 = object3;
                } else if (object2 != object3) {
                    bl3 = true;
                }
                arrayList.add(object2);
            }
            if (!bl3) continue;
            this.setCollectionField(object, persistentField, arrayList);
        }
    }

    private void releaseLocks() {
        LockManager lockManager = LockManager.getInstance();
        Iterator iterator = this._objects.keySet().iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            lockManager.releaseLock(identity, this._tx);
        }
    }

    private boolean isEqual(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == object2;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).compareTo(object2) == 0;
        }
        if (object instanceof Date && object2 instanceof Date) {
            return ((Date)object).getTime() == ((Date)object2).getTime();
        }
        return object.equals(object2);
    }

    private boolean isModified(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            return true;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.isEqual(objectArray[i], objectArray2[i])) continue;
            return true;
        }
        return false;
    }

    private Object[][] getFields(Object object, boolean bl, boolean bl2) {
        Object object2;
        PersistentField persistentField;
        Serializable serializable;
        Iterator iterator;
        int n;
        ClassDescriptor classDescriptor = this._pb.getClassDescriptor(object.getClass());
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        Vector vector2 = classDescriptor.getCollectionDescriptors();
        int n2 = 0;
        Object[] objectArray = new Object[1 + fieldDescriptorArray.length + vector.size()];
        ArrayList[] arrayListArray = new ArrayList[vector2.size()];
        Object[] objectArray2 = null;
        ArrayList[] arrayListArray2 = null;
        int n3 = 0;
        if (bl) {
            objectArray2 = new Object[vector.size()];
            arrayListArray2 = new ArrayList[vector2.size()];
        }
        if (bl2) {
            n3 = LockManager.getInstance().getLockHeld(new Identity(object, this._pb), this._tx);
        }
        objectArray[0] = object.getClass();
        ++n2;
        for (n = 0; n < fieldDescriptorArray.length; ++n) {
            iterator = fieldDescriptorArray[n];
            serializable = ((AttributeDescriptorBase)((Object)iterator)).getPersistentField();
            objectArray[n2] = serializable.get(object);
            ++n2;
        }
        n = 0;
        iterator = vector.iterator();
        while (iterator.hasNext()) {
            serializable = (ObjectReferenceDescriptor)iterator.next();
            persistentField = ((AttributeDescriptorBase)serializable).getPersistentField();
            object2 = persistentField.get(object);
            if (object2 != null) {
                objectArray[n2] = new Identity(object2, this._pb);
                if (bl) {
                    objectArray2[n] = object2;
                }
            }
            ++n2;
            ++n;
        }
        n2 = 0;
        iterator = vector2.iterator();
        while (iterator.hasNext()) {
            block16: {
                ArrayIterator arrayIterator;
                ArrayList arrayList;
                Object object3;
                block18: {
                    Object object4;
                    block17: {
                        block15: {
                            serializable = (CollectionDescriptor)iterator.next();
                            persistentField = ((AttributeDescriptorBase)serializable).getPersistentField();
                            object2 = persistentField.getType();
                            object4 = persistentField.get(object);
                            if (object4 == null || !(object4 instanceof CollectionProxy) || ((CollectionProxy)object4).isLoaded()) break block15;
                            if (bl2) {
                                object3 = new OTMCollectionProxyListener((CollectionDescriptor)serializable, arrayListArray, n2, n3);
                                ((CollectionProxy)object4).addListener((CollectionProxyListener)object3);
                                if (this._colProxyListeners == null) {
                                    this._colProxyListeners = new HashMap();
                                }
                                this._colProxyListeners.put(object3, object4);
                            }
                            break block16;
                        }
                        if (object4 == null) break block16;
                        object3 = new ArrayList();
                        arrayList = null;
                        arrayListArray[n2] = object3;
                        if (bl) {
                            arrayListArray2[n2] = arrayList = new ArrayList();
                        }
                        if (!(class$java$util$Collection == null ? ConcreteEditingContext.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom((Class<?>)object2)) break block17;
                        arrayIterator = ((Collection)object4).iterator();
                        break block18;
                    }
                    if (!((Class)object2).isArray()) break block16;
                    arrayIterator = new ArrayIterator(object4);
                }
                while (arrayIterator.hasNext()) {
                    Object e = arrayIterator.next();
                    ((ArrayList)object3).add(new Identity(e, this._pb));
                    if (!bl) continue;
                    arrayList.add(e);
                }
            }
            ++n2;
        }
        return new Object[][]{objectArray, arrayListArray, objectArray2, arrayListArray2};
    }

    private void setFields(Object object, Object[][] objectArray) {
        ArrayList<Object> arrayList;
        Serializable serializable;
        PersistentField persistentField;
        AttributeDescriptorBase attributeDescriptorBase;
        ClassDescriptor classDescriptor = this._pb.getClassDescriptor(object.getClass());
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        Vector vector2 = classDescriptor.getCollectionDescriptors();
        Object[] objectArray2 = objectArray[0];
        ArrayList[] arrayListArray = (ArrayList[])objectArray[1];
        int n = 0;
        if (!objectArray2[0].equals(object.getClass())) {
            System.err.println("Can't restore the object fields since its class changed during transaction from " + objectArray2[0] + " to " + object.getClass());
            return;
        }
        ++n;
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            attributeDescriptorBase = fieldDescriptorArray[i];
            persistentField = attributeDescriptorBase.getPersistentField();
            persistentField.set(object, objectArray2[n]);
            ++n;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            attributeDescriptorBase = (ObjectReferenceDescriptor)iterator.next();
            persistentField = attributeDescriptorBase.getPersistentField();
            serializable = (Identity)objectArray2[n];
            arrayList = serializable == null ? null : this._pb.getObjectByIdentity((Identity)serializable);
            persistentField.set(object, arrayList);
            ++n;
        }
        n = 0;
        iterator = vector2.iterator();
        while (iterator.hasNext()) {
            attributeDescriptorBase = (CollectionDescriptor)iterator.next();
            persistentField = attributeDescriptorBase.getPersistentField();
            serializable = arrayListArray[n];
            if (serializable == null) {
                persistentField.set(object, null);
            } else {
                arrayList = new ArrayList<Object>();
                Iterator iterator2 = ((ArrayList)serializable).iterator();
                while (iterator2.hasNext()) {
                    Identity identity = (Identity)iterator2.next();
                    Object object2 = this._pb.getObjectByIdentity(identity);
                    if (object2 == null) continue;
                    arrayList.add(object2);
                }
                this.setCollectionField(object, persistentField, arrayList);
            }
            ++n;
        }
    }

    private void setCollectionField(Object object, PersistentField persistentField, List list) {
        Class clazz;
        if ((class$java$util$Collection == null ? (class$java$util$Collection = ConcreteEditingContext.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz = persistentField.getType())) {
            Collection collection = (ArrayList)persistentField.get(object);
            if (collection == null) {
                if (clazz == (class$java$util$List == null ? (class$java$util$List = ConcreteEditingContext.class$("java.util.List")) : class$java$util$List) || clazz == (class$java$util$Collection == null ? (class$java$util$Collection = ConcreteEditingContext.class$("java.util.Collection")) : class$java$util$Collection)) {
                    collection = new ArrayList();
                } else if (clazz == (class$java$util$Set == null ? (class$java$util$Set = ConcreteEditingContext.class$("java.util.Set")) : class$java$util$Set)) {
                    collection = new HashSet();
                } else {
                    try {
                        collection = (Collection)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        System.err.println("Cannot instantiate collection field: " + persistentField);
                        exception.printStackTrace();
                        return;
                    }
                }
            } else {
                collection.clear();
            }
            collection.addAll(list);
        } else if (clazz.isArray()) {
            int n = list.size();
            Object object2 = Array.newInstance(clazz.getComponentType(), n);
            for (int i = 0; i < n; ++i) {
                Array.set(object2, i, list.get(i));
            }
            persistentField.set(object, object2);
        }
    }

    private boolean hasBidirectionalAssociation(Class clazz) {
        if (this._withoutBidirAssc.contains(clazz)) {
            return false;
        }
        if (this._withBidirAssc.contains(clazz)) {
            return true;
        }
        ClassDescriptor classDescriptor = this._pb.getClassDescriptor(clazz);
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        boolean bl = false;
        Iterator iterator = vector.iterator();
        block0: while (iterator.hasNext()) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            ClassDescriptor classDescriptor2 = this._pb.getClassDescriptor(objectReferenceDescriptor.getItemClass());
            Vector vector2 = classDescriptor2.getObjectReferenceDescriptors();
            Iterator iterator2 = vector2.iterator();
            while (iterator2.hasNext()) {
                ObjectReferenceDescriptor objectReferenceDescriptor2 = (ObjectReferenceDescriptor)iterator2.next();
                if (!objectReferenceDescriptor2.getItemClass().equals(clazz)) continue;
                bl = true;
                break block0;
            }
        }
        if (bl) {
            this._withBidirAssc.add(clazz);
        } else {
            this._withoutBidirAssc.add(clazz);
        }
        return bl;
    }

    private int markDelete(Object object) {
        ContextEntry contextEntry = (ContextEntry)this._objects.get(object);
        if (contextEntry == null) {
            throw new IllegalStateException("markDelete failed: the dependent object " + object + " is not in the editing context");
        }
        if (contextEntry.state.needsDelete()) {
            return 0;
        }
        contextEntry.state = contextEntry.state.deletePersistent();
        return 1;
    }

    private void markNew(Object object, Object object2) {
        ContextEntry contextEntry = new ContextEntry(object2);
        if (contextEntry.handler != null) {
            throw new IllegalStateException("markNew failed: the dependent object " + object + " is proxy");
        }
        contextEntry.state = State.PERSISTENT_NEW;
        this._objects.put(object, contextEntry);
        this._order.add(object);
    }

    private ArrayList handleDependentReferences(Object object, Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        ClassDescriptor classDescriptor = this._pb.getClassDescriptor(object.getClass());
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        int n = 1 + fieldDescriptorArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ObjectReferenceDescriptor objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            Object object2 = objectArray == null ? null : objectArray[n];
            Object object3 = objectArray2[n];
            if (objectReferenceDescriptor.getOtmDependent()) {
                if (object2 == null && object3 != null) {
                    ContextEntry contextEntry = (ContextEntry)this._objects.get(object3);
                    if (contextEntry == null) {
                        Object object4 = objectArray3[n2];
                        this.markNew(object3, object4);
                        arrayList.add(object3);
                    }
                } else if (object2 != null && object3 == null) {
                    this.markDelete(object2);
                }
            }
            ++n;
            ++n2;
        }
        return arrayList;
    }

    private ArrayList handleDependentCollections(Object object, Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        ClassDescriptor classDescriptor = this._pb.getClassDescriptor(object.getClass());
        Vector vector = classDescriptor.getCollectionDescriptors();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)iterator.next();
            if (collectionDescriptor.getOtmDependent()) {
                Iterator iterator2;
                ArrayList arrayList2 = objectArray == null ? null : (ArrayList)objectArray[n];
                ArrayList arrayList3 = (ArrayList)objectArray2[n];
                if (arrayList2 != null) {
                    Iterator iterator3 = arrayList2.iterator();
                    while (iterator3.hasNext()) {
                        iterator2 = iterator3.next();
                        if (arrayList3.contains(iterator2)) continue;
                        this.markDelete(iterator2);
                    }
                }
                int n2 = 0;
                iterator2 = arrayList3.iterator();
                while (iterator2.hasNext()) {
                    ContextEntry contextEntry;
                    Object e = iterator2.next();
                    if (!(arrayList2 != null && arrayList2.contains(e) || (contextEntry = (ContextEntry)this._objects.get(e)) != null)) {
                        ArrayList arrayList4 = (ArrayList)objectArray3[n];
                        Object e2 = arrayList4.get(n2);
                        this.markNew(e, e2);
                        arrayList.add(e);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList;
    }

    private int doCascadeDelete(Object object) {
        PersistentField persistentField;
        Object object2;
        ObjectReferenceDescriptor objectReferenceDescriptor;
        ClassDescriptor classDescriptor = this._pb.getClassDescriptor(object.getClass());
        Vector vector = classDescriptor.getObjectReferenceDescriptors();
        Vector vector2 = classDescriptor.getCollectionDescriptors();
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
            if (!objectReferenceDescriptor.getOtmDependent() || (object2 = (persistentField = objectReferenceDescriptor.getPersistentField()).get(object)) == null) continue;
            n += this.markDelete(new Identity(object2, this._pb));
        }
        iterator = vector2.iterator();
        while (iterator.hasNext()) {
            ArrayIterator arrayIterator;
            objectReferenceDescriptor = (CollectionDescriptor)iterator.next();
            if (!objectReferenceDescriptor.getOtmDependent()) continue;
            persistentField = objectReferenceDescriptor.getPersistentField();
            object2 = persistentField.getType();
            Object object3 = persistentField.get(object);
            if (object3 == null) continue;
            if ((class$java$util$Collection == null ? ConcreteEditingContext.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom((Class<?>)object2)) {
                arrayIterator = ((Collection)object3).iterator();
            } else {
                if (!((Class)object2).isArray()) continue;
                arrayIterator = new ArrayIterator(object3);
            }
            while (arrayIterator.hasNext()) {
                n += this.markDelete(new Identity(arrayIterator.next(), this._pb));
            }
        }
        return n;
    }

    public void cache(Identity identity, Object object) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class OTMCollectionProxyListener
    implements CollectionProxyListener {
        private final CollectionDescriptor _cds;
        private final ArrayList[] _collections;
        private final int _index;
        private final int _lock;

        OTMCollectionProxyListener(CollectionDescriptor collectionDescriptor, ArrayList[] arrayListArray, int n, int n2) {
            this._cds = collectionDescriptor;
            this._collections = arrayListArray;
            this._index = n;
            this._lock = n2;
        }

        public void beforeLoading(CollectionProxy collectionProxy) {
        }

        public void afterLoading(CollectionProxy collectionProxy) {
            ArrayList<Identity> arrayList = new ArrayList<Identity>();
            ArrayList arrayList2 = new ArrayList();
            LockManager lockManager = LockManager.getInstance();
            boolean bl = this._lock != 2 || !ConcreteEditingContext.this._tx.getKit().isImplicitLockingUsed();
            this._collections[this._index] = arrayList;
            Iterator iterator = collectionProxy.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                Identity identity = new Identity(object, ConcreteEditingContext.this._pb);
                arrayList.add(identity);
                Object v = ConcreteEditingContext.this._objects.get(identity);
                if (v != null) {
                    object = v;
                } else {
                    if (bl) {
                        ObjectCopyStrategy objectCopyStrategy = ConcreteEditingContext.this._tx.getKit().getCopyStrategy(identity);
                        object = objectCopyStrategy.copy(object);
                    }
                    try {
                        ConcreteEditingContext.this.insertInternal(identity, object, this._lock, false, this._cds.getOtmDependent());
                    }
                    catch (LockingException lockingException) {
                        throw new LockingPassthruException(lockingException);
                    }
                }
                arrayList2.add(v);
            }
            collectionProxy.clear();
            collectionProxy.addAll((Collection)arrayList2);
        }
    }

    private static class ContextEntry {
        Object object;
        State state = State.PERSISTENT_CLEAN;
        IndirectionHandler handler;
        boolean needsCacheSwizzle;

        ContextEntry(Object object) {
            this.object = object;
            if (this.object != null) {
                this.handler = ConcreteEditingContext.getIndirectionHandler(this.object);
                if (this.handler != null && this.handler.alreadyMaterialized()) {
                    this.object = this.handler.getRealSubject();
                    this.handler = null;
                }
            }
        }
    }
}

