/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.core;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.VirtualProxy;
import org.apache.ojb.broker.accesslayer.IndirectionHandler;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.ReportQuery;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.Configurator;
import org.apache.ojb.odmg.oql.EnhancedOQLQuery;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.apache.ojb.otm.EditingContext;
import org.apache.ojb.otm.OTMConnection;
import org.apache.ojb.otm.copy.ObjectCopyStrategy;
import org.apache.ojb.otm.core.ConcreteEditingContext;
import org.apache.ojb.otm.core.LockingPassthruException;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.core.TransactionException;
import org.apache.ojb.otm.lock.LockingException;
import org.odmg.ODMGRuntimeException;
import org.odmg.OQLQuery;
import org.odmg.QueryException;

public abstract class BaseConnection
implements OTMConnection {
    private PersistenceBroker _pb;
    private Transaction _tx;
    private ConcreteEditingContext _editingContext;
    private Configurator m_configurator;

    public BaseConnection(PBKey pBKey) {
        this._pb = PersistenceBrokerFactory.createPersistenceBroker(pBKey);
        this.m_configurator = PersistenceBrokerFactory.getConfigurator();
    }

    public void close() {
        this._pb.close();
        this._pb = null;
    }

    public boolean isClosed() {
        if (this._pb == null) {
            return true;
        }
        return this._pb.isClosed();
    }

    public PersistenceBroker getKernelBroker() {
        return this._pb;
    }

    public void setTransaction(Transaction transaction) {
        if (transaction == null) {
            this._editingContext = null;
        } else {
            if (this._tx != null) {
                throw new IllegalStateException("OTMConnection is already bound to the transactaction " + this._tx);
            }
            this._editingContext = new ConcreteEditingContext(transaction, this._pb);
        }
        this._tx = transaction;
    }

    public Transaction getTransaction() {
        return this._tx;
    }

    private static boolean isMaterialized(Object object) {
        IndirectionHandler indirectionHandler;
        if (Proxy.isProxyClass(object.getClass())) {
            indirectionHandler = (IndirectionHandler)Proxy.getInvocationHandler(object);
        } else if (object instanceof VirtualProxy) {
            indirectionHandler = VirtualProxy.getIndirectionHandler((VirtualProxy)object);
        } else {
            return true;
        }
        return indirectionHandler.alreadyMaterialized();
    }

    public Object getObjectByIdentity(Identity identity, int n) throws LockingException {
        Object object = this._editingContext.lookup(identity);
        if (!(object != null && BaseConnection.isMaterialized(object) || (object = this._pb.getObjectByIdentity(identity)) == null)) {
            if (n != 2 || !this._tx.getKit().isImplicitLockingUsed()) {
                // empty if block
            }
            ObjectCopyStrategy objectCopyStrategy = this._tx.getKit().getCopyStrategy(identity);
            object = objectCopyStrategy.copy(object);
        }
        if (object != null) {
            this._editingContext.insert(identity, object, n);
        }
        return object;
    }

    public Object getObjectByIdentity(Identity identity) throws LockingException {
        return this.getObjectByIdentity(identity, 1);
    }

    public Iterator getIteratorByQuery(Query query) {
        return this.getIteratorByQuery(query, 1);
    }

    public Iterator getIteratorByQuery(Query query, int n) {
        return new OTMIterator(this._pb.getIteratorByQuery(query), n, null);
    }

    public Iterator getIteratorByOQLQuery(OQLQuery oQLQuery) {
        return this.getIteratorByOQLQuery(oQLQuery, 1);
    }

    public Iterator getIteratorByOQLQuery(OQLQuery oQLQuery, int n) {
        if (oQLQuery instanceof OTMOQLQueryImpl) {
            OTMOQLQueryImpl oTMOQLQueryImpl = (OTMOQLQueryImpl)oQLQuery;
            return new OTMIterator(this._pb.getIteratorByQuery(oTMOQLQueryImpl.getQuery()), n, oTMOQLQueryImpl);
        }
        throw new IllegalArgumentException("The OQLQuery where created not via OTM API");
    }

    public Collection getCollectionByQuery(Query query, int n) {
        Collection collection = this._pb.getCollectionByQuery(query);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.insertObject(iterator.next(), n);
        }
        return collection;
    }

    public Collection getCollectionByQuery(Query query) {
        return this.getCollectionByQuery(query, 1);
    }

    public Identity getIdentity(Object object) {
        return new Identity(object, this._pb);
    }

    public ClassDescriptor getDescriptorFor(Class clazz) {
        return this._pb.getClassDescriptor(clazz);
    }

    public void invalidate(Identity identity) throws LockingException {
        this._editingContext.insert(identity, null, 2);
        this._pb.serviceObjectCache().remove(identity);
    }

    public ObjectCache serviceObjectCache() {
        return this._pb.serviceObjectCache();
    }

    public void invalidateAll() throws LockingException {
        this._pb.serviceObjectCache().clear();
    }

    public void lockForWrite(Object object) throws LockingException {
        Identity identity = new Identity(object, this._pb);
        this._editingContext.insert(identity, object, 2);
    }

    public void makePersistent(Object object) throws LockingException {
        Identity identity = new Identity(object, this._pb);
        this._editingContext.insert(identity, object, 1);
    }

    public void deletePersistent(Object object) throws LockingException {
        Identity identity = new Identity(object, this._pb);
        this._editingContext.deletePersistent(identity, object);
    }

    public EditingContext getEditingContext() {
        return this._editingContext;
    }

    public EnhancedOQLQuery newOQLQuery() {
        return this.newOQLQuery(1);
    }

    public EnhancedOQLQuery newOQLQuery(int n) {
        OTMOQLQueryImpl oTMOQLQueryImpl = new OTMOQLQueryImpl(this._pb.getPBKey(), n);
        try {
            this.m_configurator.configure(oTMOQLQueryImpl);
        }
        catch (ConfigurationException configurationException) {
            throw new ODMGRuntimeException("Error in configuration of OQLQueryImpl instance: " + configurationException.getMessage());
        }
        return oTMOQLQueryImpl;
    }

    public int getCount(Query query) {
        return this._pb.getCount(query);
    }

    private Object insertObject(Object object, int n) {
        boolean bl = n != 2 || !this._tx.getKit().isImplicitLockingUsed();
        Identity identity = this.getIdentity(object);
        Object object2 = this._editingContext.lookup(identity);
        if (object2 != null) {
            object = object2;
        } else if (bl) {
            ObjectCopyStrategy objectCopyStrategy = this._tx.getKit().getCopyStrategy(identity);
            object = objectCopyStrategy.copy(object);
        }
        try {
            this._editingContext.insert(identity, object, n);
        }
        catch (LockingException lockingException) {
            throw new LockingPassthruException(lockingException);
        }
        return object;
    }

    public abstract void transactionBegin() throws TransactionException;

    public abstract void transactionPrepare() throws TransactionException;

    public abstract void transactionCommit() throws TransactionException;

    public abstract void transactionRollback() throws TransactionException;

    private class OTMOQLQueryImpl
    extends OQLQueryImpl {
        int _lock;

        public OTMOQLQueryImpl(PBKey pBKey, int n) {
            super(pBKey);
            this._lock = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute() throws QueryException {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = null;
            Query query = this.getQuery();
            try {
                if (!(query instanceof ReportQuery)) {
                    Collection collection = BaseConnection.this._pb.getCollectionByQuery(query);
                    iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        arrayList.add(BaseConnection.this.insertObject(iterator.next(), this._lock));
                    }
                } else {
                    iterator = BaseConnection.this._pb.getReportQueryIteratorByQuery(query);
                    block3: while (iterator.hasNext()) {
                        Object[] objectArray = (Object[])iterator.next();
                        if (objectArray.length == 1) {
                            if (objectArray[0] == null) continue;
                            arrayList.add(objectArray[0]);
                            continue;
                        }
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (objectArray[i] == null) continue;
                            arrayList.add(objectArray);
                            continue block3;
                        }
                    }
                }
                this.resetBindIterator();
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (iterator != null && iterator instanceof OJBIterator) {
                    ((OJBIterator)iterator).releaseDbResources();
                }
                throw throwable;
            }
            if (iterator != null && iterator instanceof OJBIterator) {
                ((OJBIterator)iterator).releaseDbResources();
            }
            return arrayList;
        }

        void resetBindIterator() {
            ListIterator listIterator = this.getBindIterator();
            while (listIterator.hasPrevious()) {
                listIterator.previous();
            }
        }
    }

    private class OTMIterator
    implements Iterator {
        private final Iterator _it;
        private final int _lock;
        private final OTMOQLQueryImpl _oqlQuery;

        OTMIterator(Iterator iterator, int n, OTMOQLQueryImpl oTMOQLQueryImpl) {
            this._it = iterator;
            this._lock = n;
            this._oqlQuery = oTMOQLQueryImpl;
        }

        public boolean hasNext() {
            boolean bl = this._it.hasNext();
            if (!bl) {
                this.done();
            }
            return bl;
        }

        public Object next() {
            Object object = this._it.next();
            object = BaseConnection.this.insertObject(object, this._lock);
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void done() {
            if (this._it instanceof OJBIterator) {
                ((OJBIterator)this._it).releaseDbResources();
            }
            if (this._oqlQuery != null) {
                this._oqlQuery.resetBindIterator();
            }
        }

        protected void finalize() {
            this.done();
        }
    }
}

