/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.states;

import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.ObjectModificationDefaultImpl;
import org.apache.ojb.odmg.ObjectEnvelope;
import org.apache.ojb.odmg.states.ModificationState;
import org.apache.ojb.odmg.states.StateNewDelete;
import org.apache.ojb.odmg.states.StateNewDirty;
import org.apache.ojb.odmg.states.StateOldClean;

public class StateNewClean
extends ModificationState {
    private static StateNewClean _instance = new StateNewClean();

    public ModificationState markClean() {
        return this;
    }

    public ModificationState markDelete() {
        return StateNewDelete.getInstance();
    }

    public ModificationState markDirty() {
        return StateNewDirty.getInstance();
    }

    public ModificationState markNew() {
        return this;
    }

    public ModificationState markOld() {
        return StateOldClean.getInstance();
    }

    private StateNewClean() {
    }

    public static StateNewClean getInstance() {
        return _instance;
    }

    public boolean needsInsert() {
        return true;
    }

    public void checkpoint(ObjectEnvelope objectEnvelope, PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        persistenceBroker.store(objectEnvelope.getObject(), ObjectModificationDefaultImpl.INSERT);
        objectEnvelope.manage(objectEnvelope.getObject());
        objectEnvelope.setModificationState(StateOldClean.getInstance());
    }

    public void commit(ObjectEnvelope objectEnvelope, PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        persistenceBroker.store(objectEnvelope.getObject(), ObjectModificationDefaultImpl.INSERT);
        objectEnvelope.manage(objectEnvelope.getObject());
        objectEnvelope.setModificationState(StateOldClean.getInstance());
    }

    public void rollback(ObjectEnvelope objectEnvelope, PersistenceBroker persistenceBroker) {
        this.removeFromCache(objectEnvelope.getObject(), persistenceBroker);
    }
}

