/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import java.util.Collection;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.locking.AbstractLockStrategy;
import org.apache.ojb.odmg.locking.LockEntry;

public class RepeatableReadStrategy
extends AbstractLockStrategy {
    public boolean readLock(TransactionImpl transactionImpl, Object object) {
        LockEntry lockEntry = this.getWriter(object);
        if (lockEntry == null) {
            if (this.addReader(transactionImpl, object)) {
                return true;
            }
            return this.readLock(transactionImpl, object);
        }
        return lockEntry.isOwnedBy(transactionImpl);
    }

    public boolean writeLock(TransactionImpl transactionImpl, Object object) {
        LockEntry lockEntry = this.getWriter(object);
        Collection collection = this.getReaders(object);
        if (lockEntry == null) {
            if (collection.size() == 0) {
                if (this.setWriter(transactionImpl, object)) {
                    return true;
                }
                return this.writeLock(transactionImpl, object);
            }
            if (collection.size() == 1 && ((LockEntry)collection.iterator().next()).isOwnedBy(transactionImpl)) {
                return this.upgradeLock(transactionImpl, object);
            }
        } else if (lockEntry.isOwnedBy(transactionImpl)) {
            return true;
        }
        return false;
    }

    public boolean upgradeLock(TransactionImpl transactionImpl, Object object) {
        LockEntry lockEntry = this.getWriter(object);
        if (lockEntry == null) {
            Collection collection = this.getReaders(object);
            if (collection.size() == 1) {
                LockEntry lockEntry2 = (LockEntry)collection.iterator().next();
                if (lockEntry2.isOwnedBy(transactionImpl)) {
                    if (this.upgradeLock(lockEntry2)) {
                        return true;
                    }
                    return this.upgradeLock(transactionImpl, object);
                }
            } else if (collection.size() == 0) {
                if (this.setWriter(transactionImpl, object)) {
                    return true;
                }
                return this.upgradeLock(transactionImpl, object);
            }
        } else if (lockEntry.isOwnedBy(transactionImpl)) {
            return true;
        }
        return false;
    }

    public boolean releaseLock(TransactionImpl transactionImpl, Object object) {
        LockEntry lockEntry = this.getWriter(object);
        if (lockEntry != null && lockEntry.isOwnedBy(transactionImpl)) {
            this.removeWriter(lockEntry);
            return true;
        }
        if (this.hasReadLock(transactionImpl, object)) {
            this.removeReader(transactionImpl, object);
            return true;
        }
        return false;
    }

    public boolean checkRead(TransactionImpl transactionImpl, Object object) {
        if (this.hasReadLock(transactionImpl, object)) {
            return true;
        }
        LockEntry lockEntry = this.getWriter(object);
        return lockEntry != null && lockEntry.isOwnedBy(transactionImpl);
    }

    public boolean checkWrite(TransactionImpl transactionImpl, Object object) {
        LockEntry lockEntry = this.getWriter(object);
        return lockEntry != null && lockEntry.isOwnedBy(transactionImpl);
    }
}

