/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldFactory;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListEntry;
import org.apache.ojb.odmg.collections.DListIterator;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DArray;
import org.odmg.DCollection;
import org.odmg.DList;
import org.odmg.ODMGRuntimeException;
import org.odmg.QueryInvalidException;

public class DListImpl
extends AbstractList
implements DList,
DArray,
ManageableCollection,
Serializable {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DListImpl == null ? (class$org$apache$ojb$odmg$collections$DListImpl = DListImpl.class$("org.apache.ojb.odmg.collections.DListImpl")) : class$org$apache$ojb$odmg$collections$DListImpl);
    private int id = -1;
    private Vector elements = new Vector();
    private int size;
    protected PBKey pbKey;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DListImpl;

    public DListImpl() {
        this.size = 0;
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
    }

    public DListImpl(PBKey pBKey) {
        this.size = 0;
        this.pbKey = pBKey;
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
    }

    public DListImpl(int n, int n2) {
        this.id = n;
        this.size = n2;
    }

    public PBKey getPBKey() {
        return this.pbKey;
    }

    public void setPBKey(PBKey pBKey) {
        this.pbKey = pBKey;
    }

    public void add(int n, Object object) {
        ++this.size;
        DListEntry dListEntry = new DListEntry(this, object);
        this.elements.add(n, dListEntry);
        TransactionImpl transactionImpl = TxManagerFactory.instance().getTransaction();
        if (transactionImpl != null && transactionImpl.isOpen()) {
            transactionImpl.lock(this, 4);
            transactionImpl.lock(dListEntry, 4);
            transactionImpl.lock(object, 1);
        }
        int n2 = 0;
        try {
            n2 = ((DListEntry)this.elements.get(n - 1)).getPosition();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = n2; i < this.elements.size(); ++i) {
            dListEntry = (DListEntry)this.elements.get(i);
            dListEntry.setPosition(i);
        }
    }

    public Object remove(int n) {
        DListEntry dListEntry = (DListEntry)this.elements.get(n);
        TransactionImpl transactionImpl = TxManagerFactory.instance().getTransaction();
        if (transactionImpl != null && transactionImpl.isOpen()) {
            transactionImpl.markDelete(dListEntry);
        }
        --this.size;
        this.elements.remove(n);
        int n2 = 0;
        try {
            n2 = ((DListEntry)this.elements.get(n)).getPosition();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = n2; i < this.elements.size(); ++i) {
            dListEntry = (DListEntry)this.elements.get(i);
            dListEntry.setPosition(i);
        }
        return dListEntry.getRealSubject();
    }

    public DList concat(DList dList) {
        DListImpl dListImpl = new DListImpl(this.pbKey);
        dListImpl.addAll(this);
        dListImpl.addAll(dList);
        return dListImpl;
    }

    public boolean existsElement(String string) throws QueryInvalidException {
        DList dList = (DList)this.query(string);
        return dList != null && dList.size() != 0;
    }

    protected int generateNewId() {
        PBCapsule pBCapsule = new PBCapsule(null, TxManagerFactory.instance().getTransaction());
        try {
            int n;
            PersistenceBroker persistenceBroker = pBCapsule.getBroker();
            FieldDescriptor fieldDescriptor = persistenceBroker.getClassDescriptor(this.getClass()).getAutoIncrementField();
            Integer n2 = (Integer)persistenceBroker.serviceSequenceManager().getUniqueValue(fieldDescriptor);
            int n3 = n = n2.intValue();
            return n3;
        }
        catch (Exception exception) {
            this.log.error("Generation of new id failed", exception);
            throw new PersistenceBrokerException(exception);
        }
        finally {
            pBCapsule.destroy();
        }
    }

    public Object get(int n) {
        DListEntry dListEntry = (DListEntry)this.elements.get(n);
        return dListEntry.getRealSubject();
    }

    public Vector getElements() {
        return this.elements;
    }

    public int getId() {
        if (this.id == -1) {
            this.id = this.generateNewId();
        }
        return this.id;
    }

    public Iterator iterator() {
        return new DListIterator(this);
    }

    public ListIterator listIterator() {
        return new DListIterator(this);
    }

    public ListIterator listIterator(int n) {
        return new DListIterator(this, n);
    }

    private Criteria getPkCriteriaForAllElements(PersistenceBroker persistenceBroker) {
        try {
            Criteria criteria = null;
            for (int i = 0; i < this.elements.size(); ++i) {
                DListEntry dListEntry = (DListEntry)this.elements.get(i);
                Object object = dListEntry.getRealSubject();
                ClassDescriptor classDescriptor = persistenceBroker.getClassDescriptor(object.getClass());
                FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
                Object[] objectArray = persistenceBroker.serviceBrokerHelper().getKeyValues(classDescriptor, object);
                Criteria criteria2 = new Criteria();
                for (int j = 0; j < fieldDescriptorArray.length; ++j) {
                    FieldDescriptor fieldDescriptor = fieldDescriptorArray[j];
                    criteria2.addEqualTo(fieldDescriptor.getPersistentField().getName(), objectArray[j]);
                }
                if (criteria == null) {
                    criteria = criteria2;
                    continue;
                }
                criteria.addOrCriteria(criteria2);
            }
            return criteria;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            return null;
        }
    }

    private Class getElementsExtentClass(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        DListEntry dListEntry = (DListEntry)this.elements.get(0);
        Class<?> clazz = dListEntry.getRealSubject().getClass();
        Class clazz2 = persistenceBroker.getTopLevelClass(clazz);
        return clazz2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DCollection query(String string) throws QueryInvalidException {
        DListImpl dListImpl;
        String string2 = "select all from java.lang.Object where " + string;
        OQLQueryImpl oQLQueryImpl = new OQLQueryImpl(this.pbKey);
        oQLQueryImpl.create(string2);
        Query query = oQLQueryImpl.getQuery();
        Criteria criteria = query.getCriteria();
        PBCapsule pBCapsule = new PBCapsule(this.pbKey, TxManagerFactory.instance().getTransaction());
        try {
            PersistenceBroker persistenceBroker = pBCapsule.getBroker();
            Criteria criteria2 = this.getPkCriteriaForAllElements(persistenceBroker);
            criteria2.addAndCriteria(criteria);
            Class clazz = null;
            try {
                clazz = this.getElementsExtentClass(persistenceBroker);
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                throw new ODMGRuntimeException(persistenceBrokerException.getMessage());
            }
            QueryByCriteria queryByCriteria = new QueryByCriteria(clazz, criteria2);
            if (this.log.isDebugEnabled()) {
                this.log.debug(((Object)queryByCriteria).toString());
            }
            dListImpl = null;
            try {
                dListImpl = (DListImpl)persistenceBroker.getCollectionByQuery(class$org$apache$ojb$odmg$collections$DListImpl == null ? (class$org$apache$ojb$odmg$collections$DListImpl = DListImpl.class$("org.apache.ojb.odmg.collections.DListImpl")) : class$org$apache$ojb$odmg$collections$DListImpl, queryByCriteria);
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                this.log.error("Query failed", (Throwable)((Object)persistenceBrokerException));
                throw new OJBRuntimeException((Throwable)((Object)persistenceBrokerException));
            }
        }
        finally {
            if (pBCapsule != null) {
                pBCapsule.destroy();
            }
        }
        return dListImpl;
    }

    public Iterator select(String string) throws QueryInvalidException {
        return this.query(string).iterator();
    }

    public Object selectElement(String string) throws QueryInvalidException {
        return ((DList)this.query(string)).get(0);
    }

    public int size() {
        return this.elements.size();
    }

    public void ojbAdd(Object object) {
        ++this.size;
        DListEntry dListEntry = new DListEntry(this, object);
        dListEntry.setPosition(this.elements.size());
        this.elements.add(dListEntry);
    }

    public void ojbAddAll(ManageableCollection manageableCollection) {
        Iterator iterator = manageableCollection.ojbIterator();
        while (iterator.hasNext()) {
            this.ojbAdd(iterator.next());
        }
    }

    public void afterStore(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public Iterator ojbIterator() {
        return this.iterator();
    }

    public void resize(int n) {
    }

    public void setElements(Vector vector) {
        this.elements = vector;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

